/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.com.github.benmanes.caffeine.cache;

import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.DisabledFuture;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.Scheduler;
import com.newrelic.agent.deps.org.checkerframework.checker.nullness.qual.NonNull;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

final class GuardedScheduler
implements Scheduler,
Serializable {
    static final Logger logger;
    static final long serialVersionUID = 1L;
    final Scheduler delegate;

    GuardedScheduler(Scheduler delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public @NonNull Future<?> schedule(@NonNull Executor executor, @NonNull Runnable command, long delay, @NonNull TimeUnit unit) {
        try {
            Future<?> future = this.delegate.schedule(executor, command, delay, unit);
            return future == null ? DisabledFuture.INSTANCE : future;
        }
        catch (Throwable t2) {
            logger.log(Level.WARNING, "Exception thrown by scheduler; discarded task", t2);
            return DisabledFuture.INSTANCE;
        }
    }

    static {
        GuardedScheduler.class.getName();
        logger = Logger.global;
    }
}

