/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.agentcontrol;

import com.newrelic.agent.Agent;
import com.newrelic.agent.agentcontrol.AgentControlControlIntegrationHealthFileBasedClient;
import com.newrelic.agent.agentcontrol.AgentControlHealthNoOpClientControl;
import com.newrelic.agent.agentcontrol.AgentControlIntegrationHealthClient;
import com.newrelic.agent.config.AgentControlIntegrationConfig;
import java.util.logging.Level;

public class AgentControlIntegrationClientFactory {
    private static final AgentControlIntegrationHealthClient NO_OP_INSTANCE = new AgentControlHealthNoOpClientControl();

    public static AgentControlIntegrationHealthClient createHealthClient(AgentControlIntegrationConfig config) {
        AgentControlIntegrationHealthClient client;
        try {
            HealthClientType healthClientType = HealthClientType.valueOf(config.getHealthClientType());
            Agent.LOG.log(Level.INFO, "Generating Agent Control Health Client type: {0}", (Object)healthClientType);
            switch (healthClientType) {
                case file: {
                    client = new AgentControlControlIntegrationHealthFileBasedClient(config);
                    break;
                }
                default: {
                    client = NO_OP_INSTANCE;
                    break;
                }
            }
        }
        catch (Exception e) {
            Agent.LOG.log(Level.WARNING, "Invalid health client type: {0}; returning NoOp implementation", config.getHealthClientType());
            client = NO_OP_INSTANCE;
        }
        return client;
    }

    public static enum HealthClientType {
        noop,
        file;

    }
}

