/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.utils;

import com.newrelic.weave.utils.ClassFinder;
import com.newrelic.weave.utils.ClassInformation;
import com.newrelic.weave.utils.ClassInformationFinder;
import com.newrelic.weave.utils.Streams;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ClassCache
implements ClassInformationFinder {
    private static final byte[] NO_CLASS_BYTES = new byte[0];
    private static final ClassInformation NO_CLASS_INFORMATION = new ClassInformation();
    private final ClassFinder classFinder;
    private final ConcurrentMap<String, Boolean> classExistsCache = new ConcurrentHashMap<String, Boolean>();
    private final ConcurrentMap<String, byte[]> classBytesCache = new ConcurrentHashMap<String, byte[]>();
    private final ConcurrentMap<String, ClassInformation> classInformationCache = new ConcurrentHashMap<String, ClassInformation>();

    public ClassCache(ClassFinder classFinder) {
        this.classFinder = classFinder;
    }

    public boolean hasClassResource(String internalName) {
        Boolean result = (Boolean)this.classExistsCache.get(internalName);
        if (result != null) {
            return result;
        }
        URL resource = this.classFinder.findResource(internalName);
        boolean hasResource = resource != null;
        this.classExistsCache.putIfAbsent(internalName, hasResource);
        return hasResource;
    }

    public byte[] getClassResource(String internalName) throws IOException {
        byte[] result = (byte[])this.classBytesCache.get(internalName);
        if (result != null) {
            return result == NO_CLASS_BYTES ? null : result;
        }
        URL resource = this.classFinder.findResource(internalName);
        if (resource == null) {
            this.classBytesCache.putIfAbsent(internalName, NO_CLASS_BYTES);
            return null;
        }
        result = Streams.read(resource.openStream(), true);
        this.classBytesCache.putIfAbsent(internalName, result);
        return result;
    }

    @Override
    public ClassInformation getClassInformation(String internalName) throws IOException {
        ClassInformation result = (ClassInformation)this.classInformationCache.get(internalName);
        if (result != null) {
            return result == NO_CLASS_INFORMATION ? null : result;
        }
        byte[] classBytes = this.getClassResource(internalName);
        if (classBytes == null) {
            this.classInformationCache.putIfAbsent(internalName, NO_CLASS_INFORMATION);
            return null;
        }
        result = ClassInformation.fromClassBytes(classBytes);
        this.classInformationCache.putIfAbsent(internalName, result);
        return result;
    }
}

