/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.tosummary;

import com.newrelic.jfr.RecordedObjectValidators;
import com.newrelic.jfr.tosummary.BaseDurationSummarizer;
import com.newrelic.jfr.tosummary.EventToSummary;
import com.newrelic.jfr.tosummary.PairSummarizer;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.metrics.Summary;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import jdk.jfr.consumer.RecordedEvent;

public final class GCHeapSummarySummarizer
implements EventToSummary {
    public static final String SIMPLE_CLASS_NAME = GCHeapSummarySummarizer.class.getSimpleName();
    public static final String EVENT_NAME = "jdk.GCHeapSummary";
    public static final String BEFORE = "Before GC";
    public static final String AFTER = "After GC";
    public static final String GC_ID = "gcId";
    public static final String WHEN = "when";
    private final Map<Long, RecordedEvent> awaitingPairs = new HashMap<Long, RecordedEvent>();
    private final PairSummarizer summarizer;
    private int count = 0;
    private long startTimeMs;
    private long endTimeMs = 0L;

    public GCHeapSummarySummarizer() {
        this(Instant.now().toEpochMilli());
    }

    public GCHeapSummarySummarizer(long startTimeMs) {
        this(startTimeMs, new PairSummarizer(startTimeMs, BaseDurationSummarizer.DEFAULT_CLOCK, "duration"));
    }

    public GCHeapSummarySummarizer(long startTimeMs, PairSummarizer summarizer) {
        this.startTimeMs = startTimeMs;
        this.summarizer = summarizer;
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public void accept(RecordedEvent ev) {
        RecordedEvent pair;
        this.endTimeMs = ev.getStartTime().toEpochMilli();
        String when = null;
        if (RecordedObjectValidators.hasField(ev, WHEN, SIMPLE_CLASS_NAME)) {
            when = ev.getString(WHEN);
        }
        if (when != null && !when.equals(BEFORE) && !when.equals(AFTER)) {
            return;
        }
        ++this.count;
        long gcId = 0L;
        if (RecordedObjectValidators.hasField(ev, GC_ID, SIMPLE_CLASS_NAME)) {
            gcId = ev.getLong(GC_ID);
        }
        if ((pair = this.awaitingPairs.get(gcId)) == null) {
            this.awaitingPairs.put(gcId, ev);
        } else {
            this.awaitingPairs.remove(gcId);
            if (when != null && when.equals(BEFORE)) {
                this.summarizer.accept(ev, pair);
            } else {
                this.summarizer.accept(pair, ev);
            }
        }
    }

    @Override
    public Stream<Summary> summarize() {
        Attributes attr = new Attributes();
        Summary out = new Summary("jfr.GarbageCollection.duration", this.count, this.summarizer.getDurationMillis(), this.summarizer.getMinDurationMillis(), this.summarizer.getMaxDurationMillis(), this.startTimeMs, this.endTimeMs, attr);
        this.reset();
        return Stream.of(out);
    }

    @Override
    public void reset() {
        this.startTimeMs = Instant.now().toEpochMilli();
        this.endTimeMs = 0L;
        this.count = 0;
        this.summarizer.reset();
    }
}

