/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracing.samplers;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.config.SamplerConfig;
import com.newrelic.agent.tracing.samplers.Sampler;
import com.newrelic.api.agent.NewRelic;
import java.util.logging.Level;

public class TraceRatioBasedSampler
implements Sampler {
    private final long threshold;

    public TraceRatioBasedSampler(SamplerConfig samplerConfig) {
        float traceRatio = samplerConfig.getSamplerRatio().floatValue();
        if (!Float.isNaN(traceRatio)) {
            this.threshold = (long)(9.223372E18f * traceRatio);
            NewRelic.getAgent().getLogger().log(Level.INFO, "TraceRatioBasedSampler: threshold {0}", (Object)this.threshold);
        } else {
            this.threshold = 0L;
            NewRelic.getAgent().getLogger().log(Level.WARNING, "TraceRatioBasedSampler: Invalid sampling ratio supplied; setting threshold to {0}", (Object)this.threshold);
        }
    }

    @Override
    public float calculatePriority(Transaction tx) {
        String traceId = Sampler.traceIdFromTransaction(tx);
        if (traceId != null && traceId.length() == 32) {
            try {
                String last16Chars = traceId.substring(16);
                return Math.abs(Long.parseUnsignedLong(last16Chars, 16)) <= this.threshold ? 2.0f : 0.0f;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    @Override
    public String getType() {
        return "trace_id_ratio_based";
    }

    public long getThreshold() {
        return this.threshold;
    }
}

