/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.stats;

import com.newrelic.agent.metric.MetricName;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsWork;

public final class RecordDataUsageMetric
implements StatsWork {
    private final MetricName name;
    private final long bytesSent;
    private final long bytesReceived;

    public RecordDataUsageMetric(String name, long bytesSent, long bytesReceived) {
        this.name = MetricName.create(name);
        this.bytesSent = bytesSent;
        this.bytesReceived = bytesReceived;
    }

    @Override
    public void doWork(StatsEngine statsEngine) {
        statsEngine.getDataUsageStats(this.name).recordDataUsage(this.bytesSent, this.bytesReceived);
    }

    @Override
    public String getAppName() {
        return null;
    }

    public String getName() {
        return this.name.getName();
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }
}

