/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.slowtransactions;

import com.newrelic.agent.ExtendedTransactionListener;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.SlowTransactionsConfig;
import com.newrelic.agent.model.CustomInsightsEvent;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.analytics.InsightsService;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracing.DistributedTraceServiceImpl;
import com.newrelic.agent.util.StackTraces;
import com.newrelic.api.agent.NewRelic;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.annotation.Nullable;

public class SlowTransactionService
extends AbstractService
implements ExtendedTransactionListener,
HarvestListener {
    private final ConcurrentHashMap<String, Transaction> openTransactions = new ConcurrentHashMap();
    private final ThreadMXBean threadMXBean;
    private final boolean isEnabled;
    private final long thresholdMillis;
    private final int maxStackTraceLines;
    private final boolean evalCompletedTransactions;
    @Nullable
    private InsightsService insightsService;

    public SlowTransactionService(AgentConfig agentConfig) {
        this(agentConfig, ManagementFactory.getThreadMXBean());
    }

    SlowTransactionService(AgentConfig agentConfig, ThreadMXBean threadMXBean) {
        super(SlowTransactionService.class.getSimpleName());
        SlowTransactionsConfig slowTransactionsConfig = agentConfig.getSlowTransactionsConfig();
        this.isEnabled = slowTransactionsConfig.isEnabled();
        this.thresholdMillis = slowTransactionsConfig.getThresholdMillis();
        this.maxStackTraceLines = agentConfig.getMaxStackTraceLines();
        this.threadMXBean = threadMXBean;
        this.evalCompletedTransactions = slowTransactionsConfig.evaluateCompletedTransactions();
        NewRelic.getAgent().getMetricAggregator().incrementCounter(agentConfig.getSlowTransactionsConfig().isEnabled() ? "Supportability/SlowTransactionDetection/enabled" : "Supportability/SlowTransactionDetection/disabled");
    }

    @Override
    protected void doStart() throws Exception {
        if (!this.isEnabled) {
            return;
        }
        ServiceFactory.getTransactionService().addTransactionListener(this);
        ServiceFactory.getHarvestService().addHarvestListener(this);
        this.insightsService = ServiceFactory.getServiceManager().getInsights();
    }

    @Override
    protected void doStop() throws Exception {
        if (!this.isEnabled) {
            return;
        }
        ServiceFactory.getTransactionService().removeTransactionListener(this);
        ServiceFactory.getHarvestService().removeHarvestListener(this);
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void dispatcherTransactionStarted(Transaction transaction) {
        if (this.getLogger().isLoggable(Level.FINEST)) {
            this.getLogger().finest("Transaction started with id " + transaction.getGuid());
        }
        this.openTransactions.put(transaction.getGuid(), transaction);
    }

    @Override
    public void dispatcherTransactionCancelled(Transaction transaction) {
        if (this.getLogger().isLoggable(Level.FINEST)) {
            this.getLogger().finest("Transaction cancelled with guid " + transaction.getGuid());
        }
        this.openTransactions.remove(transaction.getGuid());
    }

    @Override
    public void dispatcherTransactionFinished(TransactionData transactionData, TransactionStats transactionStats) {
        long txnExecutionTimeInMs;
        Transaction txn;
        if (this.getLogger().isLoggable(Level.FINEST)) {
            this.getLogger().finest("Transaction finished with guid " + transactionData.getGuid());
        }
        if ((txn = this.openTransactions.remove(transactionData.getGuid())) != null && this.evalCompletedTransactions && (txnExecutionTimeInMs = System.currentTimeMillis() - txn.getWallClockStartTimeMs()) > this.thresholdMillis) {
            this.reportSlowTransaction(txn, txnExecutionTimeInMs, true);
        }
    }

    Map<String, Transaction> getOpenTransactions() {
        return Collections.unmodifiableMap(this.openTransactions);
    }

    @Override
    public void beforeHarvest(String appName, StatsEngine statsEngine) {
        this.run();
    }

    @Override
    public void afterHarvest(String appName) {
    }

    void run() {
        if (this.getLogger().isLoggable(Level.FINE)) {
            this.getLogger().fine("Identifying slow threads. Open transactions: " + this.openTransactions.size());
        }
        Transaction slowestOpen = null;
        long slowestOpenMillis = this.thresholdMillis;
        for (Transaction transaction : this.openTransactions.values()) {
            long openMs = System.currentTimeMillis() - transaction.getWallClockStartTimeMs();
            if (openMs <= slowestOpenMillis) continue;
            slowestOpen = transaction;
            slowestOpenMillis = openMs;
        }
        if (slowestOpen == null) {
            this.getLogger().fine("No new slow transactions identified.");
            return;
        }
        this.reportSlowTransaction(slowestOpen, slowestOpenMillis, false);
        this.openTransactions.remove(slowestOpen.getGuid());
    }

    Map<String, Object> extractMetadata(Transaction transaction, long openMillis) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.putAll(transaction.getUserAttributes());
        attributes.putAll(transaction.getErrorAttributes());
        attributes.putAll(transaction.getAgentAttributes());
        attributes.putAll(transaction.getIntrinsicAttributes());
        attributes.put("guid", transaction.getGuid());
        attributes.put("name", transaction.getPriorityTransactionName().getName());
        attributes.put("transactionType", transaction.getPriorityTransactionName().getCategory());
        attributes.put("timestamp", transaction.getWallClockStartTimeMs());
        attributes.put("elapsed_ms", openMillis);
        long initiatingThreadId = transaction.getInitiatingThreadId();
        attributes.put("thread.id", initiatingThreadId);
        ThreadInfo threadInfo = this.threadMXBean.getThreadInfo(initiatingThreadId, this.maxStackTraceLines);
        if (threadInfo != null) {
            attributes.put("thread.name", threadInfo.getThreadName());
            attributes.put("thread.state", threadInfo.getThreadState().name());
            List<StackTraceElement> scrubbedStackTraceElements = StackTraces.scrubAndTruncate(threadInfo.getStackTrace());
            attributes.put("code.stacktrace", SlowTransactionService.stackTraceString(scrubbedStackTraceElements));
        }
        return attributes;
    }

    private void reportSlowTransaction(Transaction slowTxn, long txnExecutionTimeInMs, boolean isCompleted) {
        Map<String, Object> attributes = this.extractMetadata(slowTxn, txnExecutionTimeInMs);
        if (this.getLogger().isLoggable(Level.FINE)) {
            this.getLogger().fine("Reporting " + (isCompleted ? "completed" : "in progress") + " slow transaction with guid " + slowTxn.getGuid() + " with execution time of " + txnExecutionTimeInMs + "ms, attributes: " + attributes);
        }
        if (this.insightsService != null) {
            this.insightsService.storeEvent(ServiceFactory.getRPMService().getApplicationName(), new CustomInsightsEvent("SlowTransaction", System.currentTimeMillis(), attributes, DistributedTraceServiceImpl.nextTruncatedFloat()));
        }
    }

    private static String stackTraceString(List<StackTraceElement> stackTrace) {
        if (stackTrace.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(stackTrace.get(0)).append("\n");
        for (int i = 1; i < stackTrace.size(); ++i) {
            stringBuilder.append("\tat ").append(stackTrace.get(i)).append("\n");
        }
        return stringBuilder.toString();
    }
}

