/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.org.slf4j.impl;

import com.newrelic.agent.deps.org.slf4j.ILoggerFactory;
import com.newrelic.agent.deps.org.slf4j.Logger;
import com.newrelic.agent.deps.org.slf4j.helpers.FormattingTuple;
import com.newrelic.agent.deps.org.slf4j.helpers.MarkerIgnoringBase;
import com.newrelic.agent.deps.org.slf4j.helpers.MessageFormatter;
import com.newrelic.agent.deps.org.slf4j.impl.SimpleLoggerFactory;
import com.newrelic.agent.deps.org.slf4j.spi.LoggerFactoryBinder;
import com.newrelic.api.agent.NewRelic;
import java.util.logging.Level;

public class StaticLoggerBinder
implements LoggerFactoryBinder {
    private static final StaticLoggerBinder SINGLETON = new StaticLoggerBinder();
    private static final String LOGGER_NAME = "com.newrelic.jfr.logger";
    public static String REQUESTED_API_VERSION = "1.6.99";
    private static final String loggerFactoryClassStr = AgentLoggerFactory.class.getName();
    private final ILoggerFactory loggerFactory;

    public static StaticLoggerBinder getSingleton() {
        return SINGLETON;
    }

    private StaticLoggerBinder() {
        if (this.isNewRelicAgentApiPresent()) {
            com.newrelic.api.agent.Logger agentLogger = NewRelic.getAgent().getLogger();
            this.loggerFactory = new AgentLoggerFactory(new AgentLoggerAdapter(agentLogger));
        } else {
            this.loggerFactory = new SimpleLoggerFactory();
        }
    }

    @Override
    public ILoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    @Override
    public String getLoggerFactoryClassStr() {
        return loggerFactoryClassStr;
    }

    private boolean isNewRelicAgentApiPresent() {
        try {
            Class.forName("com.newrelic.api.agent.NewRelic");
            return true;
        }
        catch (ClassNotFoundException __) {
            return false;
        }
    }

    private static class AgentLoggerAdapter
    extends MarkerIgnoringBase {
        private final com.newrelic.api.agent.Logger logger;

        private AgentLoggerAdapter(com.newrelic.api.agent.Logger agentLogger) {
            this.logger = agentLogger;
        }

        @Override
        public String getName() {
            return StaticLoggerBinder.LOGGER_NAME;
        }

        public void formatAndLog(Level level, String format, Object ... arguments) {
            FormattingTuple tp = MessageFormatter.arrayFormat(format, arguments);
            Throwable throwable = tp.getThrowable();
            String message = tp.getMessage();
            if (throwable != null) {
                this.logger.log(level, throwable, message);
            } else {
                this.logger.log(level, message);
            }
        }

        @Override
        public boolean isTraceEnabled() {
            return true;
        }

        @Override
        public void trace(String s2) {
            this.formatAndLog(Level.FINEST, s2, new Object[0]);
        }

        @Override
        public void trace(String s2, Object o) {
            this.formatAndLog(Level.FINEST, s2, o);
        }

        @Override
        public void trace(String s2, Object o, Object o1) {
            this.formatAndLog(Level.FINEST, s2, o, o1);
        }

        @Override
        public void trace(String s2, Object ... objects) {
            this.formatAndLog(Level.FINEST, s2, objects);
        }

        @Override
        public void trace(String s2, Throwable throwable) {
            this.formatAndLog(Level.FINEST, s2, throwable);
        }

        @Override
        public boolean isDebugEnabled() {
            return true;
        }

        @Override
        public void debug(String s2) {
            this.formatAndLog(Level.FINEST, s2, new Object[0]);
        }

        @Override
        public void debug(String s2, Object o) {
            this.formatAndLog(Level.FINEST, s2, o);
        }

        @Override
        public void debug(String s2, Object o, Object o1) {
            this.formatAndLog(Level.FINEST, s2, o, o1);
        }

        @Override
        public void debug(String s2, Object ... objects) {
            this.formatAndLog(Level.FINEST, s2, objects);
        }

        @Override
        public void debug(String s2, Throwable throwable) {
            this.formatAndLog(Level.FINEST, s2, throwable);
        }

        @Override
        public boolean isInfoEnabled() {
            return true;
        }

        @Override
        public void info(String s2) {
            this.formatAndLog(Level.INFO, s2, new Object[0]);
        }

        @Override
        public void info(String s2, Object o) {
            this.formatAndLog(Level.INFO, s2, o);
        }

        @Override
        public void info(String s2, Object o, Object o1) {
            this.formatAndLog(Level.INFO, s2, o, o1);
        }

        @Override
        public void info(String s2, Object ... objects) {
            this.formatAndLog(Level.INFO, s2, objects);
        }

        @Override
        public void info(String s2, Throwable throwable) {
            this.formatAndLog(Level.INFO, s2, throwable);
        }

        @Override
        public boolean isWarnEnabled() {
            return true;
        }

        @Override
        public void warn(String s2) {
            this.formatAndLog(Level.WARNING, s2, new Object[0]);
        }

        @Override
        public void warn(String s2, Object o) {
            this.formatAndLog(Level.WARNING, s2, o);
        }

        @Override
        public void warn(String s2, Object ... objects) {
            this.formatAndLog(Level.WARNING, s2, objects);
        }

        @Override
        public void warn(String s2, Object o, Object o1) {
            this.formatAndLog(Level.WARNING, s2, o, o1);
        }

        @Override
        public void warn(String s2, Throwable throwable) {
            this.formatAndLog(Level.WARNING, s2, throwable);
        }

        @Override
        public boolean isErrorEnabled() {
            return true;
        }

        @Override
        public void error(String s2) {
            this.formatAndLog(Level.SEVERE, s2, new Object[0]);
        }

        @Override
        public void error(String s2, Object o) {
            this.formatAndLog(Level.SEVERE, s2, o);
        }

        @Override
        public void error(String s2, Object o, Object o1) {
            this.formatAndLog(Level.SEVERE, s2, o, o1);
        }

        @Override
        public void error(String s2, Object ... objects) {
            this.formatAndLog(Level.SEVERE, s2, objects);
        }

        @Override
        public void error(String s2, Throwable throwable) {
            this.formatAndLog(Level.SEVERE, s2, throwable);
        }
    }

    private static class AgentLoggerFactory
    implements ILoggerFactory {
        private final AgentLoggerAdapter agentLoggerAdapter;

        private AgentLoggerFactory(AgentLoggerAdapter agentLoggerAdapter) {
            this.agentLoggerAdapter = agentLoggerAdapter;
        }

        @Override
        public Logger getLogger(String name) {
            return this.agentLoggerAdapter;
        }
    }
}

