/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.internal.DefaultSystemProps;
import com.newrelic.agent.config.internal.MapSystemProps;
import com.newrelic.agent.deps.org.json.simple.parser.JSONParser;
import com.newrelic.agent.deps.org.json.simple.parser.ParseException;
import com.newrelic.agent.discovery.AgentArguments;
import java.util.Collections;
import java.util.Properties;
import java.util.logging.Level;

public abstract class SystemProps {
    static SystemProps getSystemProps() {
        try {
            String agentArgs = System.getProperty("nr-internal-agent-args");
            if (agentArgs != null) {
                try {
                    AgentArguments args2 = AgentArguments.fromJsonObject(new JSONParser().parse(agentArgs));
                    return new MapSystemProps(args2.getSystemProperties());
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
            return new DefaultSystemProps();
        }
        catch (SecurityException e) {
            Agent.LOG.log(Level.SEVERE, e, "Unable to access system properties because of a security exception.");
            return new MapSystemProps(Collections.emptyMap());
        }
    }

    public abstract String getSystemProperty(String var1);

    public abstract Properties getAllSystemProperties();
}

