/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.MetricNames;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.ErrorCollectorConfig;
import com.newrelic.agent.config.ExpectedErrorConfig;
import com.newrelic.agent.config.ExpectedErrorConfigImpl;
import com.newrelic.agent.config.IgnoreErrorConfig;
import com.newrelic.agent.config.IgnoreErrorConfigImpl;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public final class ErrorCollectorConfigImpl
extends BaseConfig
implements ErrorCollectorConfig {
    public static final String ENABLED = "enabled";
    public static final String COLLECT_ERRORS = "collect_errors";
    public static final String IGNORE_ERRORS = "ignore_errors";
    public static final String IGNORE_CLASSES = "ignore_classes";
    public static final String IGNORE_MESSAGES = "ignore_messages";
    public static final String IGNORE_CLASS_NAME = "class_name";
    public static final String IGNORE_MESSAGE = "message";
    public static final String IGNORE_STATUS_CODES = "ignore_status_codes";
    public static final String IGNORE_ERROR_PRIORITY = "ignoreErrorPriority";
    public static final String EXCEPTION_HANDLERS = "exception_handlers";
    public static final boolean DEFAULT_ENABLED = true;
    public static final boolean DEFAULT_COLLECT_ERRORS = true;
    public static final Set<Integer> DEFAULT_IGNORE_STATUS_CODES = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(404)));
    public static final String COLLECT_EVENTS = "collect_error_events";
    public static final boolean DEFAULT_COLLECT_EVENTS = true;
    public static final String CAPTURE_EVENTS = "capture_events";
    public static final boolean DEFAULT_CAPTURE_EVENTS = true;
    public static final String MAX_EVENT_SAMPLES_STORED = "max_event_samples_stored";
    public static final int DEFAULT_MAX_EVENT_SAMPLES_STORED = 100;
    private static final boolean DEFAULT_IGNORE_ERROR_PRIORITY = true;
    private static final Object DEFAULT_EXCEPTION_HANDLERS = Collections.emptyList();
    public static final String EXPECTED_CLASSES = "expected_classes";
    public static final String EXPECTED_MESSAGES = "expected_messages";
    public static final String CLASS_NAME = "class_name";
    public static final String MESSAGE = "message";
    public static final String EXPECTED_STATUS_CODES = "expected_status_codes";
    public static final Set<String> DEFAULT_IGNORE_ERRORS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("akka.actor.ActorKilledException")));
    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.error_collector.";
    private final boolean isEnabled = this.initEnabled();
    private Set<IgnoreErrorConfig> ignoreErrors = this.initIgnoreErrors();
    private Set<Integer> ignoreStatusCodes = this.initStatusCodes("ignore_status_codes", DEFAULT_IGNORE_STATUS_CODES);
    private Set<ExpectedErrorConfig> expectedErrors = this.initExpectedErrors();
    private Set<Integer> expectedStatusCodes = this.initStatusCodes("expected_status_codes");
    private final boolean isEventsEnabled = this.initEventsEnabled();
    private final int maxEventsStored = this.getIntProperty("max_event_samples_stored", 100);
    private final boolean ignoreErrorPriority = this.getProperty("ignoreErrorPriority", true);
    private final Object exceptionHandlers = this.initExceptionHandlers();

    private ErrorCollectorConfigImpl(Map<String, Object> props) {
        super(props, SYSTEM_PROPERTY_ROOT);
    }

    private Object initExceptionHandlers() {
        Object value = this.getProperty(EXCEPTION_HANDLERS);
        return value == null ? DEFAULT_EXCEPTION_HANDLERS : value;
    }

    private Set<IgnoreErrorConfig> initIgnoreErrors() {
        Object t2;
        HashSet<IgnoreErrorConfig> ignoreErrorsConfig = new HashSet<IgnoreErrorConfig>();
        List<String> ignoreErrors = this.getUniqueStrings(IGNORE_ERRORS);
        for (String string : ignoreErrors) {
            ignoreErrorsConfig.add(new IgnoreErrorConfigImpl(string.replace('/', '.'), null));
            MetricNames.recordApiSupportabilityMetric("IgnoreError/Config/Legacy");
        }
        Object ignoreClasses = this.getProperty(IGNORE_CLASSES);
        if (ignoreClasses instanceof Collection) {
            for (Object ignoreError : (Collection)ignoreClasses) {
                if (ignoreError instanceof Map) {
                    Map ignoreErrorMap = (Map)ignoreError;
                    String className = (String)ignoreErrorMap.get("class_name");
                    String message = (String)ignoreErrorMap.get("message");
                    if (className != null) {
                        className = className.trim();
                        if (message != null && !message.isEmpty()) {
                            MetricNames.recordApiSupportabilityMetric("IgnoreError/Config/ClassMessage");
                        } else {
                            MetricNames.recordApiSupportabilityMetric("IgnoreError/Config/Class");
                        }
                        ignoreErrorsConfig.add(new IgnoreErrorConfigImpl(className.replace('/', '.'), message));
                        continue;
                    }
                    AgentBridge.getAgent().getLogger().log(Level.WARNING, "Invalid ignore_classes config encountered. class_name must not be null. This configuration will be ignored");
                    continue;
                }
                if (!(ignoreError instanceof String)) continue;
                String className = ((String)ignoreError).trim();
                ignoreErrorsConfig.add(new IgnoreErrorConfigImpl(className.replace('/', '.'), null));
                MetricNames.recordApiSupportabilityMetric("IgnoreError/Config/Class");
            }
        }
        if ((t2 = this.getProperty(IGNORE_MESSAGES)) instanceof Map) {
            Map ignoreMessagesMap = (Map)t2;
            for (Map.Entry ignoreError : ignoreMessagesMap.entrySet()) {
                String className = ((String)ignoreError.getKey()).trim();
                for (String message : (List)ignoreError.getValue()) {
                    ignoreErrorsConfig.add(new IgnoreErrorConfigImpl(className.replace('/', '.'), message));
                    MetricNames.recordApiSupportabilityMetric("IgnoreError/Config/ClassMessage");
                }
            }
        }
        if (ignoreErrorsConfig.isEmpty()) {
            for (String defaultIgnoreError : DEFAULT_IGNORE_ERRORS) {
                ignoreErrorsConfig.add(new IgnoreErrorConfigImpl(defaultIgnoreError.replace('/', '.'), null));
            }
        }
        return ignoreErrorsConfig;
    }

    private boolean initEnabled() {
        boolean isEnabled = this.getProperty(ENABLED, true);
        boolean canCollectErrors = this.getProperty(COLLECT_ERRORS, true);
        return isEnabled && canCollectErrors;
    }

    private boolean initEventsEnabled() {
        boolean collector = this.getProperty(COLLECT_EVENTS, true);
        boolean config = this.getProperty(CAPTURE_EVENTS, true);
        return collector && config;
    }

    private Set<ExpectedErrorConfig> initExpectedErrors() {
        Object expectedMessages;
        HashSet<ExpectedErrorConfig> expectedErrorConfigs = new HashSet<ExpectedErrorConfig>();
        Object expectedErrors = this.getProperty(EXPECTED_CLASSES);
        if (expectedErrors instanceof Collection) {
            for (Object expectedError : (Collection)expectedErrors) {
                if (expectedError instanceof Map) {
                    Map expectedErrorMap = (Map)expectedError;
                    String errorClass = (String)expectedErrorMap.get("class_name");
                    String errorMessage = (String)expectedErrorMap.get("message");
                    if (errorClass != null && !errorClass.isEmpty()) {
                        errorClass = errorClass.trim();
                        if (errorMessage != null && !errorMessage.isEmpty()) {
                            MetricNames.recordApiSupportabilityMetric("ExpectedError/Config/ClassMessage");
                        } else {
                            MetricNames.recordApiSupportabilityMetric("ExpectedError/Config/Class");
                        }
                        expectedErrorConfigs.add(new ExpectedErrorConfigImpl(errorClass, errorMessage));
                        continue;
                    }
                    AgentBridge.getAgent().getLogger().log(Level.WARNING, "Invalid expected_classes config encountered. class_name must not be null. This configuration will be ignored");
                    continue;
                }
                if (!(expectedError instanceof String)) continue;
                String className = ((String)expectedError).trim();
                expectedErrorConfigs.add(new ExpectedErrorConfigImpl(className.replace('/', '.'), null));
                MetricNames.recordApiSupportabilityMetric("ExpectedError/Config/Class");
            }
        } else if (expectedErrors != null) {
            this.logStatusCodeConfigError(EXPECTED_CLASSES, "invalid type", expectedErrors);
        }
        if ((expectedMessages = this.getProperty(EXPECTED_MESSAGES)) instanceof Map) {
            Map expectedMessagesMap = (Map)expectedMessages;
            for (Map.Entry expectedError : expectedMessagesMap.entrySet()) {
                String className = ((String)expectedError.getKey()).trim();
                for (String message : (List)expectedError.getValue()) {
                    expectedErrorConfigs.add(new ExpectedErrorConfigImpl(className.replace('/', '.'), message));
                    MetricNames.recordApiSupportabilityMetric("ExpectedError/Config/ClassMessage");
                }
            }
        }
        return expectedErrorConfigs;
    }

    private void logStatusCodeConfigError(String configurationKey, String msg, Object value) {
        AgentBridge.getAgent().getLogger().log(Level.WARNING, "Invalid {0} config encountered: {1}. {0} {2}. This configuration will be ignored", (Object)configurationKey, value, (Object)msg);
    }

    private Set<Integer> initStatusCodes(String configurationKey) {
        return this.initStatusCodes(configurationKey, Collections.emptySet());
    }

    private Set<Integer> initStatusCodes(String configurationKey, Set<Integer> defaultValues) {
        Object statusCodesValue = this.getProperty(configurationKey);
        if (statusCodesValue == null) {
            return defaultValues;
        }
        if (statusCodesValue instanceof Number) {
            return ImmutableSet.of(Integer.valueOf(((Number)statusCodesValue).intValue()));
        }
        if (statusCodesValue instanceof Collection) {
            return Collections.unmodifiableSet(this.getIntegerSet(configurationKey, defaultValues));
        }
        if (statusCodesValue instanceof String) {
            String[] statusCodesOrRanges;
            HashSet<Integer> statusCodes = new HashSet<Integer>();
            for (String statusCodeOrRange : statusCodesOrRanges = ((String)statusCodesValue).split(",")) {
                if (statusCodeOrRange == null || statusCodeOrRange.isEmpty()) continue;
                try {
                    statusCodeOrRange = statusCodeOrRange.trim();
                    int statusCode = Integer.parseInt(statusCodeOrRange);
                    statusCodes.add(statusCode);
                }
                catch (NumberFormatException numberFormatException) {
                    if (this.parseRange(configurationKey, statusCodeOrRange, statusCodes)) continue;
                    return Collections.emptySet();
                }
            }
            return statusCodes;
        }
        if (statusCodesValue != null) {
            this.logStatusCodeConfigError(configurationKey, "must be an integer or a range", statusCodesValue);
        }
        return Collections.emptySet();
    }

    private boolean parseRange(String configurationKey, String statusCodeRange, Set<Integer> statusCodes) {
        block7: {
            String[] split = statusCodeRange.split("-");
            if (split.length == 2) {
                try {
                    Integer lower = Integer.parseInt(split[0]);
                    Integer upper = Integer.parseInt(split[1]);
                    if (lower > upper) {
                        this.logStatusCodeConfigError(configurationKey, "range must start with lower bound", statusCodeRange);
                        break block7;
                    }
                    if (lower < 0 || upper > 1000) {
                        this.logStatusCodeConfigError(configurationKey, "must be between 0 and 1000", statusCodeRange);
                        break block7;
                    }
                    for (int i = lower.intValue(); i <= upper; ++i) {
                        statusCodes.add(i);
                    }
                    return true;
                }
                catch (NumberFormatException e) {
                    this.logStatusCodeConfigError(configurationKey, "range values must be integers", statusCodeRange);
                }
            } else {
                this.logStatusCodeConfigError(configurationKey, "range must contain two integers", statusCodeRange);
            }
        }
        return false;
    }

    @Override
    public Set<IgnoreErrorConfig> getIgnoreErrors() {
        return this.ignoreErrors;
    }

    @Override
    public Set<Integer> getIgnoreStatusCodes() {
        return this.ignoreStatusCodes;
    }

    @Override
    public Set<ExpectedErrorConfig> getExpectedErrors() {
        return this.expectedErrors;
    }

    @Override
    public Set<Integer> getExpectedStatusCodes() {
        return this.expectedStatusCodes;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean isEventsEnabled() {
        return this.isEventsEnabled;
    }

    @Override
    public int getMaxSamplesStored() {
        return this.maxEventsStored;
    }

    static ErrorCollectorConfig createErrorCollectorConfig(Map<String, Object> settings) {
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        return new ErrorCollectorConfigImpl(settings);
    }

    @Override
    public boolean isIgnoreErrorPriority() {
        return this.ignoreErrorPriority;
    }

    @Override
    public Object getExceptionHandlers() {
        return this.exceptionHandlers;
    }
}

