/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionApiImpl;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.api.agent.TraceMetadata;

public class TraceMetadataImpl
implements TraceMetadata {
    public static final TraceMetadata INSTANCE = new TraceMetadataImpl();

    private TraceMetadataImpl() {
    }

    public String getTraceId() {
        Transaction tx = TransactionApiImpl.INSTANCE.getTransactionIfExists();
        if (tx == null || !tx.getAgentConfig().getDistributedTracingConfig().isEnabled()) {
            return "";
        }
        return tx.getSpanProxy().getOrCreateTraceId();
    }

    public String getSpanId() {
        Transaction tx = TransactionApiImpl.INSTANCE.getTransactionIfExists();
        Tracer tracedMethod = TransactionApiImpl.INSTANCE.getTracedMethodTracer(tx);
        if (tx == null || tracedMethod == null || !tx.getAgentConfig().getDistributedTracingConfig().isEnabled()) {
            return "";
        }
        String spanId = tracedMethod.getGuid();
        return spanId != null ? spanId : "";
    }

    public boolean isSampled() {
        Transaction tx = TransactionApiImpl.INSTANCE.getTransactionIfExists();
        if (tx == null || !tx.getAgentConfig().getDistributedTracingConfig().isEnabled()) {
            return false;
        }
        return tx.sampled();
    }
}

