/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.daemon.httpclient;

import com.newrelic.agent.deps.org.apache.http.Header;
import com.newrelic.agent.deps.org.apache.http.client.config.RequestConfig;
import com.newrelic.agent.deps.org.apache.http.client.methods.CloseableHttpResponse;
import com.newrelic.agent.deps.org.apache.http.client.methods.HttpUriRequest;
import com.newrelic.agent.deps.org.apache.http.client.methods.RequestBuilder;
import com.newrelic.agent.deps.org.apache.http.client.protocol.HttpClientContext;
import com.newrelic.agent.deps.org.apache.http.config.RegistryBuilder;
import com.newrelic.agent.deps.org.apache.http.config.SocketConfig;
import com.newrelic.agent.deps.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import com.newrelic.agent.deps.org.apache.http.conn.ssl.DefaultHostnameVerifier;
import com.newrelic.agent.deps.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.newrelic.agent.deps.org.apache.http.entity.ByteArrayEntity;
import com.newrelic.agent.deps.org.apache.http.impl.client.CloseableHttpClient;
import com.newrelic.agent.deps.org.apache.http.impl.client.HttpClientBuilder;
import com.newrelic.agent.deps.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import com.newrelic.agent.deps.org.apache.http.message.BasicHeader;
import com.newrelic.agent.deps.org.apache.http.protocol.HttpContext;
import com.newrelic.agent.deps.org.slf4j.Logger;
import com.newrelic.agent.deps.org.slf4j.LoggerFactory;
import com.newrelic.jfr.daemon.httpclient.ApacheProxyManager;
import com.newrelic.telemetry.http.HttpPoster;
import com.newrelic.telemetry.http.HttpResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;

public class ApacheHttpPoster
implements HttpPoster {
    private final ApacheProxyManager proxyManager;
    private final PoolingHttpClientConnectionManager connectionManager;
    private final CloseableHttpClient httpClient;
    private static final Logger logger = LoggerFactory.getLogger(ApacheHttpPoster.class);

    public ApacheHttpPoster(ApacheProxyManager proxyManager, SSLContext sslContext, int defaultTimeoutInMillis) {
        this.proxyManager = proxyManager;
        this.connectionManager = ApacheHttpPoster.createHttpClientConnectionManager(sslContext);
        this.httpClient = this.createHttpClient(defaultTimeoutInMillis);
    }

    private static PoolingHttpClientConnectionManager createHttpClientConnectionManager(SSLContext sslContext) {
        PoolingHttpClientConnectionManager httpClientConnectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)(sslContext != null ? new SSLConnectionSocketFactory(sslContext) : SSLConnectionSocketFactory.getSocketFactory()))).build());
        httpClientConnectionManager.setMaxTotal(1);
        httpClientConnectionManager.setDefaultMaxPerRoute(1);
        return httpClientConnectionManager;
    }

    private CloseableHttpClient createHttpClient(int requestTimeoutInMillis) {
        HttpClientBuilder builder = HttpClientBuilder.create().setDefaultHeaders(Arrays.asList(new BasicHeader("Connection", "Keep-Alive"), new BasicHeader("CONTENT-TYPE", "application/json"))).setSSLHostnameVerifier(new DefaultHostnameVerifier()).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(requestTimeoutInMillis).setConnectionRequestTimeout(requestTimeoutInMillis * 2).setSocketTimeout(requestTimeoutInMillis).build()).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(requestTimeoutInMillis).setSoKeepAlive(true).build()).setConnectionManager(this.connectionManager);
        if (this.proxyManager.getProxy() != null) {
            builder.setProxy(this.proxyManager.getProxy());
        }
        return builder.build();
    }

    public void shutdown() {
        this.connectionManager.closeIdleConnections(0L, TimeUnit.SECONDS);
    }

    private HttpContext createContext() {
        return this.proxyManager.updateContext(HttpClientContext.create());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HttpResponse post(URL url, Map<String, String> headers, byte[] body, String mediaType) throws IOException {
        try {
            RequestBuilder requestBuilder = RequestBuilder.post();
            requestBuilder.setUri(url.toURI()).setEntity(new ByteArrayEntity(body)).setHeader("Content-Type", mediaType);
            for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
                requestBuilder.addHeader(headerEntry.getKey(), headerEntry.getValue());
            }
            HttpUriRequest apacheRequest = requestBuilder.build();
            try (CloseableHttpResponse response = this.httpClient.execute(apacheRequest, this.createContext());){
                InputStream content = response.getEntity().getContent();
                String responseBody = new BufferedReader(new InputStreamReader(content)).lines().collect(Collectors.joining("\n"));
                HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
                for (Header header : response.getAllHeaders()) {
                    List values2 = responseHeaders.computeIfAbsent(header.getName(), k -> new ArrayList());
                    values2.add(header.getValue());
                }
                HttpResponse httpResponse = new HttpResponse(responseBody, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), responseHeaders);
                return httpResponse;
            }
        }
        catch (URISyntaxException e) {
            logger.info("JFR HttpPoster: Exception posting data.", e);
            return null;
        }
    }
}

