/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.Cache;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.Caffeine;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.threads.BasicThreadInfo;
import com.newrelic.agent.threads.ThreadNameNormalizer;
import com.newrelic.agent.threads.ThreadNames;
import com.newrelic.agent.threads.ThreadStateSampler;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class ThreadService
extends AbstractService
implements ThreadNames {
    public static final String NAME_PATTERN_CFG_KEY = "thread_sampler.name_pattern";
    private final Map<Long, Boolean> agentThreadIds;
    private final Cache<Long, String> threadIdToName = Caffeine.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).executor(Runnable::run).build();
    private volatile ThreadNameNormalizer threadNameNormalizer;

    public ThreadService() {
        super(ThreadService.class.getSimpleName());
        this.agentThreadIds = new ConcurrentHashMap<Long, Boolean>(6);
    }

    @Override
    protected void doStart() throws Exception {
        this.threadNameNormalizer = new ThreadNameNormalizer(ServiceFactory.getConfigService().getDefaultAgentConfig(), (ThreadNames)this);
        AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        if (((Boolean)config.getValue("thread_sampler.enabled", Boolean.TRUE)).booleanValue()) {
            long sampleDelayInSeconds = ((Integer)config.getValue("thread_sampler.sample_delay_in_seconds", 60)).intValue();
            long samplePeriodInSeconds = ((Integer)config.getValue("thread_sampler.sample_period_in_seconds", 60)).intValue();
            if (samplePeriodInSeconds > 0L) {
                ThreadStateSampler threadStateSampler = new ThreadStateSampler(ManagementFactory.getThreadMXBean(), this.threadNameNormalizer);
                ServiceFactory.getSamplerService().addSampler(threadStateSampler, sampleDelayInSeconds, samplePeriodInSeconds, TimeUnit.SECONDS);
            } else {
                Agent.LOG.log(Level.FINE, "The thread sampler is disabled because the sample period is {}", samplePeriodInSeconds);
            }
        } else {
            Agent.LOG.log(Level.FINE, "The thread sampler is disabled");
        }
    }

    @Override
    protected void doStop() throws Exception {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public boolean isCurrentThreadAnAgentThread() {
        return Thread.currentThread() instanceof AgentThread;
    }

    public boolean isAgentThreadId(Long threadId) {
        return this.agentThreadIds.containsKey(threadId);
    }

    public ThreadNameNormalizer getThreadNameNormalizer() {
        return this.threadNameNormalizer;
    }

    @Override
    public String getThreadName(BasicThreadInfo threadInfo) {
        return this.threadIdToName.get(threadInfo.getId(), id -> threadInfo.getName());
    }

    public Set<Long> getAgentThreadIds() {
        return Collections.unmodifiableSet(this.agentThreadIds.keySet());
    }

    public void registerAgentThreadId(long id) {
        this.agentThreadIds.put(id, Boolean.TRUE);
    }

    public static interface AgentThread {
    }
}

