/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Deployments;
import com.newrelic.agent.deps.org.apache.commons.cli.CommandLine;
import com.newrelic.agent.deps.org.apache.commons.cli.HelpFormatter;
import com.newrelic.agent.deps.org.apache.commons.cli.Option;
import com.newrelic.agent.deps.org.apache.commons.cli.Options;
import com.newrelic.agent.deps.org.apache.commons.cli.ParseException;
import com.newrelic.agent.deps.org.apache.commons.cli.PosixParser;
import com.newrelic.agent.xml.XmlInstrumentOptions;
import com.newrelic.agent.xml.XmlInstrumentValidator;
import com.newrelic.weave.verification.WeavePackageVerifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class AgentCommandLineParser {
    private static final String VERIFY_INSTRUMENTATION = "verifyInstrumentation";
    private static final String INSTRUMENT_COMMAND = "instrument";
    private static final Map<String, Options> commandOptionsMap = new HashMap<String, Options>();
    private static final Map<String, String> commandDescriptions;

    AgentCommandLineParser() {
    }

    public void parseCommand(String[] args2) {
        PosixParser parser = new PosixParser();
        try {
            String command;
            CommandLine cmd = parser.parse(AgentCommandLineParser.getCommandLineOptions(), args2);
            List argList = cmd.getArgList();
            String string = command = argList.size() > 0 ? (String)argList.get(0) : null;
            if (cmd.hasOption('h')) {
                this.printHelp(command);
                return;
            }
            if (command != null) {
                Options commandOptions = commandOptionsMap.get(command);
                if (commandOptions == null) {
                    this.printHelp();
                    System.err.println("\nInvalid command - " + command);
                    System.exit(1);
                }
                cmd = parser.parse(commandOptions, args2);
            }
            if (INSTRUMENT_COMMAND.equals(command)) {
                this.instrumentCommand(cmd);
            } else if (VERIFY_INSTRUMENTATION.equals(command)) {
                this.verifyInstrumentation(cmd);
            } else if (cmd.hasOption('v') || cmd.hasOption("version")) {
                System.out.println(Agent.getVersion());
            } else {
                this.printHelp();
                System.exit(1);
            }
        }
        catch (ParseException e) {
            System.err.println("Error parsing arguments");
            this.printHelp();
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Error executing command");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void instrumentCommand(CommandLine cmd) throws Exception {
        XmlInstrumentValidator.validateInstrumentation(cmd);
    }

    private void deploymentCommand(CommandLine cmd) throws Exception {
        Deployments.recordDeployment(cmd);
    }

    private void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        System.out.println(MessageFormat.format("New Relic Agent Version {0}", Agent.getVersion()));
        formatter.printHelp("java -jar newrelic.jar", "", AgentCommandLineParser.getBasicOptions(), this.getCommandLineFooter());
    }

    private void printHelp(String command) {
        if (command == null) {
            this.printHelp();
            return;
        }
        HelpFormatter formatter = new HelpFormatter();
        System.out.println(MessageFormat.format("New Relic Agent Version {0}", Agent.getVersion()));
        String footer = "\n  " + command + " " + commandDescriptions.get(command);
        formatter.printHelp("java -jar newrelic.jar " + command, "", commandOptionsMap.get(command), footer);
    }

    private void verifyInstrumentation(CommandLine cmd) {
        List args2 = cmd.getArgList().subList(1, cmd.getArgList().size());
        WeavePackageVerifier.main(args2.toArray(new String[args2.size()]));
    }

    private String getCommandLineFooter() {
        int maxCommandLength = this.getMaxCommandLength();
        String minSpaces = "    ";
        StringBuilder builder = new StringBuilder("\nCommands:");
        for (Map.Entry<String, String> entry : commandDescriptions.entrySet()) {
            String extraSpaces = new String(new char[maxCommandLength - entry.getKey().length()]).replace('\u0000', ' ');
            builder.append("\n  ").append(entry.getKey()).append(extraSpaces).append(minSpaces).append(entry.getValue());
        }
        return builder.toString();
    }

    private int getMaxCommandLength() {
        int max = 0;
        for (String command : commandDescriptions.keySet()) {
            max = Math.max(max, command.length());
        }
        return max;
    }

    static Options getCommandLineOptions() {
        ArrayList<Options> values2 = new ArrayList<Options>(Collections.singletonList(AgentCommandLineParser.getBasicOptions()));
        values2.addAll(commandOptionsMap.values());
        return AgentCommandLineParser.combineOptions(values2);
    }

    private static Options combineOptions(Collection<Options> optionsList) {
        Options newOptions = new Options();
        for (Options options : optionsList) {
            for (Option option : options.getOptions()) {
                newOptions.addOption(option);
            }
        }
        return newOptions;
    }

    private static Options getBasicOptions() {
        Options options = new Options();
        options.addOption("v", false, "Prints the agent version");
        options.addOption("version", false, "Prints the agent version");
        options.addOption("h", false, "Prints help");
        return options;
    }

    private static Options getInstrumentOptions() {
        XmlInstrumentOptions[] instrumentOps;
        Options options = new Options();
        for (XmlInstrumentOptions op : instrumentOps = XmlInstrumentOptions.values()) {
            options.addOption(op.getFlagName(), op.isArgRequired(), op.getDescription());
        }
        return options;
    }

    private static Options getVerifyInstrumentationOptions() {
        return new Options();
    }

    static {
        commandOptionsMap.put(INSTRUMENT_COMMAND, AgentCommandLineParser.getInstrumentOptions());
        commandOptionsMap.put(VERIFY_INSTRUMENTATION, AgentCommandLineParser.getVerifyInstrumentationOptions());
        commandDescriptions = new HashMap<String, String>();
        commandDescriptions.put(INSTRUMENT_COMMAND, "[OPTIONS]                Validates a custom instrumentation xml configuration file.");
    }
}

