/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile;

import com.newrelic.agent.Agent;
import com.newrelic.agent.ThreadService;
import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.profile.IProfile;
import com.newrelic.agent.profile.ProfileSegment;
import com.newrelic.agent.profile.ProfileTree;
import com.newrelic.agent.profile.ProfilerParameters;
import com.newrelic.agent.profile.ThreadType;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.transport.DataSenderWriter;
import com.newrelic.agent.util.StackTraces;
import java.io.IOException;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class Profile
implements IProfile {
    public static final int MAX_STACK_DEPTH = 300;
    public static final int MAX_STACK_SIZE = 60000;
    public static final int MAX_ENCODED_BYTES = 1000000;
    public static final int MAX_ENCODED_DATA_BYTES = 999886;
    public static final int STACK_TRIM = 10000;
    private long startTimeMillis = 0L;
    private long endTimeMillis = 0L;
    private int sampleCount = 0;
    private int totalThreadCount = 0;
    private int runnableThreadCount = 0;
    private Map<Long, Long> startThreadCpuTimes;
    private final ProfilerParameters profilerParameters;
    private final Map<ThreadType, ProfileTree> profileTrees = new HashMap<ThreadType, ProfileTree>();

    public Profile(ProfilerParameters parameters) {
        this.profilerParameters = parameters;
    }

    private Map<Long, Long> getThreadCpuTimes() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (!threadMXBean.isThreadCpuTimeSupported() || !threadMXBean.isThreadCpuTimeEnabled()) {
            return Collections.emptyMap();
        }
        HashMap<Long, Long> cpuTimes = new HashMap<Long, Long>();
        for (long id : threadMXBean.getAllThreadIds()) {
            cpuTimes.put(id, threadMXBean.getThreadCpuTime(id));
        }
        return cpuTimes;
    }

    @Override
    public ProfileTree getProfileTree(ThreadType threadType) {
        ProfileTree profileTree = this.profileTrees.get(threadType);
        if (profileTree == null) {
            profileTree = new ProfileTree();
            this.profileTrees.put(threadType, profileTree);
        }
        return profileTree;
    }

    @Override
    public void start() {
        this.startTimeMillis = System.currentTimeMillis();
        this.startThreadCpuTimes = this.getThreadCpuTimes();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (!threadMXBean.isThreadCpuTimeSupported()) {
            Agent.LOG.info("Profile unable to record CPU time: Thread CPU time measurement is not supported");
        } else if (!threadMXBean.isThreadCpuTimeEnabled()) {
            Agent.LOG.info("Profile unable to record CPU time: Thread CPU time measurement is not enabled");
        }
    }

    @Override
    public void end() {
        this.endTimeMillis = System.currentTimeMillis();
        Map<Long, Long> endThreadCpuTimes = this.getThreadCpuTimes();
        ThreadService threadService = ServiceFactory.getThreadService();
        Set<Long> agentThreadIds = threadService.getAgentThreadIds();
        for (Map.Entry<Long, Long> entry : endThreadCpuTimes.entrySet()) {
            Long startTime = this.startThreadCpuTimes.get(entry.getKey());
            if (startTime == null) {
                startTime = 0L;
            }
            long cpuTime = TimeUnit.MILLISECONDS.convert(entry.getValue() - startTime, TimeUnit.NANOSECONDS);
            ProfileTree tree = agentThreadIds.contains(entry.getKey()) ? this.getProfileTree(ThreadType.BasicThreadType.AGENT) : this.getProfileTree(ThreadType.BasicThreadType.OTHER);
            tree.incrementCpuTime(cpuTime);
        }
        int stackCount = this.getCallSiteCount();
        String msg = MessageFormat.format("Profile size is {0} stack elements", stackCount);
        Agent.LOG.info(msg);
        if (stackCount > 60000) {
            Agent.LOG.info(MessageFormat.format("Trimmed profile size by {0} stack elements", this.trim(stackCount - 60000, stackCount)));
        }
    }

    @Override
    public void markInstrumentedMethods() {
        try {
            this.doMarkInstrumentedMethods();
        }
        catch (Throwable ex) {
            String msg = MessageFormat.format("Error marking instrumented methods {0}", ex);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, ex);
            }
            Agent.LOG.finer(msg);
        }
    }

    private void doMarkInstrumentedMethods() {
        Class[] allLoadedClasses = ServiceFactory.getCoreService().getInstrumentation().getAllLoadedClasses();
        HashMap classMap = new HashMap();
        for (Class clazz : allLoadedClasses) {
            classMap.put(clazz.getName(), clazz);
        }
        for (ProfileTree tree : this.profileTrees.values()) {
            tree.setMethodDetails(classMap);
        }
    }

    @Override
    public int trimBy(int limit) {
        return this.trim(limit, this.getCallSiteCount());
    }

    private int trim(int limit, int stackCount) {
        ProfileSegmentSort[] segments = this.getSortedSegments(stackCount);
        int count = 0;
        for (ProfileSegmentSort segment : segments) {
            if (count >= limit) break;
            segment.remove();
            ++count;
        }
        return count;
    }

    private ProfileSegmentSort[] getSortedSegments(int stackCount) {
        Object[] segments = new ProfileSegmentSort[stackCount];
        int index = 0;
        for (ProfileTree profileTree : this.profileTrees.values()) {
            for (ProfileSegment rootSegment : profileTree.getRootSegments()) {
                index = this.addSegment(rootSegment, null, 1, (ProfileSegmentSort[])segments, index);
            }
        }
        Arrays.sort(segments);
        return segments;
    }

    private int addSegment(ProfileSegment segment, ProfileSegment parent, int depth, ProfileSegmentSort[] segments, int index) {
        ProfileSegmentSort segSort = new ProfileSegmentSort(segment, parent, depth);
        segments[index++] = segSort;
        for (ProfileSegment child : segment.getChildren()) {
            index = this.addSegment(child, segment, ++depth, segments, index);
        }
        return index;
    }

    private int getCallSiteCount() {
        int count = 0;
        for (ProfileTree profileTree : this.profileTrees.values()) {
            count += profileTree.getCallSiteCount();
        }
        return count;
    }

    @Override
    public Long getProfileId() {
        return this.profilerParameters.getProfileId();
    }

    @Override
    public ProfilerParameters getProfilerParameters() {
        return this.profilerParameters;
    }

    @Override
    public void beforeSampling() {
        ++this.sampleCount;
    }

    @Override
    public int getSampleCount() {
        return this.sampleCount;
    }

    @Override
    public final long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    @Override
    public final long getEndTimeMillis() {
        return this.endTimeMillis;
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        JSONArray.writeJSONString(Arrays.asList(this.profilerParameters.getProfileId(), this.startTimeMillis, this.endTimeMillis, this.sampleCount, this.getData(out), this.totalThreadCount, this.runnableThreadCount), out);
    }

    private Object getData(Writer out) {
        Object result = DataSenderWriter.getJsonifiedOptionallyCompressedEncodedString(this.profileTrees, out, 1, 999886);
        int maxStack = 60000;
        while (result == null && maxStack > 0) {
            int stackCount = this.getCallSiteCount();
            this.trim(stackCount - (maxStack -= 10000), stackCount);
            result = DataSenderWriter.getJsonifiedOptionallyCompressedEncodedString(this.profileTrees, out, 1, 999886);
        }
        if (result != null && DataSenderWriter.isCompressingWriter(out)) {
            String msg = MessageFormat.format("Profile serialized size = {0} bytes", result.toString().length());
            Agent.LOG.info(msg);
        }
        return result;
    }

    private void incrementThreadCounts(boolean runnable) {
        ++this.totalThreadCount;
        if (runnable) {
            ++this.runnableThreadCount;
        }
    }

    private boolean shouldScrubStack(ThreadType type) {
        if (ThreadType.BasicThreadType.AGENT.equals(type)) {
            return false;
        }
        return !this.profilerParameters.isProfileAgentThreads();
    }

    @Override
    public void addStackTrace(long threadId, boolean runnable, ThreadType type, StackTraceElement ... stackTrace) {
        if (stackTrace.length < 2) {
            return;
        }
        this.incrementThreadCounts(runnable);
        List<StackTraceElement> stackTraceList = this.shouldScrubStack(type) ? StackTraces.scrubAndTruncate(Arrays.asList(stackTrace), 0) : Arrays.asList(stackTrace);
        ArrayList<StackTraceElement> result = new ArrayList<StackTraceElement>(stackTraceList);
        Collections.reverse(result);
        this.getProfileTree(type).addStackTrace(result, runnable);
    }

    private static class ProfileSegmentSort
    implements Comparable<ProfileSegmentSort> {
        private final ProfileSegment segment;
        private final ProfileSegment parent;
        private final int depth;

        private ProfileSegmentSort(ProfileSegment segment, ProfileSegment parent, int depth) {
            this.segment = segment;
            this.parent = parent;
            this.depth = depth;
        }

        void remove() {
            if (this.parent != null) {
                this.parent.removeChild(this.segment.getMethod());
            }
        }

        public String toString() {
            return this.segment.toString();
        }

        @Override
        public int compareTo(ProfileSegmentSort other) {
            int otherCount;
            int thisCount = this.segment.getRunnableCallCount();
            if (thisCount == (otherCount = other.segment.getRunnableCallCount())) {
                return this.depth > other.depth ? -1 : (this.depth == other.depth ? 0 : 1);
            }
            return thisCount > otherCount ? 1 : -1;
        }
    }
}

