/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.discovery;

import java.util.logging.Level;

public enum TerminalColor {
    Red("\u001b[31m"),
    Yellow("\u001b[33m"),
    Cyan("\u001b[36m");

    private static final String RESET = "\u001b[0m";
    private final String color;

    private TerminalColor(String color) {
        this.color = color;
    }

    public static TerminalColor fromLevel(Level level) {
        if (Level.SEVERE.equals(level)) {
            return Red;
        }
        if (Level.WARNING.equals(level)) {
            return Yellow;
        }
        return Cyan;
    }

    public String colorText(String text) {
        return this.color + text + RESET;
    }

    public String formatMessage(String label, String message) {
        return this.colorText(label) + "\t| " + message;
    }
}

