/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.attributes;

import com.newrelic.agent.attributes.AttributesNode;
import com.newrelic.agent.attributes.ExcludeIncludeFilter;
import com.newrelic.agent.attributes.RootConfigAttributesNode;
import java.util.Collection;

public class ExcludeIncludeFilterImpl
implements ExcludeIncludeFilter {
    private final RootConfigAttributesNode rootNode;
    private final boolean includeByDefault;

    public ExcludeIncludeFilterImpl(String identifier, Collection<String> excludes, Collection<String> includes) {
        this(identifier, excludes, includes, includes == null || includes.isEmpty());
    }

    public ExcludeIncludeFilterImpl(String identifier, Collection<String> excludes, Collection<String> includes, boolean includeByDefault) {
        this.rootNode = new RootConfigAttributesNode(identifier);
        this.includeByDefault = includeByDefault;
        boolean notDefault = false;
        if (includes != null) {
            for (String key : includes) {
                AttributesNode includeNode = new AttributesNode(key, true, identifier, notDefault);
                this.rootNode.addNode(includeNode);
            }
        }
        if (excludes != null) {
            for (String key : excludes) {
                AttributesNode excludeNode = new AttributesNode(key, false, identifier, notDefault);
                this.rootNode.addNode(excludeNode);
            }
        }
    }

    @Override
    public boolean shouldInclude(String key) {
        Boolean apply = this.rootNode.applyRules(key);
        return apply == null ? this.includeByDefault : apply;
    }
}

