/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.tracers.Tracer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class TracerList
implements List<Tracer> {
    private final Set<TransactionActivity> activities;
    private List<Tracer> tracers;
    private final Tracer txRootTracer;

    public TracerList(Tracer txRootTracer, Set<TransactionActivity> activities) {
        if (activities == null) {
            throw new IllegalArgumentException();
        }
        this.activities = activities;
        this.txRootTracer = txRootTracer;
    }

    private List<Tracer> getTracers() {
        if (this.tracers == null) {
            int n = 0;
            for (TransactionActivity txa : this.activities) {
                n += txa.getTracers().size();
            }
            this.tracers = new ArrayList<Tracer>(++n);
            for (TransactionActivity txa : this.activities) {
                if (txa.getRootTracer() != this.txRootTracer) {
                    this.tracers.add(txa.getRootTracer());
                }
                this.tracers.addAll(txa.getTracers());
            }
        }
        return this.tracers;
    }

    @Override
    public int size() {
        return this.getTracers().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getTracers().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.getTracers().contains(o);
    }

    @Override
    public Iterator<Tracer> iterator() {
        return this.getTracers().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getTracers().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getTracers().toArray(a);
    }

    @Override
    public boolean add(Tracer e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        return this.getTracers().remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getTracers().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Tracer> c) {
        return this.getTracers().addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Tracer> c) {
        return this.getTracers().addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.getTracers().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.getTracers().retainAll(c);
    }

    @Override
    public void clear() {
        this.getTracers().clear();
    }

    @Override
    public Tracer get(int index) {
        return this.getTracers().get(index);
    }

    @Override
    public Tracer set(int index, Tracer element) {
        return this.getTracers().set(index, element);
    }

    @Override
    public void add(int index, Tracer element) {
        this.getTracers().add(index, element);
    }

    @Override
    public Tracer remove(int index) {
        return this.getTracers().remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.getTracers().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.getTracers().lastIndexOf(o);
    }

    @Override
    public ListIterator<Tracer> listIterator() {
        return this.getTracers().listIterator();
    }

    @Override
    public ListIterator<Tracer> listIterator(int index) {
        return this.getTracers().listIterator(index);
    }

    @Override
    public List<Tracer> subList(int fromIndex, int toIndex) {
        return this.getTracers().subList(fromIndex, toIndex);
    }
}

