/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.utils;

import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.weave.utils.BootstrapLoader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public final class Streams {
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    private Streams() {
    }

    public static byte[] getClassBytes(Class clazz) throws IOException {
        return Streams.getClassBytes(clazz.getClassLoader(), Type.getInternalName(clazz));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getClassBytes(ClassLoader classLoader, String name) throws IOException {
        name = name.replaceAll("\\.", "/") + ".class";
        InputStream iStream = null;
        if (classLoader == null) {
            URL resource = BootstrapLoader.get().findResource(name);
            if (resource != null) {
                iStream = resource.openStream();
            }
        } else {
            iStream = classLoader.getResourceAsStream(name);
        }
        if (iStream != null) {
            try {
                ByteArrayOutputStream oStream = new ByteArrayOutputStream();
                Streams.copy(iStream, oStream);
                byte[] byArray = oStream.toByteArray();
                return byArray;
            }
            finally {
                iStream.close();
            }
        }
        return null;
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        return Streams.copy(input, output, 8192, false);
    }

    public static int copy(InputStream input, OutputStream output, boolean closeStreams) throws IOException {
        return Streams.copy(input, output, 8192, closeStreams);
    }

    public static int copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        return Streams.copy(input, output, bufferSize, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream input, OutputStream output, int bufferSize, boolean closeStreams) throws IOException {
        try {
            if (0 == bufferSize) {
                int n = 0;
                return n;
            }
            byte[] buffer = new byte[bufferSize];
            int count = 0;
            int n = 0;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += n;
            }
            int n2 = count;
            return n2;
        }
        finally {
            if (closeStreams) {
                input.close();
                output.close();
            }
        }
    }

    public static byte[] read(InputStream input, boolean closeInputStream) throws IOException {
        return Streams.read(input, input.available(), closeInputStream);
    }

    public static byte[] read(InputStream input, int expectedSize, boolean closeInputStream) throws IOException {
        if (expectedSize <= 0) {
            expectedSize = 8192;
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(expectedSize);
        Streams.copy(input, outStream, expectedSize, closeInputStream);
        return outStream.toByteArray();
    }
}

