/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.BaseConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ApplicationLoggingLabelsConfig
extends BaseConfig {
    public static final String ROOT = "labels";
    public static final String ENABLED = "enabled";
    public static final String EXCLUDE = "exclude";
    public static final boolean DEFAULT_ENABLED = false;
    private final boolean enabled;
    private final Set<String> excludeSet = this.initExcludes(this.getProperty("exclude"));

    public ApplicationLoggingLabelsConfig(Map<String, Object> props, String parentRoot) {
        super(props, parentRoot + ROOT + ".");
        this.enabled = this.getProperty(ENABLED, false);
    }

    private Set<String> initExcludes(Object excludes) {
        HashSet<String> formattedExcludes = new HashSet<String>();
        if (excludes instanceof List) {
            for (Object listItem : (List)excludes) {
                formattedExcludes.add(listItem.toString().trim());
            }
        } else if (excludes instanceof String) {
            formattedExcludes.addAll(this.parseExcludesString((String)excludes));
        }
        return formattedExcludes;
    }

    private Set<String> parseExcludesString(String excludes) {
        HashSet<String> excludeSet = new HashSet<String>();
        for (String exclude : excludes.split(",")) {
            String trimmedExclude = exclude.trim();
            if (trimmedExclude.isEmpty()) continue;
            excludeSet.add(trimmedExclude);
        }
        return excludeSet;
    }

    public Map<String, String> removeExcludedLabels(Map<String, String> labels) {
        HashMap<String, String> filteredLabels = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            if (this.isExcluded(entry.getKey())) continue;
            filteredLabels.put(entry.getKey(), entry.getValue());
        }
        return filteredLabels;
    }

    public boolean isExcluded(String label) {
        return this.getExcludeSet().contains(label);
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public Set<String> getExcludeSet() {
        return this.excludeSet;
    }
}

