/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.browser;

import com.newrelic.agent.Agent;
import com.newrelic.agent.browser.BrowserTransactionState;
import com.newrelic.agent.browser.JavaScriptAgentConfig;
import com.newrelic.agent.config.BaseConfig;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;

public class BrowserConfig
extends BaseConfig {
    public static final String BROWSER_KEY = "browser_key";
    public static final String BROWSER_LOADER_VERSION = "browser_monitoring.loader_version";
    public static final String JS_AGENT_LOADER = "js_agent_loader";
    public static final String JS_AGENT_FILE = "js_agent_file";
    public static final String BEACON = "beacon";
    public static final String ERROR_BEACON = "error_beacon";
    public static final String APPLICATION_ID = "application_id";
    private static final String SCRIPT_BEGIN = "\n<script type=\"text/javascript\"";
    private static final String SCRIPT_END = "</script>";
    static final String JS_AGENT_CONFIG_STR_PREFIX = "window.NREUM||(NREUM={});NREUM.info=";
    private final String jsAgentLoader;
    private final JavaScriptAgentConfig javaScriptAgentConfig;

    private BrowserConfig(String appName, Map<String, Object> props) throws Exception {
        super(props);
        this.javaScriptAgentConfig = this.initJavaScriptAgentConfig(appName);
        this.jsAgentLoader = this.getRequiredProperty(JS_AGENT_LOADER);
        this.logVersion(appName);
    }

    public static BrowserConfig createBrowserConfig(String appName, Map<String, Object> settings) throws Exception {
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        return new BrowserConfig(appName, settings);
    }

    public String getBrowserAgentHeaderScript(BrowserTransactionState state) {
        return this.getBrowserAgentHeaderScript(state, null);
    }

    public String getBrowserAgentHeaderScript(BrowserTransactionState state, String nonce) {
        return SCRIPT_BEGIN + (nonce != null ? " nonce=\"" + nonce + "\">" : ">") + JS_AGENT_CONFIG_STR_PREFIX + this.javaScriptAgentConfig.getConfigString(state) + ";\n" + this.jsAgentLoader + SCRIPT_END;
    }

    private JavaScriptAgentConfig initJavaScriptAgentConfig(String appName) throws Exception {
        String beacon = this.getRequiredProperty(BEACON);
        String browserKey = this.getRequiredProperty(BROWSER_KEY);
        String errorBeacon = this.getRequiredProperty(ERROR_BEACON);
        String payloadScript = this.getRequiredProperty(JS_AGENT_FILE);
        String appId = this.getRequiredProperty(APPLICATION_ID);
        return new JavaScriptAgentConfig(appName, beacon, browserKey, errorBeacon, payloadScript, appId);
    }

    private void logVersion(String appName) {
        String version = (String)this.getProperty(BROWSER_LOADER_VERSION);
        if (version != null) {
            Agent.LOG.log(Level.INFO, MessageFormat.format("Using RUM version {0} for application \"{1}\"", version, appName));
        }
    }

    private String getRequiredProperty(String key) throws Exception {
        Object val = this.getProperty(key, null);
        if (val == null) {
            String msg = MessageFormat.format("Real User Monitoring value for {0} is missing", key);
            throw new Exception(msg);
        }
        return val.toString();
    }
}

