/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.daemon.app;

import com.newrelic.agent.deps.org.slf4j.Logger;
import com.newrelic.agent.deps.org.slf4j.LoggerFactory;
import com.newrelic.jfr.daemon.JfrRecorder;
import com.newrelic.jfr.daemon.JfrRecorderException;
import com.newrelic.jfr.daemon.app.JmxJfrRecorderFactory;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class JmxJfrRecorder
implements JfrRecorder {
    private static final Logger logger = LoggerFactory.getLogger(JmxJfrRecorder.class);
    private static final int MAX_BYTES_READ = 0x500000;
    private final MBeanServerConnection connection;
    private final boolean streamFromJmx;
    private final long recordingId;

    public JmxJfrRecorder(MBeanServerConnection connection, boolean streamFromJmx, long recordingId) {
        this.connection = connection;
        this.streamFromJmx = streamFromJmx;
        this.recordingId = recordingId;
    }

    @Override
    public Path recordToFile() throws JfrRecorderException {
        try {
            return this.streamFromJmx ? this.streamRecordingToFile() : this.copyRecordingToFile();
        }
        catch (Exception e) {
            throw new JfrRecorderException("Failed to record JFR data to file.", e);
        }
    }

    Path streamRecordingToFile() throws Exception {
        ObjectName objectName = JmxJfrRecorderFactory.makeFlightRecorderObjectName();
        Object oClone = this.connection.invoke(objectName, "cloneRecording", new Object[]{this.recordingId, true}, new String[]{"long", "boolean"});
        if (!(oClone instanceof Long)) {
            throw new RuntimeException("JMX returned something that wasn't a Long: " + oClone);
        }
        Long cloneId = (Long)oClone;
        HashMap<String, String> streamOptions = new HashMap<String, String>();
        streamOptions.put("blockSize", "5242880");
        String[] sig = new String[]{"long", "javax.management.openmbean.TabularData"};
        Object[] args2 = new Object[]{cloneId, JmxJfrRecorderFactory.makeOpenData(streamOptions)};
        Object oStream = this.connection.invoke(objectName, "openStream", args2, sig);
        if (!(oStream instanceof Long)) {
            throw new RuntimeException("JMX returned something that wasn't a Long: " + oStream);
        }
        Long streamId = (Long)oStream;
        boolean moreToRead = true;
        Path dir = Files.createTempDirectory("nr-jfr", new FileAttribute[0]);
        Path file = Files.createTempFile(dir, "stream-" + System.currentTimeMillis(), null, new FileAttribute[0]);
        try (OutputStream outputStream2 = Files.newOutputStream(file, new OpenOption[0]);){
            logger.debug("Opening stream from target process");
            while (moreToRead) {
                Object oBytes = this.connection.invoke(objectName, "readStream", new Object[]{streamId}, new String[]{"long"});
                if (oBytes == null) {
                    break;
                }
                if (!(oBytes instanceof byte[])) {
                    throw new RuntimeException("JMX returned something that wasn't a byte array: " + oBytes);
                }
                byte[] bytesRead = (byte[])oBytes;
                logger.debug("Reading bytes from stream: " + bytesRead.length);
                if (bytesRead.length < 0x500000) {
                    moreToRead = false;
                }
                outputStream2.write(bytesRead);
            }
        }
        logger.debug("Closing JMX stream");
        this.connection.invoke(objectName, "closeStream", new Object[]{streamId}, new String[]{"long"});
        this.connection.invoke(objectName, "closeRecording", new Object[]{cloneId}, new String[]{"long"});
        return file;
    }

    Path copyRecordingToFile() throws Exception {
        ObjectName objectName = JmxJfrRecorderFactory.makeFlightRecorderObjectName();
        Object oClone = this.connection.invoke(objectName, "cloneRecording", new Object[]{this.recordingId, true}, new String[]{"long", "boolean"});
        if (!(oClone instanceof Long)) {
            throw new RuntimeException("JMX returned something that wasn't a Long: " + oClone);
        }
        Long cloneId = (Long)oClone;
        Path dir = Files.createTempDirectory("nr-jfr", new FileAttribute[0]);
        Path file = Files.createTempFile(dir, "stream-" + System.currentTimeMillis(), null, new FileAttribute[0]);
        this.connection.invoke(objectName, "copyTo", new Object[]{cloneId, file.toString()}, new String[]{"long", "java.lang.String"});
        this.connection.invoke(objectName, "closeRecording", new Object[]{cloneId}, new String[]{"long"});
        return file;
    }
}

