/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.utilization;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.org.json.simple.JSONObject;
import com.newrelic.agent.deps.org.json.simple.parser.JSONParser;
import com.newrelic.agent.utilization.CloudData;
import com.newrelic.agent.utilization.CloudUtility;
import com.newrelic.agent.utilization.CloudVendor;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class Azure
implements CloudVendor {
    static String PROVIDER = "azure";
    private final CloudUtility cloudUtility;
    private static final String INSTANCE_DOCUMENT_URL = "http://169.254.169.254/metadata/instance/compute?api-version=2017-03-01";
    private static final int REQUEST_TIMEOUT_MILLIS = 100;
    private static final String AZURE_VM_ID_REQUEST = "vmId";
    private static final String AZURE_VM_SIZE_REQUEST = "vmSize";
    private static final String AZURE_LOCATION_REQUEST = "location";
    private static final String AZURE_NAME_REQUEST = "name";
    private static final String AZURE_VM_ID_KEY = "vmId";
    private static final String AZURE_VM_SIZE_KEY = "vmSize";
    private static final String AZURE_LOCATION_KEY = "location";
    private static final String AZURE_NAME_KEY = "name";

    public Azure(CloudUtility cloudUtility) {
        this.cloudUtility = cloudUtility;
    }

    @Override
    public AzureData getData() {
        try {
            String unparsedResult = this.getAzureValues();
            JSONParser parser = new JSONParser();
            HashMap result = null;
            if (unparsedResult != null) {
                result = (JSONObject)parser.parse(unparsedResult);
            }
            if (result == null || result.isEmpty()) {
                return AzureData.EMPTY_DATA;
            }
            String location = (String)result.get("location");
            String name = (String)result.get("name");
            String vmId = (String)result.get("vmId");
            String vmSize = (String)result.get("vmSize");
            if (this.cloudUtility.isInvalidValue(location) || this.cloudUtility.isInvalidValue(name) || this.cloudUtility.isInvalidValue(vmId) || this.cloudUtility.isInvalidValue(vmSize)) {
                this.recordAzureError();
                Agent.LOG.log(Level.WARNING, "Failed to validate Azure value");
                return AzureData.EMPTY_DATA;
            }
            AzureData data = new AzureData(location, name, vmId, vmSize);
            Agent.LOG.log(Level.FINEST, "Found {0}", data);
            return data;
        }
        catch (Exception e) {
            return AzureData.EMPTY_DATA;
        }
    }

    protected String getAzureValues() {
        try {
            return this.cloudUtility.httpGet(INSTANCE_DOCUMENT_URL, 100, "Metadata:true");
        }
        catch (Throwable t2) {
            Agent.LOG.log(Level.FINEST, MessageFormat.format("Error occurred trying to get Azure values. {0}", t2));
            this.recordAzureError();
            return null;
        }
    }

    private void recordAzureError() {
        this.cloudUtility.recordError("Supportability/utilization/azure/error");
    }

    protected static class AzureData
    implements CloudData {
        private final String location;
        private final String name;
        private final String vmId;
        private final String vmSize;
        static final AzureData EMPTY_DATA = new AzureData();

        private AzureData() {
            this.location = null;
            this.name = null;
            this.vmId = null;
            this.vmSize = null;
        }

        protected AzureData(String location, String name, String vmId, String vmSize) {
            this.location = location;
            this.name = name;
            this.vmId = vmId;
            this.vmSize = vmSize;
        }

        public String getLocation() {
            return this.location;
        }

        public String getName() {
            return this.name;
        }

        public String getVmId() {
            return this.vmId;
        }

        public String getVmSize() {
            return this.vmSize;
        }

        @Override
        public Map<String, String> getValueMap() {
            HashMap<String, String> azure = new HashMap<String, String>();
            if (this.vmSize == null || this.vmId == null || this.location == null || this.name == null) {
                return azure;
            }
            azure.put("vmSize", this.vmSize);
            azure.put("vmId", this.vmId);
            azure.put("location", this.location);
            azure.put("name", this.name);
            return azure;
        }

        @Override
        public String getProvider() {
            return PROVIDER;
        }

        @Override
        public boolean isEmpty() {
            return this == EMPTY_DATA;
        }

        public String toString() {
            return "AzureData{location='" + this.location + '\'' + ", name='" + this.name + '\'' + ", vmId='" + this.vmId + '\'' + ", vmSize='" + this.vmSize + '\'' + '}';
        }
    }
}

