/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.weavepackage;

import com.newrelic.agent.deps.org.objectweb.asm.tree.ClassNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodNode;
import com.newrelic.weave.utils.WeaveUtils;
import java.io.IOException;
import java.util.IdentityHashMap;

public abstract class ExtensionClassTemplate {
    public static final String GET_EXTENSION_METHOD = "getExtension";
    public static final String GET_AND_REMOVE_EXTENSION_METHOD = "getAndRemoveExtension";
    public static final ClassNode DEFAULT_EXTENSION_TEMPLATE;

    public static ExtensionClassTemplate getExtension(Object instance) {
        return null;
    }

    public static ExtensionClassTemplate getAndRemoveExtension(Object instance) {
        return null;
    }

    public final boolean gen_shouldResetExtensionClass() {
        return false;
    }

    public static boolean isValidExtensionNode(ClassNode extensionNode) {
        String requiredSuperClass = WeaveUtils.getClassInternalName(ExtensionClassTemplate.class.getName());
        if (!requiredSuperClass.equals(extensionNode.superName)) {
            return false;
        }
        String getExtensionDesc = "(Ljava/lang/Object;)L" + extensionNode.name + ";";
        if (null == WeaveUtils.getMethodNode(extensionNode, GET_EXTENSION_METHOD, getExtensionDesc)) {
            return false;
        }
        String getAndRemoveExtensionDesc = "(Ljava/lang/Object;)L" + extensionNode.name + ";";
        if (null == WeaveUtils.getMethodNode(extensionNode, GET_AND_REMOVE_EXTENSION_METHOD, getAndRemoveExtensionDesc)) {
            return false;
        }
        if (null != WeaveUtils.getMethodNode(extensionNode, "gen_shouldResetExtensionClass", "()Z")) {
            return false;
        }
        int numConstructors = 0;
        for (MethodNode methodNode : extensionNode.methods) {
            if (!"<init>".equals(methodNode.name)) continue;
            if (++numConstructors != 1) {
                return false;
            }
            if ("()V".equals(methodNode.desc)) continue;
            return false;
        }
        return true;
    }

    static {
        try {
            DEFAULT_EXTENSION_TEMPLATE = WeaveUtils.convertToClassNode(WeaveUtils.getClassBytesFromClassLoaderResource(WeaveUtils.getClassResourceName(DefaultExtension.class.getName()), DefaultExtension.class.getClassLoader()));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static class DefaultExtension
    extends ExtensionClassTemplate {
        public static IdentityHashMap<Object, DefaultExtension> WEAVER_INSTANCE_MAP = new IdentityHashMap();

        private DefaultExtension() {
        }

        public static synchronized DefaultExtension getAndRemoveExtension(Object instance) {
            return WEAVER_INSTANCE_MAP.remove(instance);
        }

        public static synchronized DefaultExtension getExtension(Object instance) {
            DefaultExtension result = WEAVER_INSTANCE_MAP.get(instance);
            if (result == null) {
                result = new DefaultExtension();
                WEAVER_INSTANCE_MAP.put(instance, result);
            }
            return result;
        }
    }
}

