/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.jmx.create;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.JmxConfig;
import com.newrelic.agent.extension.Extension;
import com.newrelic.agent.jmx.JmxType;
import com.newrelic.agent.jmx.create.JmxAttributeFilter;
import com.newrelic.agent.jmx.create.JmxConfiguration;
import com.newrelic.agent.jmx.create.JmxGet;
import com.newrelic.agent.jmx.create.JmxInvoke;
import com.newrelic.agent.jmx.create.JmxMetricModifier;
import com.newrelic.agent.jmx.create.JmxMultiMBeanGet;
import com.newrelic.agent.jmx.create.JmxSingleMBeanGet;
import com.newrelic.agent.jmx.metrics.BaseJmxInvokeValue;
import com.newrelic.agent.jmx.metrics.BaseJmxValue;
import com.newrelic.agent.jmx.metrics.JMXMetricType;
import com.newrelic.agent.jmx.metrics.JmxFrameworkValues;
import com.newrelic.agent.jmx.metrics.JmxMetric;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.util.Annotations;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class JmxObjectFactory {
    private final Collection<String> disabledJmxFrameworks;

    private JmxObjectFactory() {
        JmxConfig jmxConfig = ServiceFactory.getConfigService().getDefaultAgentConfig().getJmxConfig();
        this.disabledJmxFrameworks = jmxConfig.getDisabledJmxFrameworks();
    }

    public static JmxObjectFactory createJmxFactory() {
        return new JmxObjectFactory();
    }

    public void getStartUpJmxObjects(List<JmxGet> jmxGets, List<JmxInvoke> jmxInvokes) {
        this.getStoredJmxObjects(jmxGets, jmxInvokes);
        this.getYmlJmxGets(jmxGets);
    }

    public void convertFramework(JmxFrameworkValues framework, List<JmxGet> jmxGets, List<JmxInvoke> jmxInvokes) {
        if (framework != null) {
            if (this.isDisabled(framework)) {
                Agent.LOG.log(Level.INFO, MessageFormat.format("JMX Metrics for the {0} framework are disabled and therefore are not being loaded.", framework.getPrefix()));
            } else {
                this.convertToJmxGets(framework, jmxGets);
                this.convertToJmxInvoke(framework, jmxInvokes);
            }
        }
    }

    protected String getSafeObjectName(String pObjectNameString) {
        return pObjectNameString;
    }

    private void createLogAddJmxGet(String pObjectName, String rootMetricName, Map<JmxType, List<String>> pAttributesToType, List<JmxGet> alreadyAdded, Extension origin) {
        try {
            JmxSingleMBeanGet toAdd = new JmxSingleMBeanGet(pObjectName, rootMetricName, this.getSafeObjectName(pObjectName), pAttributesToType, origin);
            alreadyAdded.add(0, toAdd);
            if (Agent.LOG.isFineEnabled()) {
                Agent.LOG.log(Level.FINER, MessageFormat.format("Adding JMX config: {0}", toAdd));
            }
        }
        catch (Exception e) {
            Agent.LOG.log(Level.WARNING, "The JMX configuration is invalid and will not be added. Please check your JMX configuration file. The object name is " + pObjectName);
        }
    }

    private void createLogAddJmxGet(JMXMetricType type, String pObjectName, String pRootMetricName, List<JmxMetric> pMetrics, JmxAttributeFilter attributeFilter, JmxMetricModifier modifier, List<JmxGet> alreadyAdded) {
        try {
            JmxGet toAdd = type == JMXMetricType.INCREMENT_COUNT_PER_BEAN ? new JmxSingleMBeanGet(pObjectName, this.getSafeObjectName(pObjectName), pRootMetricName, pMetrics, attributeFilter, modifier) : new JmxMultiMBeanGet(pObjectName, this.getSafeObjectName(pObjectName), pRootMetricName, pMetrics, attributeFilter, modifier);
            alreadyAdded.add(0, toAdd);
            if (Agent.LOG.isFineEnabled()) {
                Agent.LOG.log(Level.FINER, MessageFormat.format("Adding JMX config: {0}", toAdd));
            }
        }
        catch (Exception e) {
            Agent.LOG.log(Level.WARNING, "The JMX configuration is invalid and will not be added. Please check your JMX configuration file. The object name is " + pObjectName);
        }
    }

    private void createLogAddJmxInvoke(BaseJmxInvokeValue invoke, List<JmxInvoke> alreadyAdded) {
        try {
            JmxInvoke toAdd = new JmxInvoke(invoke.getObjectNameString(), this.getSafeObjectName(invoke.getObjectNameString()), invoke.getOperationName(), invoke.getParams(), invoke.getSignature());
            alreadyAdded.add(toAdd);
            if (Agent.LOG.isFineEnabled()) {
                Agent.LOG.log(Level.FINER, MessageFormat.format("Adding JMX config: {0}", toAdd));
            }
        }
        catch (Exception e) {
            Agent.LOG.log(Level.WARNING, "The JMX configuration is invalid and will not be added. Please check your JMX configuration file. The object name is " + invoke.getObjectNameString());
        }
    }

    private void getStoredJmxObjects(List<JmxGet> gets, List<JmxInvoke> invokes) {
        Collection<Class<?>> classes = new Annotations().getJmxInitClasses();
        if (classes != null) {
            for (Class<?> clazz : classes) {
                if (!JmxFrameworkValues.class.isAssignableFrom(clazz)) continue;
                this.convertFramework(this.loadJmxFrameworkValues(clazz.asSubclass(JmxFrameworkValues.class)), gets, invokes);
            }
        }
    }

    private boolean isDisabled(JmxFrameworkValues current) {
        String framework = current.getPrefix();
        return this.disabledJmxFrameworks.contains(framework);
    }

    private void convertToJmxInvoke(JmxFrameworkValues framework, List<JmxInvoke> alreadyAdded) {
        List<BaseJmxInvokeValue> values2 = framework.getJmxInvokers();
        if (values2 != null) {
            for (BaseJmxInvokeValue value : values2) {
                this.createLogAddJmxInvoke(value, alreadyAdded);
            }
        }
    }

    private void convertToJmxGets(JmxFrameworkValues framework, List<JmxGet> alreadyAdded) {
        List<BaseJmxValue> values2 = framework.getFrameworkMetrics();
        if (values2 != null) {
            for (BaseJmxValue value : values2) {
                this.createLogAddJmxGet(value.getType(), value.getObjectNameString(), value.getObjectMetricName(), value.getMetrics(), value.getAttributeFilter(), value.getModifier(), alreadyAdded);
            }
        }
    }

    private <T extends JmxFrameworkValues> JmxFrameworkValues loadJmxFrameworkValues(Class<T> clazz) {
        try {
            return (JmxFrameworkValues)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Unable to create jmx framework values in class {0} : {1}", clazz.getName(), e.toString());
            Agent.LOG.severe(msg);
            Agent.LOG.log(Level.FINE, msg, e);
            return null;
        }
    }

    private void getYmlJmxGets(List<JmxGet> alreadyAdded) {
        for (Extension extension : ServiceFactory.getExtensionService().getInternalExtensions().values()) {
            this.addExtension(extension, alreadyAdded);
        }
    }

    public void addExtension(Extension extension, List<JmxGet> alreadyAdded) {
        if (extension.isEnabled()) {
            this.getStoredJmxGets(extension.getJmxConfig(), alreadyAdded, extension.getName(), extension);
        }
    }

    private void getStoredJmxGets(Collection<JmxConfiguration> configs, List<JmxGet> alreadyAdded, String extensionName, Extension origin) {
        for (JmxConfiguration parser : configs) {
            boolean isEnabled = parser.getEnabled();
            if (!isEnabled) continue;
            String objectNameString = parser.getObjectName();
            if (objectNameString == null || objectNameString.trim().length() == 0) {
                Agent.LOG.log(Level.WARNING, "Not recording JMX metric because the object name is null or empty in extension " + extensionName);
                continue;
            }
            Map<JmxType, List<String>> attrs = parser.getAttrs();
            if (attrs == null || attrs.size() == 0) {
                Agent.LOG.log(Level.WARNING, MessageFormat.format("Not recording JMX metric with object name {0} in extension {1} because there are no attributes.", objectNameString, extensionName));
                continue;
            }
            this.createLogAddJmxGet(objectNameString, parser.getRootMetricName(), attrs, alreadyAdded, origin);
        }
    }
}

