/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.discovery;

import com.newrelic.agent.discovery.Externalizable;
import com.newrelic.agent.discovery.TerminalColor;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Objects;
import java.util.logging.Level;

public class StatusMessage
implements Serializable,
Externalizable {
    private static final String URL_LABEL = "Url";
    static final long serialVersionUID = -1921492641455922593L;
    private final String id;
    private final Level level;
    private final String label;
    private final String message;

    public StatusMessage(String id, Level level, String label, String message) {
        this.id = id;
        this.level = level;
        this.label = label;
        this.message = message;
    }

    public static StatusMessage success(String id, String url) {
        return new StatusMessage(id, Level.INFO, URL_LABEL, url);
    }

    public static StatusMessage info(String id, String label, String message) {
        return new StatusMessage(id, Level.INFO, label, message);
    }

    public static StatusMessage error(String id, String label, String message) {
        return new StatusMessage(id, Level.SEVERE, label, message);
    }

    public static StatusMessage warn(String id, String label, String message) {
        return new StatusMessage(id, Level.WARNING, label, message);
    }

    public String getLabel() {
        return this.label;
    }

    public String getMessage() {
        return this.message;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getProcessId() {
        return this.id;
    }

    public String toString() {
        return TerminalColor.fromLevel(this.level).formatMessage(this.label, this.message);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.id);
        out.writeUTF(this.level.getName());
        out.writeUTF(this.label);
        out.writeUTF(this.message);
    }

    public static StatusMessage readExternal(ObjectInput in) throws IOException {
        return new StatusMessage(in.readUTF(), Level.parse(in.readUTF()), in.readUTF(), in.readUTF());
    }

    public boolean isSuccess() {
        return URL_LABEL.equals(this.label);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.label, this.level, this.message);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatusMessage other = (StatusMessage)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.label, other.label) && Objects.equals(this.level, other.level) && Objects.equals(this.message, other.message);
    }
}

