/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.ObfuscateJvmPropsConfig;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ObfuscateJvmPropsConfigImpl
extends BaseConfig
implements ObfuscateJvmPropsConfig {
    private static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.obfuscate_jvm_props.";
    private static final String ALLOW = "allow";
    private static final String BLOCK = "block";
    private static final String ENABLED = "enabled";
    private static final boolean DEFAULT_ENABLED = true;
    private static final Set<String> DEFAULT_ALLOW = Collections.singleton("-X*");
    private final boolean isEnabled = this.getProperty("enabled", true);
    private final Set<String> blockList = this.initializeBlock();
    private final Set<String> allowList = this.initializeAllow();

    public ObfuscateJvmPropsConfigImpl(Map<String, Object> props) {
        super(props, SYSTEM_PROPERTY_ROOT);
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public Set<String> getAllow() {
        return this.allowList;
    }

    @Override
    public Set<String> getBlock() {
        return this.blockList;
    }

    private Set<String> initializeBlock() {
        return new HashSet<String>(this.getUniqueStrings(BLOCK));
    }

    private Set<String> initializeAllow() {
        HashSet<String> tempAllow = new HashSet<String>(this.getUniqueStrings(ALLOW));
        tempAllow.addAll(DEFAULT_ALLOW);
        return tempAllow;
    }
}

