/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.KotlinCoroutinesConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class KotlinCoroutinesConfigImpl
extends BaseConfig
implements KotlinCoroutinesConfig {
    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.coroutines.";
    public static final String CONTINUATIONS_ROOT = "continuations";
    public static final String SCOPES_ROOT = "scopes";
    public static final String DISPATCHED_ROOT = "dispatched";
    public static final String IGNORE = "ignore";
    public static final String IGNORE_REGEX = "ignoreRegex";
    public static final String DELAYED_ROOT = "delayed";
    public static final String ENABLED = "enabled";
    private static final boolean DELAY_DEFAULT = true;
    private String[] ignoredContinuations = null;
    private String[] ignoredScopes = null;
    private String[] ignoredDispatched = null;
    private String[] ignoredRegexContinuations = null;
    private String[] ignoredRegexScopes = null;
    private String[] ignoredRegexDispatched = null;
    private String[] ignoredSuspends = null;
    private String[] ignoredRegexSuspends = null;
    private boolean delayedEnabled = true;

    public KotlinCoroutinesConfigImpl(Map<String, Object> props) {
        super(props, SYSTEM_PROPERTY_ROOT);
        Map continuations_root = (Map)this.getProperty(CONTINUATIONS_ROOT);
        if (continuations_root != null) {
            String continuationsToIgnore = (String)continuations_root.get(IGNORE);
            this.ignoredContinuations = this.splitString(continuationsToIgnore);
            String continuationsToIgnoreRegex = (String)continuations_root.get(IGNORE_REGEX);
            this.ignoredRegexContinuations = this.splitString(continuationsToIgnoreRegex);
        } else {
            this.ignoredContinuations = new String[0];
            this.ignoredRegexContinuations = new String[0];
        }
        Map scopes_root = (Map)this.getProperty(SCOPES_ROOT);
        if (scopes_root != null) {
            String scopesToIgnore = (String)scopes_root.get(IGNORE);
            this.ignoredScopes = this.splitString(scopesToIgnore);
            String scopesToIgnoreRegex = (String)scopes_root.get(IGNORE_REGEX);
            this.ignoredRegexScopes = this.splitString(scopesToIgnoreRegex);
        } else {
            this.ignoredScopes = new String[0];
            this.ignoredRegexScopes = new String[0];
        }
        Map dispatched_root = (Map)this.getProperty(DISPATCHED_ROOT);
        if (dispatched_root != null) {
            String dispatchedToIgnore = (String)dispatched_root.get(IGNORE);
            this.ignoredDispatched = this.splitString(dispatchedToIgnore);
            String dispatchedToIgnoreRegex = (String)dispatched_root.get(IGNORE_REGEX);
            this.ignoredRegexDispatched = this.splitString(dispatchedToIgnoreRegex);
        } else {
            this.ignoredDispatched = new String[0];
            this.ignoredRegexDispatched = new String[0];
        }
        Map delayed_root = (Map)this.getProperty(DELAYED_ROOT);
        if (delayed_root != null) {
            Object delayedObj = delayed_root.get(ENABLED);
            if (delayedObj != null) {
                if (delayedObj instanceof Boolean) {
                    this.delayedEnabled = (Boolean)delayedObj;
                } else if (delayedObj instanceof String) {
                    this.delayedEnabled = Boolean.parseBoolean((String)delayedObj);
                }
            }
        } else {
            this.delayedEnabled = true;
        }
    }

    static KotlinCoroutinesConfigImpl create(Map<String, Object> settings) {
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        return new KotlinCoroutinesConfigImpl(settings);
    }

    @Override
    public String[] getIgnoredContinuations() {
        return this.ignoredContinuations;
    }

    @Override
    public String[] getIgnoredRegExContinuations() {
        return this.ignoredRegexContinuations;
    }

    @Override
    public String[] getIgnoredScopes() {
        return this.ignoredScopes;
    }

    @Override
    public String[] getIgnoredRegexScopes() {
        return this.ignoredRegexScopes;
    }

    @Override
    public String[] getIgnoredDispatched() {
        return this.ignoredDispatched;
    }

    @Override
    public String[] getIgnoredRegexDispatched() {
        return this.ignoredRegexDispatched;
    }

    @Override
    public String[] getIgnoredSuspends() {
        return this.ignoredSuspends;
    }

    @Override
    public String[] getIgnoredRegexSuspends() {
        return this.ignoredRegexSuspends;
    }

    @Override
    public boolean isDelayedEnabled() {
        return this.delayedEnabled;
    }

    private String[] splitString(String input) {
        if (input == null) {
            return new String[0];
        }
        String[] firstSplit = input.split("\"");
        ArrayList<String> result = new ArrayList<String>();
        for (String s2 : firstSplit) {
            if (s2.trim().equals(",")) continue;
            result.add(s2.trim());
        }
        String[] returnValue = new String[result.size()];
        result.toArray(returnValue);
        return returnValue;
    }
}

