/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.weavepackage;

import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.com.google.common.collect.Queues;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.deps.org.objectweb.asm.tree.AnnotationNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.ClassNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.FieldNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodNode;
import com.newrelic.weave.ClassMatch;
import com.newrelic.weave.ClassWeave;
import com.newrelic.weave.MethodProcessors;
import com.newrelic.weave.PreparedExtension;
import com.newrelic.weave.PreparedMatch;
import com.newrelic.weave.utils.ClassCache;
import com.newrelic.weave.utils.ClassInformation;
import com.newrelic.weave.utils.WeaveUtils;
import com.newrelic.weave.violation.ReferenceViolation;
import com.newrelic.weave.violation.WeaveViolation;
import com.newrelic.weave.violation.WeaveViolationType;
import com.newrelic.weave.weavepackage.NewFieldValidator;
import com.newrelic.weave.weavepackage.PackageWeaveResult;
import com.newrelic.weave.weavepackage.Reference;
import com.newrelic.weave.weavepackage.WeavePackage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Pattern;

public class PackageValidationResult {
    private static final Pattern WEAVE_PACKAGE_PATTERN = Pattern.compile("^com.newrelic.weave..*");
    private final Queue<WeaveViolation> violations = Queues.newConcurrentLinkedQueue();
    private final Map<String, ClassNode> utilClasses = Maps.newConcurrentMap();
    private final Map<String, ClassNode> allAnnotationClasses = Maps.newConcurrentMap();
    private final Map<String, ClassNode> baseAnnotationClasses = Maps.newConcurrentMap();
    private final Map<String, byte[]> annotationProxyClasses = Maps.newConcurrentMap();
    private final Map<String, PreparedMatch> exactMatches = Maps.newConcurrentMap();
    private final Map<String, PreparedMatch> baseMatches = Maps.newConcurrentMap();
    private final WeavePackage weavePackage;
    private ClassNode errorHandler;
    private ClassNode extensionTemplate;

    public PackageValidationResult(WeavePackage weavePackage, ClassCache cache, Collection<Reference> references, Map<String, ClassNode> exactWeaves, Map<String, ClassNode> baseWeaves, Map<String, ClassNode> allAnnotationClasses, Map<String, ClassNode> baseAnnotationClasses, Map<String, ClassNode> utilClasses, Set<String> skipIfPresentNames, ClassNode errorHandler, ClassNode extensionTemplate) throws IOException {
        this.weavePackage = weavePackage;
        this.errorHandler = errorHandler;
        this.extensionTemplate = extensionTemplate;
        this.utilClasses.putAll(utilClasses);
        this.allAnnotationClasses.putAll(allAnnotationClasses);
        this.baseAnnotationClasses.putAll(baseAnnotationClasses);
        this.skipIfPresent(skipIfPresentNames, cache);
        this.validateReferences(cache, references);
        this.processMatches(cache, exactWeaves, this.exactMatches, false, errorHandler);
        this.processMatches(cache, baseWeaves, this.baseMatches, true, errorHandler);
        for (String string : this.utilClasses.keySet()) {
            if (!cache.hasClassResource(string) || WEAVE_PACKAGE_PATTERN.matcher(string).matches()) continue;
            this.violations.add(new WeaveViolation(WeaveViolationType.ILLEGAL_CLASS_NAME, string));
        }
        for (Map.Entry entry : this.utilClasses.entrySet()) {
            if (null != entry.getValue()) continue;
            this.violations.add(new WeaveViolation(WeaveViolationType.MISSING_ORIGINAL_BYTECODE, (String)entry.getKey()));
        }
        this.rewriteAllNewFieldCalls();
        if (!this.succeeded()) {
            this.exactMatches.clear();
            this.baseMatches.clear();
            this.utilClasses.clear();
            this.allAnnotationClasses.clear();
            this.baseAnnotationClasses.clear();
        }
    }

    public PackageValidationResult(WeavePackage weavePackage, ClassCache cache, Set<String> requiredClasses, Set<String> illegalClasses) {
        this.weavePackage = weavePackage;
        for (String requiredClass : requiredClasses) {
            if (cache.hasClassResource(requiredClass)) continue;
            this.violations.add(new WeaveViolation(WeaveViolationType.MISSING_ORIGINAL_BYTECODE, requiredClass));
            return;
        }
        for (String illegalClass : illegalClasses) {
            if (!cache.hasClassResource(illegalClass)) continue;
            this.violations.add(new WeaveViolation(WeaveViolationType.SKIP_IF_PRESENT, illegalClass));
            return;
        }
    }

    PackageValidationResult(WeavePackage weavePackage, Queue<WeaveViolation> packageViolations) {
        this.weavePackage = weavePackage;
        this.violations.addAll(packageViolations);
    }

    private void skipIfPresent(Set<String> skipIfPresentNames, ClassCache cache) {
        for (String skipIfPresentName : skipIfPresentNames) {
            if (!cache.hasClassResource(skipIfPresentName)) continue;
            this.violations.add(new WeaveViolation(WeaveViolationType.SKIP_IF_PRESENT, skipIfPresentName));
        }
    }

    private void validateReferences(ClassCache classCache, Collection<Reference> references) throws IOException {
        for (Reference reference : references) {
            byte[] bytes = classCache.getClassResource(reference.className);
            if (null == bytes) {
                this.violations.add(new ReferenceViolation(WeaveViolationType.MISSING_ORIGINAL_BYTECODE, reference.referenceOrigin, reference.className, "Could not find resource"));
                continue;
            }
            ClassNode classNode = WeaveUtils.convertToClassNode(bytes);
            this.violations.addAll(reference.validateClassNode(classCache, classNode));
        }
    }

    private void processMatches(ClassCache classCache, Map<String, ClassNode> classNameToWeaveNode, Map<String, PreparedMatch> results, boolean isBaseMatch, ClassNode errorHandler) throws IOException {
        for (String weaveClassName : classNameToWeaveNode.keySet()) {
            byte[] originalBytes = classCache.getClassResource(weaveClassName);
            if (null == originalBytes) {
                this.violations.add(new WeaveViolation(WeaveViolationType.MISSING_ORIGINAL_BYTECODE, weaveClassName));
                continue;
            }
            ClassNode originalClassNode = WeaveUtils.convertToClassNode(originalBytes);
            ClassNode weaveNode = classNameToWeaveNode.get(weaveClassName);
            Set<String> requiredClassAnnotations = this.weavePackage.getRequiredAnnotationClassesForAnnotationWeave(weaveClassName);
            this.buildResults(classCache, originalClassNode, weaveClassName, weaveNode, results, isBaseMatch, requiredClassAnnotations, errorHandler);
        }
    }

    private void buildResults(ClassCache classCache, ClassNode originalClassNode, String weaveClassName, ClassNode weaveNode, Map<String, PreparedMatch> results, boolean isBaseMatch, Set<String> requiredClassAnnotations, ClassNode errorHandler) throws IOException {
        ClassMatch match = ClassMatch.match(originalClassNode, weaveNode, isBaseMatch, requiredClassAnnotations, classCache);
        NewFieldValidator.validate(match, this.violations);
        PreparedMatch prepared = PreparedMatch.prepare(match, errorHandler, this.getWeavePackage().extensionTemplate, true);
        results.put(weaveClassName, prepared);
        if (null != prepared.getExtension()) {
            ClassNode extension = prepared.getExtension().generateExtensionClass();
            this.utilClasses.put(extension.name, extension);
        }
        for (String newInnerClassName : prepared.getNewInnerClasses()) {
            if (!this.utilClasses.containsKey(newInnerClassName)) continue;
            ClassNode newInnerClassNode = this.utilClasses.get(newInnerClassName);
            match.validateNewInnerClass(newInnerClassNode);
            newInnerClassNode = prepared.prepareNewInnerClass(newInnerClassNode);
            this.utilClasses.remove(newInnerClassName);
            String newInnerClassRenamed = prepared.nameNewInnerClass(newInnerClassName);
            this.utilClasses.put(newInnerClassRenamed, newInnerClassNode);
        }
        Map<String, ClassNode> annotationProxyClasses = prepared.getAnnotationProxyClasses();
        for (Map.Entry<String, ClassNode> annotationProxyClass : annotationProxyClasses.entrySet()) {
            this.annotationProxyClasses.put(annotationProxyClass.getKey(), WeaveUtils.convertToClassBytes(annotationProxyClass.getValue(), classCache));
        }
        this.violations.addAll(match.getViolations());
    }

    private void rewriteAllNewFieldCalls() {
        ArrayList<PreparedExtension> preparedExtensions = new ArrayList<PreparedExtension>();
        HashSet<PreparedMatch> allMatches = new HashSet<PreparedMatch>(this.exactMatches.size() + this.baseMatches.size());
        allMatches.addAll(this.exactMatches.values());
        allMatches.addAll(this.baseMatches.values());
        for (PreparedMatch preparedMatch : allMatches) {
            if (null == preparedMatch.getExtension()) continue;
            preparedExtensions.add(preparedMatch.getExtension());
        }
        if (preparedExtensions.size() > 0) {
            for (PreparedMatch preparedMatch : allMatches) {
                MethodProcessors.rewriteNewFieldCalls(preparedMatch.getWeaveName(), preparedMatch.getPreparedMatchedMethods(), preparedMatch.getNewFields(), preparedMatch.getMatchedFields(), preparedExtensions, this.getSuperWeaves(preparedMatch.getWeaveSuperName()));
            }
            for (Map.Entry entry : this.utilClasses.entrySet()) {
                HashMap<Method, MethodNode> methodMap;
                HashSet<String> matchedFields;
                ClassNode utilNode = (ClassNode)entry.getValue();
                if (null == utilNode.fields) {
                    matchedFields = new HashSet<String>(0);
                } else {
                    matchedFields = new HashSet(utilNode.fields.size());
                    for (FieldNode field : utilNode.fields) {
                        matchedFields.add(field.name);
                    }
                }
                if (null == utilNode.methods) {
                    methodMap = new HashMap<Method, MethodNode>(0);
                } else {
                    methodMap = new HashMap(utilNode.methods.size());
                    for (MethodNode methodNode : utilNode.methods) {
                        methodMap.put(new Method(methodNode.name, methodNode.desc), methodNode);
                    }
                }
                MethodProcessors.rewriteNewFieldCalls(utilNode.name, methodMap, new HashSet<String>(0), matchedFields, preparedExtensions, this.getSuperWeaves(utilNode.superName));
                utilNode.methods = new ArrayList(methodMap.values());
            }
        }
    }

    private List<PreparedMatch> getSuperWeaves(String superName) {
        PreparedMatch superMatch;
        ArrayList<PreparedMatch> superMatches = new ArrayList<PreparedMatch>();
        String currentName = superName;
        while (null != currentName && null != (superMatch = this.exactMatches.get(currentName))) {
            superMatches.add(superMatch);
            currentName = superMatch.getWeaveSuperName();
        }
        currentName = superName;
        while (null != currentName && null != (superMatch = this.baseMatches.get(currentName))) {
            superMatches.add(superMatch);
            currentName = superMatch.getWeaveSuperName();
        }
        return superMatches;
    }

    public boolean succeeded() {
        return this.violations.size() == 0;
    }

    public List<WeaveViolation> getViolations() {
        return Lists.newArrayList(this.violations);
    }

    public PackageWeaveResult weave(String className, String[] superNames, String[] interfaceNames, byte[] targetBytes, ClassCache cache) {
        ClassNode composite = WeaveUtils.convertToClassNode(targetBytes);
        return this.weave(className, superNames, interfaceNames, composite, cache);
    }

    public PackageWeaveResult weave(String className, String[] superNames, String[] interfaceNames, ClassNode targetNode, ClassCache cache) {
        String key;
        ClassWeave classWeave;
        PreparedMatch baseMatch;
        int i;
        String key2;
        ClassWeave classWeave2;
        ClassNode composite = targetNode;
        HashMap<String, List<Method>> weavedMethods = Maps.newHashMap();
        PreparedMatch exactMatch = this.exactMatches.get(className);
        if (null != exactMatch) {
            classWeave2 = ClassWeave.weave(exactMatch, composite);
            composite = classWeave2.getComposite();
            key2 = exactMatch.getOriginalName();
            if (weavedMethods.containsKey(key2)) {
                ((List)weavedMethods.get(key2)).addAll(classWeave2.getWeavedMethods());
            } else {
                weavedMethods.put(key2, classWeave2.getWeavedMethods());
            }
        }
        if (null != (exactMatch = this.baseMatches.get(className))) {
            classWeave2 = ClassWeave.weave(exactMatch, composite);
            composite = classWeave2.getComposite();
            key2 = exactMatch.getOriginalName();
            if (weavedMethods.containsKey(key2)) {
                ((List)weavedMethods.get(key2)).addAll(classWeave2.getWeavedMethods());
            } else {
                weavedMethods.put(key2, classWeave2.getWeavedMethods());
            }
        }
        for (i = 0; i < superNames.length; ++i) {
            baseMatch = this.baseMatches.get(superNames[i]);
            if (null == baseMatch) continue;
            classWeave = ClassWeave.weave(baseMatch, composite);
            composite = classWeave.getComposite();
            key = baseMatch.getOriginalName();
            if (weavedMethods.containsKey(key)) {
                ((List)weavedMethods.get(key)).addAll(classWeave.getWeavedMethods());
                continue;
            }
            weavedMethods.put(key, classWeave.getWeavedMethods());
        }
        for (i = 0; i < interfaceNames.length; ++i) {
            baseMatch = this.baseMatches.get(interfaceNames[i]);
            if (null == baseMatch) continue;
            classWeave = ClassWeave.weave(baseMatch, composite);
            composite = classWeave.getComposite();
            key = baseMatch.getOriginalName();
            if (weavedMethods.containsKey(key)) {
                ((List)weavedMethods.get(key)).addAll(classWeave.getWeavedMethods());
                continue;
            }
            weavedMethods.put(key, classWeave.getWeavedMethods());
        }
        if (!this.allAnnotationClasses.isEmpty()) {
            Set<String> targetAnnotationsClasses = this.getAnnotationClasses(targetNode);
            Set<Object> targetInterfacesAnnotationClasses = Collections.emptySet();
            if (!this.baseAnnotationClasses.isEmpty()) {
                targetInterfacesAnnotationClasses = this.getAllInterfaceAnnotationClasses(targetNode, cache);
            }
            for (Map.Entry<String, ClassNode> entry : this.allAnnotationClasses.entrySet()) {
                if (!targetAnnotationsClasses.contains(entry.getKey())) continue;
                composite = this.getAnnotationMatchComposite(targetNode, entry.getValue(), composite, weavedMethods, cache);
            }
            for (Map.Entry<String, ClassNode> entry : this.baseAnnotationClasses.entrySet()) {
                if (!targetInterfacesAnnotationClasses.contains(entry.getKey())) continue;
                composite = this.getAnnotationMatchComposite(targetNode, entry.getValue(), composite, weavedMethods, cache);
            }
        }
        return new PackageWeaveResult(this, className, composite, weavedMethods);
    }

    private ClassNode getAnnotationMatchComposite(ClassNode targetNode, ClassNode weaveNode, ClassNode composite, Map<String, List<Method>> weavedMethods, ClassCache cache) {
        try {
            boolean isInterfaceMatch = WeaveUtils.isWeaveWithAnnotationInterfaceMatch(weaveNode);
            HashMap<String, PreparedMatch> results = Maps.newHashMap();
            this.buildResults(cache, targetNode, weaveNode.name, weaveNode, results, isInterfaceMatch, this.weavePackage.getRequiredAnnotationClassesForAnnotationWeave(weaveNode.name), this.errorHandler);
            if (!this.violations.isEmpty()) {
                return composite;
            }
            for (Map.Entry result : results.entrySet()) {
                PreparedMatch prepared = (PreparedMatch)result.getValue();
                if (prepared == null) continue;
                ClassWeave classWeave = ClassWeave.weave(prepared, composite);
                composite = classWeave.getComposite();
                String key = prepared.getWeaveName();
                if (weavedMethods.containsKey(key)) {
                    weavedMethods.get(key).addAll(classWeave.getWeavedMethods());
                    continue;
                }
                weavedMethods.put(key, classWeave.getWeavedMethods());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return composite;
    }

    private Set<String> getAllInterfaceAnnotationClasses(ClassNode targetClass, ClassCache classCache) {
        HashSet<String> interfaceAnnotationClasses = Sets.newHashSet();
        try {
            Set<String> interfaceNames;
            ClassInformation classInformation = classCache.getClassInformation(targetClass.name);
            if (classInformation != null && (interfaceNames = classInformation.getAllInterfaces(classCache)) != null) {
                for (String interfaceName : interfaceNames) {
                    ClassInformation interfaceInformation = classCache.getClassInformation(interfaceName);
                    if (interfaceInformation == null) continue;
                    interfaceAnnotationClasses.addAll(interfaceInformation.classAnnotationNames);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return interfaceAnnotationClasses;
    }

    private Set<String> getAnnotationClasses(ClassNode targetNode) {
        HashSet<String> classAnnotations = Sets.newHashSet();
        if (targetNode.visibleAnnotations != null) {
            for (AnnotationNode visibleAnnotation : targetNode.visibleAnnotations) {
                classAnnotations.add(Type.getType(visibleAnnotation.desc).getClassName());
            }
        }
        if (targetNode.invisibleAnnotations != null) {
            for (AnnotationNode invisibleAnnotation : targetNode.invisibleAnnotations) {
                classAnnotations.add(Type.getType(invisibleAnnotation.desc).getClassName());
            }
        }
        return classAnnotations;
    }

    public Map<String, byte[]> computeUtilityClassBytes(ClassCache cache) {
        HashMap<String, byte[]> utilClassBytes = new HashMap<String, byte[]>(this.utilClasses.size());
        for (Map.Entry<String, ClassNode> entry : this.utilClasses.entrySet()) {
            utilClassBytes.put(entry.getKey(), WeaveUtils.convertToClassBytes(entry.getValue(), cache));
        }
        return utilClassBytes;
    }

    public Map<String, byte[]> getAnnotationProxyClasses() {
        return this.annotationProxyClasses;
    }

    public WeavePackage getWeavePackage() {
        return this.weavePackage;
    }
}

