/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.weavepackage;

import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.weave.utils.JarUtils;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.JarFile;

public class NewClassAppender {
    private static final ProtectionDomain PROTECTION_DOMAIN = NewClassAppender.class.getProtectionDomain();
    static final Method defineClassMethod;

    public static void appendClassesToBootstrapClassLoader(Instrumentation instrumentation, Map<String, byte[]> classBytesMap) throws IOException {
        instrumentation.appendToBootstrapClassLoaderSearch(new JarFile(JarUtils.createJarFile("instrumentation", classBytesMap)));
    }

    public static void appendClasses(ClassLoader classloader, Map<String, byte[]> classBytesMap) throws IOException {
        NewClassAppender.loadClassesInTopologicalOrder(classloader, classBytesMap);
    }

    public static Class<?> defineClass(ClassLoader classloader, String className, byte[] classBytes, int offset, int length, ProtectionDomain protectionDomain) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return (Class)defineClassMethod.invoke((Object)classloader, className.replace('/', '.'), classBytes, offset, length, protectionDomain);
    }

    private static void loadClassesInTopologicalOrder(ClassLoader classloader, Map<String, byte[]> classBytesMap) throws IOException {
        boolean continueLoading = true;
        HashMap<String, byte[]> loadedClasses = Maps.newHashMap();
        HashSet<String> unloadedClasses = Sets.newHashSet(classBytesMap.keySet());
        while (continueLoading && unloadedClasses.size() > 0) {
            continueLoading = false;
            for (String classname : unloadedClasses) {
                byte[] classBytes = classBytesMap.get(classname);
                if (null == classBytes) continue;
                try {
                    NewClassAppender.defineClass(classloader, classname.replace('/', '.'), classBytes, 0, classBytes.length, PROTECTION_DOMAIN);
                    continueLoading = true;
                    loadedClasses.put(classname, classBytes);
                }
                catch (Exception e) {
                    if (e.getCause() instanceof LinkageError) {
                        String errorMessage = e.getCause().getMessage();
                        if (errorMessage == null || !errorMessage.contains("attempted  duplicate class definition")) continue;
                        continueLoading = true;
                        loadedClasses.put(classname, classBytes);
                        continue;
                    }
                    throw new IOException(e);
                }
            }
            unloadedClasses.removeAll(loadedClasses.keySet());
        }
        if (unloadedClasses.size() > 0) {
            // empty if block
        }
    }

    private NewClassAppender() {
    }

    static {
        try {
            defineClassMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
            defineClassMethod.setAccessible(true);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

