/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave;

import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.tree.ClassNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.InsnList;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodNode;
import com.newrelic.weave.MethodKey;
import com.newrelic.weave.utils.ClassCache;
import com.newrelic.weave.utils.WeaveUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;

class MatchableMethod {
    public final Source source;
    public final MethodNode methodNode;
    public final boolean isWeavable;

    private MatchableMethod(Source source, MethodNode methodNode, boolean isWeavable) {
        this.source = source;
        this.methodNode = methodNode;
        this.isWeavable = isWeavable;
    }

    static Map<MethodKey, MatchableMethod> findMatchableMethods(ClassNode original, ClassCache cache, boolean isBaseMatch) throws IOException {
        HashMap<MethodKey, MatchableMethod> methodMap = Maps.newHashMap();
        boolean isInnerOriginal = WeaveUtils.isNonstaticInnerClass(original);
        for (MethodNode originalMethod : original.methods) {
            if (MatchableMethod.isSyntheticOrBridge(originalMethod.access)) continue;
            Object desc = originalMethod.desc;
            if (isInnerOriginal && originalMethod.name.equals("<init>")) {
                Type[] constructorArgs = Type.getArgumentTypes((String)desc);
                Type[] truncatedArgs = Arrays.copyOfRange(constructorArgs, 1, constructorArgs.length);
                desc = Type.getMethodDescriptor(Type.VOID_TYPE, truncatedArgs);
            }
            boolean isAbstract = (originalMethod.access & 0x400) != 0;
            boolean isWeavable = !isAbstract || isBaseMatch;
            MethodKey key = new MethodKey(originalMethod.name, (String)desc);
            methodMap.put(key, new MatchableMethod(Source.ORIGINAL, originalMethod, isWeavable));
        }
        if (!original.superName.equals(WeaveUtils.JAVA_LANG_OBJECT_NAME)) {
            String superName = original.superName;
            while (!superName.equals(WeaveUtils.JAVA_LANG_OBJECT_NAME) && cache.hasClassResource(superName)) {
                ClassNode superNode = WeaveUtils.convertToClassNode(cache.getClassResource(superName));
                for (MethodNode methodNode : superNode.methods) {
                    MethodKey key;
                    if (MatchableMethod.isSyntheticOrBridge(methodNode.access) || methodNode.name.equals("<init>") || methodNode.name.equals("<clinit>") || methodMap.containsKey(key = new MethodKey(methodNode)) || (methodNode.access & 2) != 0) continue;
                    if (!isBaseMatch) {
                        methodMap.put(key, new MatchableMethod(Source.SUPERCLASS, methodNode, false));
                        continue;
                    }
                    if ((methodNode.access & 0x10) != 0) {
                        methodMap.put(key, new MatchableMethod(Source.SUPERCLASS, methodNode, false));
                        continue;
                    }
                    if ((methodNode.access & 0x400) != 0) {
                        methodMap.put(key, new MatchableMethod(Source.SUPERCLASS, methodNode, true));
                        continue;
                    }
                    boolean hasReturnInstruction = false;
                    InsnList instructions = methodNode.instructions;
                    int instructionsSize = instructions.size();
                    for (int i = 0; i < instructionsSize; ++i) {
                        int opcode = instructions.get(i).getOpcode();
                        if (opcode < 172 || opcode > 177) continue;
                        hasReturnInstruction = true;
                        break;
                    }
                    methodMap.put(key, new MatchableMethod(Source.SUPERCLASS, methodNode, !hasReturnInstruction));
                }
                superName = superNode.superName;
            }
        }
        if (original.interfaces != null && !original.interfaces.isEmpty()) {
            HashSet<String> processedInterfaces = Sets.newHashSet();
            LinkedList<String> queuedInterfaces = Lists.newLinkedList(original.interfaces);
            while (!queuedInterfaces.isEmpty()) {
                String currentInterface = (String)queuedInterfaces.remove();
                if (!cache.hasClassResource(currentInterface)) continue;
                ClassNode interfaceNode = WeaveUtils.convertToClassNode(cache.getClassResource(currentInterface));
                for (MethodNode methodNode : interfaceNode.methods) {
                    MethodKey key;
                    if (MatchableMethod.isSyntheticOrBridge(methodNode.access) || methodMap.containsKey(key = new MethodKey(methodNode))) continue;
                    methodMap.put(key, new MatchableMethod(Source.INTERFACE, methodNode, false));
                }
                processedInterfaces.add(currentInterface);
                if (interfaceNode.interfaces == null || interfaceNode.interfaces.isEmpty()) continue;
                for (String nextInterface : interfaceNode.interfaces) {
                    if (processedInterfaces.contains(nextInterface)) continue;
                    queuedInterfaces.add(nextInterface);
                }
            }
        }
        return methodMap;
    }

    private static boolean isSyntheticOrBridge(int access) {
        return (access & 0x1000) != 0 || (access & 0x40) != 0;
    }

    static enum Source {
        ORIGINAL,
        INTERFACE,
        SUPERCLASS;

    }
}

