/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.bootstrap;

import com.newrelic.agent.deps.com.google.common.cache.CacheBuilder;
import com.newrelic.agent.deps.com.google.common.cache.CacheLoader;
import com.newrelic.agent.deps.com.google.common.cache.LoadingCache;
import com.newrelic.bootstrap.BootstrapLoader;
import com.newrelic.bootstrap.EmbeddedJarFiles;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;

public class EmbeddedJarFilesImpl
implements EmbeddedJarFiles {
    private static final String[] INTERNAL_JAR_FILE_NAMES = new String[]{"agent-bridge", "newrelic-api", "newrelic-weaver-api"};
    public static final EmbeddedJarFiles INSTANCE = new EmbeddedJarFilesImpl();
    private final LoadingCache<String, File> embeddedAgentJarFiles = CacheBuilder.newBuilder().build(new CacheLoader<String, File>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public File load(String jarNameWithoutExtension) throws IOException {
            InputStream jarStream = EmbeddedJarFilesImpl.class.getClassLoader().getResourceAsStream(jarNameWithoutExtension + ".jar");
            if (jarStream == null) {
                throw new FileNotFoundException(jarNameWithoutExtension + ".jar");
            }
            File file = File.createTempFile(jarNameWithoutExtension, ".jar", BootstrapLoader.getTempDir());
            file.deleteOnExit();
            FileOutputStream out = new FileOutputStream(file);
            try {
                BootstrapLoader.copy(jarStream, out, 8096, true);
                File file2 = file;
                return file2;
            }
            finally {
                ((OutputStream)out).close();
            }
        }
    });
    private final String[] jarFileNames;

    public EmbeddedJarFilesImpl() {
        this(INTERNAL_JAR_FILE_NAMES);
    }

    public EmbeddedJarFilesImpl(String[] jarFileNames) {
        this.jarFileNames = jarFileNames;
    }

    @Override
    public File getJarFileInAgent(String jarNameWithoutExtension) throws IOException {
        try {
            return this.embeddedAgentJarFiles.get(jarNameWithoutExtension);
        }
        catch (ExecutionException e) {
            try {
                throw e.getCause();
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    public String[] getEmbeddedAgentJarFileNames() {
        return this.jarFileNames;
    }
}

