/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.utilization;

import com.newrelic.agent.utilization.AWS;
import com.newrelic.agent.utilization.UtilizationConfig;
import java.util.HashMap;
import java.util.Map;

public class UtilizationData {
    private static final String METADATA_VERSION_KEY = "metadata_version";
    private static final String LOGICAL_CORES_KEY = "logical_processors";
    private static final String RAM_KEY = "total_ram_mib";
    private static final String HOSTNAME_KEY = "hostname";
    private static final String VENDORS_KEY = "vendors";
    private static final String AWS = "aws";
    private static final String AWS_INSTANCE_ID_KEY = "id";
    private static final String AWS_INSTANCE_TYPE_KEY = "type";
    private static final String AWS_ZONE_KEY = "zone";
    private static final String DOCKER = "docker";
    private static final String DOCKER_ID_KEY = "id";
    private static final String CONFIG_KEY = "config";
    private final String hostname;
    private final String dockerContainerId;
    private final String awsInstanceType;
    private final String awsInstanceId;
    private final String awsZone;
    private final Integer logicalProcessorCount;
    private final Long totalRamMib;
    private final UtilizationConfig dataConfig;

    public UtilizationData(String host, Integer logicalProcessorCt, String dockerId, AWS.AwsData awsData, Long ram, UtilizationConfig configData) {
        this.hostname = host;
        this.logicalProcessorCount = new Integer(0).equals(logicalProcessorCt) ? null : logicalProcessorCt;
        this.dockerContainerId = dockerId;
        this.awsInstanceId = awsData.getInstanceId();
        this.awsInstanceType = awsData.getInstanceType();
        this.awsZone = awsData.getAvailabityZone();
        this.totalRamMib = new Long(0L).equals(ram) ? null : ram;
        this.dataConfig = configData;
    }

    public Map<String, Object> map() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(METADATA_VERSION_KEY, 2);
        data.put(LOGICAL_CORES_KEY, this.logicalProcessorCount);
        data.put(RAM_KEY, this.totalRamMib);
        data.put(HOSTNAME_KEY, this.hostname);
        HashMap vendors = new HashMap();
        if (this.awsInstanceId != null) {
            HashMap<String, String> aws = new HashMap<String, String>();
            aws.put("id", this.awsInstanceId);
            aws.put(AWS_INSTANCE_TYPE_KEY, this.awsInstanceType);
            aws.put(AWS_ZONE_KEY, this.awsZone);
            vendors.put(AWS, aws);
        }
        HashMap<String, Object> utilizationConfig = new HashMap<String, Object>();
        if (this.dataConfig.getHostname() != null) {
            utilizationConfig.put(HOSTNAME_KEY, this.dataConfig.getHostname());
        }
        if (this.dataConfig.getLogicalProcessors() != null) {
            utilizationConfig.put(LOGICAL_CORES_KEY, this.dataConfig.getLogicalProcessors());
        }
        if (this.dataConfig.getTotalRamMib() != null) {
            utilizationConfig.put(RAM_KEY, this.dataConfig.getTotalRamMib());
        }
        if (!utilizationConfig.isEmpty()) {
            data.put(CONFIG_KEY, utilizationConfig);
        }
        if (this.dockerContainerId != null) {
            HashMap<String, String> docker = new HashMap<String, String>();
            docker.put("id", this.dockerContainerId);
            vendors.put(DOCKER, docker);
        }
        if (!vendors.isEmpty()) {
            data.put(VENDORS_KEY, vendors);
        }
        return data;
    }
}

