/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.module;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class EmbeddedJars {
    private static final String EMBEDDED_JAR = ".jar!/";

    private EmbeddedJars() {
    }

    public static InputStream getInputStream(URL url) throws IOException {
        InputStream inputStream;
        int index = url.toExternalForm().indexOf(EMBEDDED_JAR);
        if (index > 0) {
            String path = url.toExternalForm().substring(index + EMBEDDED_JAR.length());
            inputStream = (url = new URL(url.toExternalForm().substring(0, index) + ".jar")).openStream();
            JarInputStream jarStream = new JarInputStream(inputStream);
            if (!EmbeddedJars.readToEntry(jarStream, path)) {
                inputStream.close();
                throw new IOException("Unable to open stream for " + path + " in " + url.toExternalForm());
            }
            inputStream = jarStream;
        } else {
            inputStream = url.openStream();
        }
        return inputStream;
    }

    private static boolean readToEntry(JarInputStream jarStream, String path) throws IOException {
        JarEntry jarEntry = null;
        while ((jarEntry = jarStream.getNextJarEntry()) != null) {
            if (!path.equals(jarEntry.getName())) continue;
            return true;
        }
        return false;
    }

    static JarInputStream getJarInputStream(URL url) throws IOException {
        boolean isEmbedded = url.toExternalForm().contains(EMBEDDED_JAR);
        InputStream stream = EmbeddedJars.getInputStream(url);
        if (!isEmbedded && stream instanceof JarInputStream) {
            return (JarInputStream)stream;
        }
        return new JarInputStream(stream);
    }
}

