/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.module;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.org.objectweb.asm.AnnotationVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.ClassWriter;
import com.newrelic.agent.deps.org.objectweb.asm.FieldVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.TypePath;
import com.newrelic.agent.service.module.ShaChecksums;
import com.newrelic.bootstrap.BootstrapLoader;
import com.newrelic.weave.utils.Streams;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;

public class ClassMetadataFiles {
    static final String CLASS_INFO_ANNOTATION = "Lcom/newrelic/agent/ClassInfo;";
    static final int ANNOTATION_VALUE_LIMIT = 255;

    private ClassMetadataFiles() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createClassMetadataFile(URL url) throws IOException {
        File outFile = File.createTempFile("struct", ".cmd", BootstrapLoader.getTempDir());
        outFile.deleteOnExit();
        JarInputStream in = new JarInputStream(url.openStream());
        try {
            Manifest manifest = in.getManifest();
            if (null == manifest) {
                manifest = new Manifest();
            }
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile));
            JarOutputStream jarOut = new JarOutputStream((OutputStream)out, manifest);
            try {
                JarEntry entry = in.getNextJarEntry();
                while (entry != null) {
                    if (entry.getName().endsWith(".class") && !entry.getName().endsWith("/package-info.class")) {
                        JarEntry newEntry = new JarEntry(entry.getName());
                        jarOut.putNextEntry(newEntry);
                        try {
                            ByteArrayOutputStream classBytes = new ByteArrayOutputStream(8192);
                            Streams.copy((InputStream)in, (OutputStream)classBytes, false);
                            ClassMetadataFiles.writeClassMetadata(classBytes.toByteArray(), jarOut);
                        }
                        finally {
                            jarOut.closeEntry();
                        }
                    }
                    entry = in.getNextJarEntry();
                }
            }
            finally {
                jarOut.close();
            }
            File file = outFile;
            return file;
        }
        finally {
            in.close();
        }
    }

    private static void writeClassMetadata(byte[] classBytes, OutputStream out) throws IOException {
        String sha1checksum = null;
        try {
            sha1checksum = ShaChecksums.computeSha(new ByteArrayInputStream(classBytes));
        }
        catch (NoSuchAlgorithmException e) {
            Agent.LOG.log(Level.FINEST, e, "{0}", new Object[]{e.getMessage()});
        }
        ClassReader cr = new ClassReader(classBytes);
        ClassWriter cw = new ClassWriter(2);
        ClassVisitor cv = new ClassVisitor(327680, cw){

            @Override
            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                return super.visitField(access, name, desc, signature, null);
            }
        };
        if (sha1checksum != null) {
            final String checksum = sha1checksum;
            cv = new ClassVisitor(327680, cv){

                @Override
                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    super.visit(version, access, name, signature, superName, interfaces);
                    AnnotationVisitor av = super.visitAnnotation(ClassMetadataFiles.CLASS_INFO_ANNOTATION, true);
                    av.visit("sha1Checksum", checksum);
                    av.visitEnd();
                }

                @Override
                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    return new TruncatingAnnotationVisitor(super.visitAnnotation(desc, visible));
                }

                @Override
                public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
                    return new TruncatingAnnotationVisitor(super.visitTypeAnnotation(typeRef, typePath, desc, visible));
                }

                @Override
                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    return new MethodVisitor(327680, super.visitMethod(access, name, desc, signature, exceptions)){

                        @Override
                        public AnnotationVisitor visitAnnotationDefault() {
                            return new TruncatingAnnotationVisitor(super.visitAnnotationDefault());
                        }

                        @Override
                        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                            return new TruncatingAnnotationVisitor(super.visitAnnotation(desc, visible));
                        }
                    };
                }
            };
        }
        cr.accept(cv, 1);
        out.write(cw.toByteArray());
    }

    static Object truncateAnnotationValue(Object value) {
        if (value instanceof String) {
            if (value.toString().length() > 255) {
                value = value.toString().substring(0, 255);
            }
        } else if (value.getClass().isArray()) {
            if (value.getClass().getComponentType().isPrimitive() && Byte.TYPE.isAssignableFrom(value.getClass().getComponentType())) {
                value = new byte[0];
            } else if (Array.getLength(value) > 255) {
                try {
                    Object newArray = Array.newInstance(value.getClass().getComponentType(), 255);
                    System.arraycopy(value, 0, newArray, 0, 255);
                    value = newArray;
                }
                catch (Exception e) {
                    Agent.LOG.log(Level.FINEST, e, e.getMessage(), new Object[0]);
                }
            }
        }
        return value;
    }

    private static class TruncatingAnnotationVisitor
    extends AnnotationVisitor {
        public TruncatingAnnotationVisitor(AnnotationVisitor annotationVisitor) {
            super(327680, annotationVisitor);
        }

        @Override
        public void visit(String name, Object value) {
            value = ClassMetadataFiles.truncateAnnotationValue(value);
            super.visit(name, value);
        }
    }
}

