/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.service.ServiceFactory;

abstract class CustomInsightsEventsConfigUtils {
    public static final int DEFAULT_MAX_SAMPLES_STORED = 10000;
    public static final boolean DEFAULT_ENABLED = true;

    CustomInsightsEventsConfigUtils() {
    }

    static boolean isCustomInsightsEventsEnabled(AgentConfig config, int maxSamplesStored) {
        boolean notHighSecurity = !ServiceFactory.getConfigService().getDefaultAgentConfig().isHighSecurity();
        boolean storedMoreThan0 = maxSamplesStored > 0;
        Boolean configEnabled = (Boolean)config.getValue("custom_insights_events.enabled", true);
        Boolean featureGateEnabled = (Boolean)config.getValue("custom_insights_events.collect_custom_events", true);
        return notHighSecurity && storedMoreThan0 && configEnabled != false && featureGateEnabled != false;
    }

    static int getMaxSamplesStored(AgentConfig config) {
        return (Integer)config.getValue("custom_insights_events.max_samples_stored", 10000);
    }
}

