/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service;

import com.newrelic.agent.GCService;
import com.newrelic.agent.HarvestService;
import com.newrelic.agent.HarvestServiceImpl;
import com.newrelic.agent.IAgent;
import com.newrelic.agent.RPMServiceManager;
import com.newrelic.agent.RPMServiceManagerImpl;
import com.newrelic.agent.ThreadService;
import com.newrelic.agent.TracerService;
import com.newrelic.agent.TransactionService;
import com.newrelic.agent.attributes.AttributesService;
import com.newrelic.agent.browser.BrowserService;
import com.newrelic.agent.browser.BrowserServiceImpl;
import com.newrelic.agent.cache.CacheService;
import com.newrelic.agent.circuitbreaker.CircuitBreakerService;
import com.newrelic.agent.commands.CommandParser;
import com.newrelic.agent.config.ConfigService;
import com.newrelic.agent.config.ConfigServiceFactory;
import com.newrelic.agent.config.ConfigurationException;
import com.newrelic.agent.database.DatabaseService;
import com.newrelic.agent.deadlock.DeadlockDetectorService;
import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.environment.EnvironmentService;
import com.newrelic.agent.environment.EnvironmentServiceImpl;
import com.newrelic.agent.extension.ExtensionService;
import com.newrelic.agent.instrumentation.ClassTransformerService;
import com.newrelic.agent.instrumentation.ClassTransformerServiceImpl;
import com.newrelic.agent.jmx.JmxService;
import com.newrelic.agent.normalization.NormalizationService;
import com.newrelic.agent.normalization.NormalizationServiceImpl;
import com.newrelic.agent.profile.ProfilerService;
import com.newrelic.agent.reinstrument.RemoteInstrumentationService;
import com.newrelic.agent.reinstrument.RemoteInstrumentationServiceImpl;
import com.newrelic.agent.rpm.RPMConnectionService;
import com.newrelic.agent.rpm.RPMConnectionServiceImpl;
import com.newrelic.agent.samplers.CPUSamplerService;
import com.newrelic.agent.samplers.NoopSamplerService;
import com.newrelic.agent.samplers.SamplerService;
import com.newrelic.agent.samplers.SamplerServiceImpl;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.NoopService;
import com.newrelic.agent.service.Service;
import com.newrelic.agent.service.ServiceManager;
import com.newrelic.agent.service.ServiceTiming;
import com.newrelic.agent.service.StatsServiceMetricAggregator;
import com.newrelic.agent.service.analytics.InsightsService;
import com.newrelic.agent.service.analytics.InsightsServiceImpl;
import com.newrelic.agent.service.analytics.TransactionEventsService;
import com.newrelic.agent.service.async.AsyncTransactionService;
import com.newrelic.agent.service.module.JarCollectorService;
import com.newrelic.agent.service.module.JarCollectorServiceImpl;
import com.newrelic.agent.sql.SqlTraceService;
import com.newrelic.agent.sql.SqlTraceServiceImpl;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsService;
import com.newrelic.agent.stats.StatsServiceImpl;
import com.newrelic.agent.stats.StatsWork;
import com.newrelic.agent.trace.TransactionTraceService;
import com.newrelic.agent.utilization.UtilizationService;
import com.newrelic.agent.xray.IXRaySessionService;
import com.newrelic.agent.xray.XRaySessionService;
import com.newrelic.api.agent.MetricAggregator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ServiceManagerImpl
extends AbstractService
implements ServiceManager {
    private final ConcurrentMap<String, Service> services = new ConcurrentHashMap<String, Service>();
    private volatile ExtensionService extensionService;
    private volatile ProfilerService profilerService;
    private volatile TracerService tracerService;
    private volatile TransactionTraceService transactionTraceService;
    private volatile ThreadService threadService;
    private volatile HarvestService harvestService;
    private volatile Service gcService;
    private volatile TransactionService transactionService;
    private volatile JmxService jmxService;
    private volatile TransactionEventsService transactionEventsService;
    private volatile CommandParser commandParser;
    private volatile RPMServiceManager rpmServiceManager;
    private volatile Service cpuSamplerService;
    private volatile DeadlockDetectorService deadlockDetectorService;
    private volatile SamplerService samplerService;
    private volatile ConfigService configService;
    private volatile RPMConnectionService rpmConnectionService;
    private volatile EnvironmentService environmentService;
    private volatile ClassTransformerService classTransformerService;
    private volatile StatsService statsService = new InitialStatsService();
    private volatile SqlTraceService sqlTraceService;
    private volatile DatabaseService databaseService;
    private volatile BrowserService browserService;
    private volatile JarCollectorService jarCollectorService;
    private volatile CacheService cacheService;
    private volatile NormalizationService normalizationService;
    private volatile RemoteInstrumentationService remoteInstrumentationService;
    private final IAgent agentService;
    private volatile IXRaySessionService xrayService;
    private volatile AttributesService attsService;
    private volatile UtilizationService utilizationService;
    private volatile InsightsService insightsService;
    private volatile AsyncTransactionService asyncTxService;
    private volatile CircuitBreakerService circuitBreakerService;
    private final List<StatsWork> statsWork = Lists.newArrayList();

    public ServiceManagerImpl(IAgent agent) throws ConfigurationException {
        super(ServiceManagerImpl.class.getSimpleName());
        this.agentService = agent;
        this.configService = ConfigServiceFactory.createConfigService();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    protected synchronized void doStart() throws Exception {
        this.agentService.start();
        this.threadService = new ThreadService();
        this.circuitBreakerService = new CircuitBreakerService();
        this.classTransformerService = new ClassTransformerServiceImpl(this.agentService.getInstrumentation());
        this.jmxService = new JmxService();
        this.extensionService = new ExtensionService();
        this.jarCollectorService = new JarCollectorServiceImpl();
        this.tracerService = new TracerService();
        this.asyncTxService = new AsyncTransactionService();
        this.environmentService = new EnvironmentServiceImpl();
        this.cacheService = new CacheService();
        this.extensionService.start();
        this.classTransformerService.start();
        boolean realAgent = this.agentService.getInstrumentation() != null;
        this.statsService = new StatsServiceImpl();
        this.replayStartupStatsWork();
        this.utilizationService = new UtilizationService();
        if (realAgent) {
            this.utilizationService.start();
        }
        this.rpmConnectionService = new RPMConnectionServiceImpl();
        this.transactionService = new TransactionService();
        this.rpmServiceManager = new RPMServiceManagerImpl();
        this.normalizationService = new NormalizationServiceImpl();
        this.harvestService = new HarvestServiceImpl();
        this.gcService = realAgent ? new GCService() : new NoopService("GC Service");
        this.transactionTraceService = new TransactionTraceService();
        this.transactionEventsService = new TransactionEventsService();
        this.profilerService = new ProfilerService();
        this.commandParser = new CommandParser();
        this.cpuSamplerService = realAgent ? new CPUSamplerService() : new NoopService("CPU Sampler");
        this.deadlockDetectorService = new DeadlockDetectorService();
        this.samplerService = (SamplerService)((Object)(realAgent ? new SamplerServiceImpl() : new NoopSamplerService()));
        this.sqlTraceService = new SqlTraceServiceImpl();
        this.databaseService = new DatabaseService();
        this.browserService = new BrowserServiceImpl();
        this.remoteInstrumentationService = new RemoteInstrumentationServiceImpl();
        this.xrayService = new XRaySessionService();
        this.attsService = new AttributesService();
        this.insightsService = new InsightsServiceImpl();
        this.harvestService.addHarvestListener(this.extensionService);
        this.asyncTxService.start();
        this.threadService.start();
        this.statsService.start();
        this.environmentService.start();
        this.rpmConnectionService.start();
        this.tracerService.start();
        this.jarCollectorService.start();
        this.harvestService.start();
        this.gcService.start();
        this.transactionService.start();
        this.transactionTraceService.start();
        this.transactionEventsService.start();
        this.profilerService.start();
        this.commandParser.start();
        this.jmxService.start();
        this.cpuSamplerService.start();
        this.deadlockDetectorService.start();
        this.samplerService.start();
        this.sqlTraceService.start();
        this.browserService.start();
        this.cacheService.start();
        this.normalizationService.start();
        this.databaseService.start();
        this.configService.start();
        this.remoteInstrumentationService.start();
        this.xrayService.start();
        this.attsService.start();
        this.insightsService.start();
        this.circuitBreakerService.start();
        this.startServices();
        this.rpmServiceManager.start();
        ServiceTiming.setEndTime();
        ServiceTiming.logServiceTimings(this.getLogger());
    }

    @Override
    protected synchronized void doStop() throws Exception {
        this.insightsService.stop();
        this.circuitBreakerService.stop();
        this.remoteInstrumentationService.stop();
        this.configService.stop();
        this.classTransformerService.stop();
        this.agentService.stop();
        this.rpmConnectionService.stop();
        this.deadlockDetectorService.stop();
        this.jarCollectorService.stop();
        this.harvestService.stop();
        this.cpuSamplerService.stop();
        this.samplerService.stop();
        this.sqlTraceService.stop();
        this.normalizationService.stop();
        this.databaseService.stop();
        this.extensionService.stop();
        this.transactionService.stop();
        this.tracerService.stop();
        this.threadService.stop();
        this.transactionTraceService.stop();
        this.transactionEventsService.stop();
        this.profilerService.stop();
        this.commandParser.stop();
        this.jmxService.stop();
        this.rpmServiceManager.stop();
        this.environmentService.stop();
        this.statsService.stop();
        this.browserService.stop();
        this.cacheService.stop();
        this.xrayService.stop();
        this.attsService.stop();
        this.stopServices();
    }

    private void startServices() throws Exception {
        for (Service service : this.services.values()) {
            service.start();
        }
    }

    private void stopServices() throws Exception {
        for (Service service : this.services.values()) {
            service.stop();
        }
    }

    @Override
    public void addService(Service service) {
        this.services.put(service.getName(), service);
    }

    @Override
    public Map<String, Map<String, Object>> getServicesConfiguration() {
        HashMap<String, Map<String, Object>> config = new HashMap<String, Map<String, Object>>();
        HashMap<String, Boolean> serviceInfo = new HashMap<String, Boolean>();
        serviceInfo.put("enabled", this.transactionService.isEnabled());
        config.put("TransactionService", serviceInfo);
        serviceInfo = new HashMap();
        config.put("TransactionTraceService", serviceInfo);
        serviceInfo.put("enabled", this.transactionTraceService.isEnabled());
        serviceInfo = new HashMap();
        config.put("TransactionEventsService", serviceInfo);
        serviceInfo.put("enabled", this.transactionEventsService.isEnabled());
        serviceInfo = new HashMap();
        serviceInfo.put("enabled", this.profilerService.isEnabled());
        config.put("ProfilerService", serviceInfo);
        serviceInfo = new HashMap();
        serviceInfo.put("enabled", this.tracerService.isEnabled());
        config.put("TracerService", serviceInfo);
        serviceInfo = new HashMap();
        serviceInfo.put("enabled", this.commandParser.isEnabled());
        config.put("CommandParser", serviceInfo);
        serviceInfo = new HashMap();
        serviceInfo.put("enabled", this.jmxService.isEnabled());
        config.put("JmxService", serviceInfo);
        serviceInfo = new HashMap();
        serviceInfo.put("enabled", this.threadService.isEnabled());
        config.put("ThreadService", serviceInfo);
        serviceInfo = new HashMap();
        serviceInfo.put("enabled", this.deadlockDetectorService.isEnabled());
        config.put("DeadlockService", serviceInfo);
        for (Service service : this.services.values()) {
            serviceInfo = new HashMap();
            serviceInfo.put("enabled", service.isEnabled());
            config.put(service.getClass().getSimpleName(), serviceInfo);
        }
        return config;
    }

    @Override
    public Service getService(String name) {
        return (Service)this.services.get(name);
    }

    @Override
    public ExtensionService getExtensionService() {
        return this.extensionService;
    }

    @Override
    public ProfilerService getProfilerService() {
        return this.profilerService;
    }

    @Override
    public TracerService getTracerService() {
        return this.tracerService;
    }

    @Override
    public TransactionTraceService getTransactionTraceService() {
        return this.transactionTraceService;
    }

    @Override
    public ThreadService getThreadService() {
        return this.threadService;
    }

    @Override
    public HarvestService getHarvestService() {
        return this.harvestService;
    }

    @Override
    public TransactionService getTransactionService() {
        return this.transactionService;
    }

    @Override
    public JmxService getJmxService() {
        return this.jmxService;
    }

    @Override
    public TransactionEventsService getTransactionEventsService() {
        return this.transactionEventsService;
    }

    @Override
    public CommandParser getCommandParser() {
        return this.commandParser;
    }

    @Override
    public RPMServiceManager getRPMServiceManager() {
        return this.rpmServiceManager;
    }

    @Override
    public SamplerService getSamplerService() {
        return this.samplerService;
    }

    @Override
    public IAgent getAgent() {
        return this.agentService;
    }

    @Override
    public ConfigService getConfigService() {
        return this.configService;
    }

    @Override
    public RPMConnectionService getRPMConnectionService() {
        return this.rpmConnectionService;
    }

    @Override
    public EnvironmentService getEnvironmentService() {
        return this.environmentService;
    }

    @Override
    public ClassTransformerService getClassTransformerService() {
        return this.classTransformerService;
    }

    @Override
    public StatsService getStatsService() {
        return this.statsService;
    }

    @Override
    public SqlTraceService getSqlTraceService() {
        return this.sqlTraceService;
    }

    @Override
    public DatabaseService getDatabaseService() {
        return this.databaseService;
    }

    @Override
    public CacheService getCacheService() {
        return this.cacheService;
    }

    @Override
    public AsyncTransactionService getAsyncTxService() {
        return this.asyncTxService;
    }

    @Override
    public BrowserService getBrowserService() {
        return this.browserService;
    }

    @Override
    public NormalizationService getNormalizationService() {
        return this.normalizationService;
    }

    @Override
    public JarCollectorService getJarCollectorService() {
        return this.jarCollectorService;
    }

    @Override
    public RemoteInstrumentationService getRemoteInstrumentationService() {
        return this.remoteInstrumentationService;
    }

    @Override
    public IXRaySessionService getXRaySessionService() {
        return this.xrayService;
    }

    @Override
    public AttributesService getAttributesService() {
        return this.attsService;
    }

    @Override
    public InsightsService getInsights() {
        return this.insightsService;
    }

    @Override
    public CircuitBreakerService getCircuitBreakerService() {
        return this.circuitBreakerService;
    }

    private void replayStartupStatsWork() {
        for (StatsWork work : this.statsWork) {
            this.statsService.doStatsWork(work);
        }
        this.statsWork.clear();
    }

    @Override
    public UtilizationService getUtilizationService() {
        return this.utilizationService;
    }

    private class InitialStatsService
    extends AbstractService
    implements StatsService {
        private final MetricAggregator metricAggregator;

        protected InitialStatsService() {
            super("Bootstrap stats service");
            this.metricAggregator = new StatsServiceMetricAggregator(this);
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void doStatsWork(StatsWork statsWork) {
            ServiceManagerImpl.this.statsWork.add(statsWork);
        }

        @Override
        public StatsEngine getStatsEngineForHarvest(String appName) {
            return null;
        }

        @Override
        protected void doStart() throws Exception {
        }

        @Override
        protected void doStop() throws Exception {
        }

        @Override
        public MetricAggregator getMetricAggregator() {
            return this.metricAggregator;
        }
    }
}

