/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile.v2;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.deps.org.json.simple.JSONStreamAware;
import com.newrelic.agent.deps.org.json.simple.JSONValue;
import com.newrelic.agent.profile.method.MethodInfo;
import com.newrelic.agent.profile.method.MethodInfoFactory;
import com.newrelic.agent.profile.v2.IProfile;
import com.newrelic.agent.util.StringMap;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.logging.Level;

public class ProfiledMethod
implements JSONStreamAware {
    private final StackTraceElement stackTraceElement;
    private final int hashCode;
    private MethodInfo info;
    private final IProfile profile;
    private final String methodId;

    private ProfiledMethod(String methodId, IProfile profile, StackTraceElement stackTraceElement) {
        this.profile = profile;
        this.stackTraceElement = stackTraceElement;
        this.hashCode = stackTraceElement.hashCode();
        this.methodId = methodId;
    }

    public static ProfiledMethod newProfiledMethod(String methodId, IProfile profile, StackTraceElement stackElement) {
        if (stackElement == null) {
            return null;
        }
        if (stackElement.getClassName() == null) {
            return null;
        }
        if (stackElement.getMethodName() == null) {
            return null;
        }
        return new ProfiledMethod(methodId, profile, stackElement);
    }

    public String getFullMethodName() {
        return this.getClassName() + ":" + this.getMethodName();
    }

    public String getMethodName() {
        return this.stackTraceElement.getMethodName();
    }

    public String getClassName() {
        return this.stackTraceElement.getClassName();
    }

    public final int getLineNumber() {
        return this.stackTraceElement.getLineNumber();
    }

    public String getMethodId() {
        return this.methodId;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProfiledMethod other = (ProfiledMethod)obj;
        return other.stackTraceElement.equals(this.stackTraceElement);
    }

    public String toString() {
        return this.getFullMethodName() + ":" + this.getLineNumber();
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        JSONValue.writeJSONString(this.methodId, out);
    }

    public JSONStreamAware getMethodJson() {
        StringMap stringMap = this.profile.getStringMap();
        final ArrayList<Object> data = Lists.newArrayList(stringMap.addString(this.getClassName()), stringMap.addString(this.getMethodName()), this.getLineNumber());
        if (this.info != null) {
            data.add(this.info.getJsonMethodMaps(stringMap));
        }
        return new JSONStreamAware(){

            @Override
            public void writeJSONString(Writer out) throws IOException {
                JSONArray.writeJSONString(data, out);
            }
        };
    }

    void setMethodInfo(MethodInfo methodInfo) {
        this.info = methodInfo;
    }

    void setMethodDetails(MethodInfoFactory methodInfoFactory) {
        if (null != this.info) {
            return;
        }
        try {
            this.info = methodInfoFactory.getMethodInfo(this.getClassName(), this.getMethodName(), this.getLineNumber());
        }
        catch (Throwable e) {
            Agent.LOG.log(Level.FINER, e, "Error finding MethodInfo for {0}.{1}", new Object[]{this.getClassName(), this.getMethodName()});
            this.info = null;
        }
    }
}

