/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.logging;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.org.apache.commons.logging.Log;
import com.newrelic.agent.deps.org.apache.commons.logging.LogConfigurationException;
import com.newrelic.agent.deps.org.apache.commons.logging.LogFactory;
import com.newrelic.agent.logging.AgentLogManager;
import com.newrelic.agent.logging.IAgentLogger;
import java.util.logging.Level;

public class ApacheCommonsAdaptingLogFactory
extends LogFactory {
    public static final IAgentLogger LOG = AgentLogManager.getLogger();

    @Override
    public Object getAttribute(String name) {
        return null;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    @Override
    public Log getInstance(Class clazz) throws LogConfigurationException {
        return new LogAdapter(clazz, Agent.LOG);
    }

    @Override
    public Log getInstance(String name) throws LogConfigurationException {
        return new LogAdapter(name, Agent.LOG);
    }

    @Override
    public void release() {
    }

    @Override
    public void removeAttribute(String name) {
    }

    @Override
    public void setAttribute(String name, Object value) {
    }

    private class LogAdapter
    implements Log {
        private final IAgentLogger logger;

        public LogAdapter(Class<?> clazz, IAgentLogger logger) {
            this.logger = logger.getChildLogger(clazz);
        }

        public LogAdapter(String name, IAgentLogger logger) {
            this.logger = logger.getChildLogger(name);
        }

        @Override
        public boolean isDebugEnabled() {
            return Agent.isDebugEnabled() && this.logger.isDebugEnabled();
        }

        @Override
        public boolean isErrorEnabled() {
            return this.isDebugEnabled() && this.logger.isLoggable(Level.SEVERE);
        }

        @Override
        public boolean isFatalEnabled() {
            return this.isDebugEnabled() && this.logger.isLoggable(Level.SEVERE);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.isDebugEnabled() && this.logger.isLoggable(Level.INFO);
        }

        @Override
        public boolean isTraceEnabled() {
            return this.isDebugEnabled() && this.logger.isLoggable(Level.FINEST);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.isDebugEnabled() && this.logger.isLoggable(Level.WARNING);
        }

        @Override
        public void trace(Object message) {
            if (this.isDebugEnabled()) {
                this.logger.trace(message.toString());
            }
        }

        @Override
        public void trace(Object message, Throwable t) {
            if (this.isDebugEnabled()) {
                this.logger.log(Level.FINEST, t, message.toString(), new Object[0]);
            }
        }

        @Override
        public void debug(Object message) {
            if (this.isDebugEnabled()) {
                this.logger.debug(message.toString());
            }
        }

        @Override
        public void debug(Object message, Throwable t) {
            if (this.isDebugEnabled()) {
                this.logger.log(Level.FINEST, "{0} : {1}", new Object[]{message, t});
            }
        }

        @Override
        public void info(Object message) {
            if (this.isDebugEnabled()) {
                this.logger.info(message.toString());
            }
        }

        @Override
        public void info(Object message, Throwable t) {
            if (this.isDebugEnabled()) {
                this.logger.log(Level.INFO, "{0} : {1}", new Object[]{message, t});
            }
        }

        @Override
        public void warn(Object message) {
            if (this.isDebugEnabled()) {
                this.logger.warning(message.toString());
            }
        }

        @Override
        public void warn(Object message, Throwable t) {
            if (this.isDebugEnabled()) {
                this.logger.log(Level.WARNING, "{0} : {1}", new Object[]{message, t});
            }
        }

        @Override
        public void error(Object message) {
            if (this.isDebugEnabled()) {
                this.logger.error(message.toString());
            }
        }

        @Override
        public void error(Object message, Throwable t) {
            if (this.isDebugEnabled()) {
                this.logger.log(Level.SEVERE, "{0} : {1}", new Object[]{message, t});
            }
        }

        @Override
        public void fatal(Object message) {
            if (this.isDebugEnabled()) {
                this.logger.severe(message.toString());
            }
        }

        @Override
        public void fatal(Object message, Throwable t) {
            if (this.isDebugEnabled()) {
                this.logger.log(Level.SEVERE, "{0} : {1}", new Object[]{message, t});
            }
        }
    }
}

