/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.pointcuts.frameworks;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.instrumentation.PointCutConfiguration;
import com.newrelic.agent.instrumentation.TracerFactoryPointCut;
import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.instrumentation.pointcuts.PointCut;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.MethodExitTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.transaction.TransactionNamingPolicy;
import java.text.MessageFormat;
import java.util.logging.Level;

@PointCut
public class PathMapperPointCut
extends TracerFactoryPointCut {
    private static final String SITEMESH = "SiteMesh";

    public PathMapperPointCut(PointCutClassTransformer classTransformer) {
        super(new PointCutConfiguration(PathMapperPointCut.class.getName(), null, false), (ClassMatcher)new ExactClassMatcher("com/opensymphony/module/sitemesh/mapper/PathMapper"), (MethodMatcher)new ExactMethodMatcher("findKey", "(Ljava/lang/String;Ljava/util/Map;)Ljava/lang/String;"));
    }

    @Override
    public Tracer doGetTracer(Transaction transaction, ClassMethodSignature sig, Object object, Object[] args) {
        return new PathMapperTracer(transaction, sig, object, (String)args[0]);
    }

    private static class PathMapperTracer
    extends MethodExitTracer {
        public PathMapperTracer(Transaction transaction, ClassMethodSignature sig, Object mapper, String path) {
            super(sig, transaction);
        }

        @Override
        protected void doFinish(int opcode, Object key) {
            Transaction transaction = this.getTransaction();
            if (key != null && transaction != null) {
                Agent.LOG.finer("Normalizing path using SiteMesh config");
                String path = key.toString();
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                this.setTransactionName(transaction, path);
            }
        }

        private void setTransactionName(Transaction transaction, String path) {
            if (!transaction.isTransactionNamingEnabled()) {
                return;
            }
            TransactionNamingPolicy policy = TransactionNamingPolicy.getHigherPriorityTransactionNamingPolicy();
            if (Agent.LOG.isLoggable(Level.FINER) && policy.canSetTransactionName(transaction, TransactionNamePriority.FRAMEWORK)) {
                String msg = MessageFormat.format("Setting transaction name to \"{0}\" using SiteMesh config", path);
                Agent.LOG.finer(msg);
            }
            policy.setTransactionName(transaction, path, PathMapperPointCut.SITEMESH, TransactionNamePriority.FRAMEWORK);
        }
    }
}

