/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.builtin;

import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.api.agent.weaver.MatchType;
import com.newrelic.api.agent.weaver.Weave;
import com.newrelic.api.agent.weaver.WeaveAllConstructors;
import com.newrelic.api.agent.weaver.Weaver;

@Weave(type=MatchType.ExactClass, originalName="java.lang.ClassLoader")
public abstract class AgentClassLoaderInstrumentation {
    @WeaveAllConstructors
    protected AgentClassLoaderInstrumentation() {
    }

    private boolean isNewRelicClass(String className) {
        return className != null && (className.startsWith("com.newrelic.api.agent.") || className.startsWith("com.newrelic.agent.") || className.startsWith("com.newrelic.weave."));
    }

    public Class<?> loadClass(String name) throws Exception {
        Class<?> clazz;
        if (this.isNewRelicClass(name) && (clazz = this.loadNewRelicClass(name)) != null) {
            return clazz;
        }
        return (Class)Weaver.callOriginal();
    }

    private Class<?> loadNewRelicClass(String className) {
        try {
            ClassLoader classLoader;
            ClassLoader agentClassLoader = classLoader = AgentBridge.getAgent().getClass().getClassLoader();
            if (this != agentClassLoader) {
                return classLoader.loadClass(className);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

