/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.TransactionApiImpl;
import com.newrelic.agent.bridge.ExitTracer;
import com.newrelic.agent.bridge.Instrumentation;
import com.newrelic.agent.bridge.NoOpTransaction;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.instrumentation.InstrumentedClass;
import com.newrelic.agent.instrumentation.InstrumentedMethod;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.HashSafeClassAndMethodMatcher;
import com.newrelic.agent.instrumentation.classmatchers.OptimizedClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.AccessMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.AndMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.GetterSetterMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.NotMethodMatcher;
import com.newrelic.agent.profile.v2.TransactionProfileSession;
import com.newrelic.agent.reinstrument.PeriodicRetransformer;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.ClassMethodSignatures;
import com.newrelic.agent.tracers.DefaultSqlTracer;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracers.OtherRootSqlTracer;
import com.newrelic.agent.tracers.OtherRootTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.TracerFlags;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.tracers.metricname.MetricNameFormats;
import com.newrelic.agent.util.InsertOnlyArray;
import com.newrelic.api.agent.Logger;
import java.io.Closeable;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.logging.Level;

public class InstrumentationImpl
implements Instrumentation {
    private final Logger logger;
    private final InsertOnlyArray<Object> objectCache = new InsertOnlyArray(16);

    public InstrumentationImpl(Logger logger) {
        this.logger = logger;
    }

    public ExitTracer createTracer(Object invocationTarget, int signatureId, boolean dispatcher, String metricName, String tracerFactoryName, Object[] args) {
        Transaction transaction = Transaction.getTransaction(dispatcher);
        if (transaction == null) {
            return this.noticeTracer(signatureId, TracerFlags.getDispatcherFlags((boolean)dispatcher), null);
        }
        if (ServiceFactory.getServiceManager().getCircuitBreakerService().isTripped()) {
            return null;
        }
        try {
            if (!dispatcher && !transaction.isStarted() && tracerFactoryName == null) {
                return this.noticeTracer(signatureId, TracerFlags.getDispatcherFlags((boolean)dispatcher), null);
            }
            if (transaction.getTransactionActivity().isLeaf()) {
                return null;
            }
            ClassMethodSignature sig = ClassMethodSignatures.get().get(signatureId);
            return this.noticeTracer(signatureId, TracerFlags.getDispatcherFlags((boolean)dispatcher), transaction.getTransactionState().getTracer(transaction, tracerFactoryName, sig, invocationTarget, args));
        }
        catch (Throwable t) {
            this.logger.log(Level.FINEST, t, "createTracer({0}, {1}, {2})", new Object[]{invocationTarget, signatureId, metricName});
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExitTracer createTracer(Object invocationTarget, int signatureId, String metricName, int flags) {
        try {
            if (ServiceFactory.getServiceManager().getCircuitBreakerService().isTripped()) {
                return null;
            }
            TransactionActivity txa = TransactionActivity.get();
            if (txa != null && txa.getRootTracer() != null && txa.getRootTracer().isAsync() && txa.getTransaction() == null) {
                txa = null;
            }
            if (!Agent.canFastPath()) {
                return this.oldCreateTracer(txa, invocationTarget, signatureId, metricName, flags);
            }
            if (txa == null) {
                if (TracerFlags.isDispatcher((int)flags)) {
                    Transaction.getTransaction(true);
                    txa = TransactionActivity.get();
                } else if (TracerFlags.isAsync((int)flags)) {
                    txa = TransactionActivity.create(null, Integer.MAX_VALUE);
                }
                if (txa == null) {
                    return this.noticeTracer(signatureId, flags, null);
                }
                return this.noticeTracer(signatureId, flags, this.startTracer(txa, invocationTarget, signatureId, metricName, flags));
            }
            if (!TracerFlags.isRoot((int)flags) && !txa.isStarted()) {
                return this.noticeTracer(signatureId, flags, null);
            }
            DefaultTracer result = null;
            if (txa.checkTracerStart()) {
                try {
                    ClassMethodSignature sig = ClassMethodSignatures.get().get(signatureId);
                    MetricNameFormat mnf = MetricNameFormats.getFormatter(invocationTarget, sig, metricName, flags);
                    result = TracerFlags.isDispatcher((int)flags) || TracerFlags.isAsync((int)flags) && txa.getTransaction() != null && !txa.isStarted() ? new OtherRootTracer(txa, sig, invocationTarget, mnf) : new DefaultTracer(txa, sig, invocationTarget, mnf, flags);
                }
                finally {
                    txa.unlockTracerStart();
                }
                txa.tracerStarted(result);
            }
            return this.noticeTracer(signatureId, flags, result);
        }
        catch (Throwable t) {
            this.logger.log(Level.FINEST, t, "createTracer({0}, {1}, {2}, {3})", new Object[]{invocationTarget, signatureId, metricName, flags});
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExitTracer createSqlTracer(Object invocationTarget, int signatureId, String metricName, int flags) {
        try {
            if (ServiceFactory.getServiceManager().getCircuitBreakerService().isTripped()) {
                return null;
            }
            if (!Agent.canFastPath()) {
                return this.oldCreateSqlTracer(invocationTarget, signatureId, metricName, flags);
            }
            TransactionActivity txa = TransactionActivity.get();
            if (txa == null) {
                if (!TracerFlags.isDispatcher((int)flags)) {
                    return null;
                }
                Transaction tx = Transaction.getTransaction(true);
                ClassMethodSignature sig = ClassMethodSignatures.get().get(signatureId);
                return tx.getTransactionState().getSqlTracer(tx, invocationTarget, sig, metricName, flags);
            }
            if (!TracerFlags.isDispatcher((int)flags) && !txa.isStarted()) {
                return null;
            }
            DefaultSqlTracer result = null;
            if (txa.checkTracerStart()) {
                try {
                    ClassMethodSignature sig = ClassMethodSignatures.get().get(signatureId);
                    MetricNameFormat mnf = MetricNameFormats.getFormatter(invocationTarget, sig, metricName, flags);
                    result = TracerFlags.isDispatcher((int)flags) ? new OtherRootSqlTracer(txa, sig, invocationTarget, mnf) : new DefaultSqlTracer(txa, sig, invocationTarget, mnf, flags);
                }
                finally {
                    txa.unlockTracerStart();
                }
                txa.tracerStarted(result);
            }
            return result;
        }
        catch (Throwable t) {
            this.logger.log(Level.FINEST, t, "createTracer({0}, {1}, {2}, {3})", new Object[]{invocationTarget, signatureId, metricName, flags});
            return null;
        }
    }

    private ExitTracer noticeTracer(int signatureId, int tracerFlags, Tracer result) {
        try {
            TransactionProfileSession transactionProfileSession = ServiceFactory.getProfilerService().getTransactionProfileService().getTransactionProfileSession();
            if (transactionProfileSession.isActive()) {
                transactionProfileSession.noticeTracerStart(signatureId, tracerFlags, result);
            }
        }
        catch (Throwable t) {
            this.logger.log(Level.FINEST, t, "exception in noticeTracer: {0}. This may affect thread profile v2.", new Object[]{result});
        }
        return result;
    }

    private Tracer startTracer(TransactionActivity txa, Object target, int signatureId, String metricName, int flags) {
        ClassMethodSignature sig = ClassMethodSignatures.get().get(signatureId);
        MetricNameFormat mnf = MetricNameFormats.getFormatter(target, sig, metricName, flags);
        DefaultTracer tracer = TracerFlags.isRoot((int)flags) ? new OtherRootTracer(txa, sig, target, mnf, flags, System.nanoTime()) : new DefaultTracer(txa, sig, target, mnf, flags);
        txa.tracerStarted(tracer);
        return tracer;
    }

    private ExitTracer oldCreateTracer(TransactionActivity txa, Object invocationTarget, int signatureId, String metricName, int flags) {
        if (txa == null && TracerFlags.isAsync((int)flags)) {
            txa = TransactionActivity.create(null, Integer.MAX_VALUE);
            return this.startTracer(txa, invocationTarget, signatureId, metricName, flags);
        }
        Transaction transaction = Transaction.getTransaction(TracerFlags.isDispatcher((int)flags));
        if (transaction == null) {
            return null;
        }
        try {
            if (!TracerFlags.isDispatcher((int)flags) && !transaction.isStarted()) {
                return this.noticeTracer(signatureId, flags, null);
            }
            if (transaction.getTransactionActivity().isLeaf()) {
                return null;
            }
            ClassMethodSignature sig = ClassMethodSignatures.get().get(signatureId);
            return transaction.getTransactionState().getTracer(transaction, invocationTarget, sig, metricName, flags);
        }
        catch (Throwable t) {
            this.logger.log(Level.FINEST, t, "createTracer({0}, {1}, {2}, {3})", new Object[]{invocationTarget, signatureId, metricName, flags});
            return null;
        }
    }

    private ExitTracer oldCreateSqlTracer(Object invocationTarget, int signatureId, String metricName, int flags) {
        Transaction transaction = Transaction.getTransaction(TracerFlags.isDispatcher((int)flags));
        if (transaction == null) {
            return null;
        }
        try {
            if (!TracerFlags.isDispatcher((int)flags) && !transaction.isStarted()) {
                return null;
            }
            if (transaction.getTransactionActivity().isLeaf()) {
                return null;
            }
            ClassMethodSignature sig = ClassMethodSignatures.get().get(signatureId);
            return transaction.getTransactionState().getSqlTracer(transaction, invocationTarget, sig, metricName, flags);
        }
        catch (Throwable t) {
            this.logger.log(Level.FINEST, t, "createTracer({0}, {1}, {2}, {3})", new Object[]{invocationTarget, signatureId, metricName, flags});
            return null;
        }
    }

    public void noticeInstrumentationError(Throwable throwable, String libraryName) {
        if (Agent.LOG.isFinestEnabled()) {
            this.logger.log(Level.FINEST, throwable, "An error was thrown from instrumentation library {0}", new Object[]{libraryName});
        } else if (Agent.LOG.isFinerEnabled()) {
            this.logger.log(Level.FINER, "An error was thrown from instrumentation library {0} -- {1}", new Object[]{libraryName, throwable.getMessage()});
        }
    }

    public void instrument(String className, String metricPrefix) {
        HashSafeClassAndMethodMatcher matcher = new HashSafeClassAndMethodMatcher(new ExactClassMatcher(className), AndMethodMatcher.getMethodMatcher(new AccessMethodMatcher(1), new NotMethodMatcher(GetterSetterMethodMatcher.getGetterSetterMethodMatcher())));
        ServiceFactory.getClassTransformerService().addTraceMatcher(matcher, metricPrefix);
    }

    public void instrument(Method methodToInstrument, String metricPrefix) {
        if (methodToInstrument.isAnnotationPresent(InstrumentedMethod.class)) {
            return;
        }
        if (OptimizedClassMatcher.METHODS_WE_NEVER_INSTRUMENT.contains(com.newrelic.agent.deps.org.objectweb.asm.commons.Method.getMethod(methodToInstrument))) {
            return;
        }
        int modifiers = methodToInstrument.getModifiers();
        if (Modifier.isNative(modifiers) || Modifier.isAbstract(modifiers)) {
            return;
        }
        Class<?> declaringClass = methodToInstrument.getDeclaringClass();
        HashSafeClassAndMethodMatcher matcher = new HashSafeClassAndMethodMatcher(new ExactClassMatcher(declaringClass.getName()), new ExactMethodMatcher(methodToInstrument.getName(), Type.getMethodDescriptor(methodToInstrument)));
        boolean shouldRetransform = ServiceFactory.getClassTransformerService().addTraceMatcher(matcher, metricPrefix);
        if (shouldRetransform) {
            this.logger.log(Level.FINE, "Retransforming {0} for instrumentation.", new Object[]{methodToInstrument});
            PeriodicRetransformer.INSTANCE.queueRetransform(declaringClass);
        }
    }

    public void retransformUninstrumentedClass(Class<?> classToRetransform) {
        if (!classToRetransform.isAnnotationPresent(InstrumentedClass.class)) {
            this.retransformClass(classToRetransform);
        } else {
            this.logger.log(Level.FINER, "Class ", new Object[]{classToRetransform, " already instrumented."});
        }
    }

    private void retransformClass(Class<?> classToRetransform) {
        try {
            ServiceFactory.getAgent().getInstrumentation().retransformClasses(classToRetransform);
        }
        catch (UnmodifiableClassException e) {
            this.logger.log(Level.FINE, "Unable to retransform class ", new Object[]{classToRetransform, " : ", e.getMessage()});
        }
        catch (Throwable t) {
            this.logger.log(Level.FINE, "An exception occurred while retransforming class ", new Object[]{classToRetransform, " : ", t.getMessage()});
        }
    }

    public Class<?> loadClass(ClassLoader classLoader, Class<?> theClass) throws ClassNotFoundException {
        this.logger.log(Level.FINE, "Loading class ", new Object[]{theClass.getName(), " using class loader ", classLoader.toString()});
        try {
            return classLoader.loadClass(theClass.getName());
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.FINEST, "Unable to load {0}", new Object[]{theClass.getName()});
            throw new ClassNotFoundException("Unable to load " + theClass.getName());
        }
    }

    public com.newrelic.agent.bridge.Transaction getTransaction() {
        try {
            Transaction innerTx = Transaction.getTransaction(true);
            if (innerTx != null) {
                return TransactionApiImpl.INSTANCE;
            }
        }
        catch (Throwable t) {
            this.logger.log(Level.FINE, t, "Unable to get transaction, using no-op transaction instead", new Object[0]);
        }
        return NoOpTransaction.INSTANCE;
    }

    public com.newrelic.agent.bridge.Transaction getTransactionOrNull() {
        try {
            Transaction innerTx = Transaction.getTransaction(false);
            if (innerTx != null) {
                return TransactionApiImpl.INSTANCE;
            }
        }
        catch (Throwable t) {
            this.logger.log(Level.FINE, t, "getTransactionOrNull", new Object[0]);
        }
        return null;
    }

    public int addToObjectCache(Object object) {
        return this.objectCache.add(object);
    }

    public Object getCachedObject(int id) {
        return this.objectCache.get(id);
    }

    public void registerCloseable(String instrumentationName, Closeable closeable) {
        if (instrumentationName != null && closeable != null) {
            ServiceFactory.getClassTransformerService().getContextManager().getClassWeaverService().registerInstrumentationCloseable(instrumentationName, closeable);
        }
    }
}

