/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.extension.jaxb;

import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.extension.jaxb.UnmarshalException;
import com.newrelic.agent.extension.jaxb.Unmarshaller;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UnmarshallerFactory {
    static final Map<Class<?>, Unmarshaller<?>> cachedUnmarshallers = Maps.newConcurrentMap();

    public static <T> Unmarshaller<T> create(Class<T> clazz) throws UnmarshalException {
        Unmarshaller<?> cachedUnmarshaller = cachedUnmarshallers.get(clazz);
        if (cachedUnmarshaller != null) {
            return cachedUnmarshaller;
        }
        final Unmarshaller<T> unmarshaller = UnmarshallerFactory.create(clazz, Maps.newHashMap(Unmarshaller.getDefaultUnmarshallers()));
        Unmarshaller newUnmarshaller = new Unmarshaller<T>(clazz){

            @Override
            public T unmarshall(Node node) throws UnmarshalException {
                return unmarshaller.unmarshall(((Document)node).getDocumentElement());
            }
        };
        cachedUnmarshallers.put(clazz, newUnmarshaller);
        return newUnmarshaller;
    }

    private static <T> Unmarshaller<T> create(final Class<T> clazz, Map<Class<?>, Unmarshaller<?>> unmarshallers) throws UnmarshalException {
        try {
            final Setter attributesSetter = UnmarshallerFactory.getAttributesSetter(clazz, unmarshallers);
            final Setter childrenSetter = UnmarshallerFactory.getChildSetter(clazz, unmarshallers);
            Unmarshaller classUnmarshaller = new Unmarshaller<T>(clazz){

                @Override
                public T unmarshall(Node node) throws UnmarshalException {
                    try {
                        Object newInstance = clazz.newInstance();
                        attributesSetter.set(newInstance, node);
                        childrenSetter.set(newInstance, node);
                        return newInstance;
                    }
                    catch (InstantiationException e) {
                        throw new UnmarshalException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new UnmarshalException(e);
                    }
                }
            };
            unmarshallers.put(clazz, classUnmarshaller);
            return classUnmarshaller;
        }
        catch (InstantiationException e) {
            throw new UnmarshalException(e);
        }
        catch (IllegalAccessException e) {
            throw new UnmarshalException(e);
        }
    }

    private static Setter getChildSetter(final Class<?> clazz, Map<Class<?>, Unmarshaller<?>> unmarshallers) throws InstantiationException, IllegalAccessException, UnmarshalException {
        final HashMap<String, ChildSetter> childSetters = Maps.newHashMap();
        XmlType type = clazz.getAnnotation(XmlType.class);
        if (type != null) {
            for (String t : type.propOrder()) {
                if (t.isEmpty()) continue;
                try {
                    Field field = clazz.getDeclaredField(t);
                    field.setAccessible(true);
                    Class<?> fieldType = field.getType();
                    Unmarshaller<?> unmarshaller = UnmarshallerFactory.getUnmarshaller(unmarshallers, fieldType, field);
                    XmlValue xmlValue = field.getAnnotation(XmlValue.class);
                    if (xmlValue != null) {
                        if (type.propOrder().length > 1) {
                            throw new UnmarshalException(clazz.getName() + " has an @XmlValue field so only one child type was expected, but multiple were found: " + type.propOrder());
                        }
                        return new ChildSetter(t, unmarshaller, field);
                    }
                    childSetters.put(t, new ChildSetter(t, unmarshaller, field));
                }
                catch (Exception e) {
                    throw new UnmarshalException(e);
                }
            }
        }
        return new Setter(){

            @Override
            public void set(Object obj, Node node) throws IllegalArgumentException, IllegalAccessException, InstantiationException, UnmarshalException {
                NodeList childNodes = node.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Setter setter;
                    Node item = childNodes.item(i);
                    if (item.getNodeType() == 8) continue;
                    String nodeName = item.getNodeName();
                    String prefix = item.getPrefix();
                    if (prefix != null && !prefix.isEmpty()) {
                        nodeName = nodeName.substring(prefix.length() + 1);
                    }
                    if ((setter = (Setter)childSetters.get(nodeName)) != null) {
                        setter.set(obj, item);
                        continue;
                    }
                    throw new UnmarshalException("No setter for node name " + nodeName + " on " + clazz.getName());
                }
            }
        };
    }

    private static Setter getAttributesSetter(Class<?> clazz, Map<Class<?>, Unmarshaller<?>> unmarshallers) throws InstantiationException, IllegalAccessException, UnmarshalException {
        final ArrayList<AttributeSetter> attributeSetters = Lists.newArrayList();
        for (Field field : clazz.getDeclaredFields()) {
            XmlAttribute attribute = field.getAnnotation(XmlAttribute.class);
            if (attribute == null) continue;
            field.setAccessible(true);
            Class<?> declaringClass = field.getType();
            Unmarshaller<?> unmarshaller = UnmarshallerFactory.getUnmarshaller(unmarshallers, declaringClass, field);
            attributeSetters.add(new AttributeSetter(attribute.name(), unmarshaller, field));
        }
        return new Setter(){

            @Override
            public void set(Object obj, Node node) throws IllegalArgumentException, IllegalAccessException, InstantiationException, UnmarshalException {
                if (node.getAttributes() != null) {
                    for (Setter setter : attributeSetters) {
                        setter.set(obj, node);
                    }
                }
            }
        };
    }

    private static Unmarshaller<?> getUnmarshaller(Map<Class<?>, Unmarshaller<?>> unmarshallers, Class<?> clazz, Field field) throws InstantiationException, IllegalAccessException, UnmarshalException {
        Unmarshaller<Object> unmarshaller;
        if (clazz.isAssignableFrom(List.class)) {
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            clazz = (Class)parameterizedType.getActualTypeArguments()[0];
        }
        if ((unmarshaller = unmarshallers.get(clazz)) == null) {
            unmarshaller = UnmarshallerFactory.create(clazz, unmarshallers);
            unmarshallers.put(clazz, unmarshaller);
        }
        return unmarshaller;
    }

    private static class AttributeSetter
    implements Setter {
        private final String name;
        private final Unmarshaller<?> unmarshaller;
        private final Field field;

        public AttributeSetter(String name, Unmarshaller<?> unmarshaller, Field field) {
            this.name = name;
            this.unmarshaller = unmarshaller;
            this.field = field;
        }

        @Override
        public void set(Object obj, Node node) throws IllegalArgumentException, IllegalAccessException, InstantiationException, UnmarshalException {
            Object value;
            Node namedItem = node.getAttributes().getNamedItem(this.name);
            if (namedItem != null && (value = this.unmarshaller.unmarshall(namedItem)) != null) {
                this.field.set(obj, value);
            }
        }

        public String toString() {
            return "AttributeSetter [name=" + this.name + "]";
        }
    }

    private static class ChildSetter
    implements Setter {
        private final Unmarshaller<?> unmarshaller;
        private final Field field;

        public ChildSetter(String t, Unmarshaller<?> unmarshaller, Field field) {
            this.unmarshaller = unmarshaller;
            this.field = field;
        }

        @Override
        public void set(Object obj, Node node) throws IllegalArgumentException, IllegalAccessException, InstantiationException, UnmarshalException {
            Object value = this.unmarshaller.unmarshall(node);
            if (value != null) {
                if (this.field.getType().isAssignableFrom(List.class)) {
                    ArrayList<?> list = (ArrayList<?>)this.field.get(obj);
                    if (list == null) {
                        list = Lists.newArrayList();
                        this.field.set(obj, list);
                    }
                    list.add(value);
                } else {
                    this.field.set(obj, value);
                }
            }
        }

        public String toString() {
            return "ChildSetter [field=" + this.field + "]";
        }
    }

    private static interface Setter {
        public void set(Object var1, Node var2) throws IllegalArgumentException, IllegalAccessException, InstantiationException, UnmarshalException;
    }
}

