/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.errors;

import com.newrelic.agent.errors.ErrorServiceImpl;
import com.newrelic.agent.errors.TracedError;
import com.newrelic.agent.instrumentation.pointcuts.container.jetty.MultiException;
import com.newrelic.agent.util.StackTraces;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ThrowableError
extends TracedError {
    private static final String UNKNOWN_REQUEST_URI = "";
    private final Throwable throwable;

    public ThrowableError(String appName, String frontendMetricName, String requestUri, Throwable error, long timestamp, Map<String, Map<String, String>> prefixedParams, Map<String, Object> userParams, Map<String, Object> agentParams, Map<String, String> errorParams, Map<String, Object> intrinsics) {
        super(appName, frontendMetricName, timestamp, requestUri, prefixedParams, userParams, agentParams, errorParams, intrinsics);
        this.throwable = error;
    }

    public ThrowableError(String appName, String frontendMetricName, Throwable error, long timestamp, Map<String, Map<String, String>> prefixedParams, Map<String, Object> userParams, Map<String, Object> agentParams, Map<String, String> errorParams, Map<String, Object> intrinsics) {
        this(appName, frontendMetricName, UNKNOWN_REQUEST_URI, error, timestamp, prefixedParams, userParams, agentParams, errorParams, intrinsics);
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public String getMessage() {
        String message;
        String string = message = this.throwable == null ? null : ErrorServiceImpl.getStrippedExceptionMessage(this.throwable);
        if (message == null) {
            return UNKNOWN_REQUEST_URI;
        }
        return message;
    }

    @Override
    public String getExceptionClass() {
        return this.throwable == null ? null : this.throwable.getClass().getName();
    }

    @Override
    public Collection<String> stackTrace() {
        ArrayList<String> stackTrace = new ArrayList<String>();
        if (this.throwable instanceof MultiException) {
            List<Throwable> throwables = ((MultiException)((Object)this.throwable)).getThrowables();
            for (int i = 0; i < throwables.size(); ++i) {
                if (i > 0) {
                    stackTrace.add(" ");
                }
                stackTrace.addAll(StackTraces.stackTracesToStrings(throwables.get(i).getStackTrace()));
            }
        } else {
            Throwable t = this.throwable;
            boolean inner = false;
            while (t != null) {
                if (inner) {
                    stackTrace.add(" ");
                    stackTrace.add(" caused by " + t.toString());
                }
                stackTrace.addAll(StackTraces.stackTracesToStrings(t.getStackTrace()));
                t = t.equals(t.getCause()) ? null : t.getCause();
                inner = true;
            }
        }
        return stackTrace;
    }

    public String toString() {
        return this.getMessage();
    }

    public int hashCode() {
        return this.throwable.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThrowableError other = (ThrowableError)obj;
        return this.throwable.equals(other.throwable);
    }
}

