/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.errors;

import com.newrelic.agent.errors.TracedError;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;

public class HttpTracedError
extends TracedError {
    private static final String NO_REQUEST_URI = "";
    static int UNKNOWN_STATUS_CODE = -1;
    private final int responseStatus;
    private final String errorMessage;

    public HttpTracedError(String appName, String frontendMetricName, String requestUri, int responseStatus, String errorMessage, long timestamp, Map<String, Map<String, String>> prefixedParams, Map<String, Object> userParams, Map<String, Object> agentParams, Map<String, String> errorParams, Map<String, Object> intrinsics) {
        super(appName, frontendMetricName, timestamp, requestUri, prefixedParams, userParams, agentParams, errorParams, intrinsics);
        this.responseStatus = responseStatus;
        this.errorMessage = errorMessage == null && responseStatus != UNKNOWN_STATUS_CODE ? (responseStatus >= 400 && responseStatus < 500 ? "HttpClientError " + responseStatus : "HttpServerError " + responseStatus) : errorMessage;
    }

    public HttpTracedError(String appName, String frontendMetricName, String errorMessage, long timestamp, Map<String, Map<String, String>> prefixedParams, Map<String, Object> userParams, Map<String, Object> agentParams, Map<String, String> errorParams, Map<String, Object> intrinsics) {
        this(appName, frontendMetricName, NO_REQUEST_URI, UNKNOWN_STATUS_CODE, errorMessage, timestamp, prefixedParams, userParams, agentParams, errorParams, intrinsics);
    }

    @Override
    public Collection<String> stackTrace() {
        return null;
    }

    @Override
    public String getExceptionClass() {
        return this.getMessage();
    }

    @Override
    public String getMessage() {
        return this.errorMessage;
    }

    public int getStatusCode() {
        return this.responseStatus;
    }

    public String toString() {
        return MessageFormat.format("{0} ({1})", this.getMessage(), this.responseStatus);
    }
}

