/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.database;

import com.newrelic.agent.bridge.datastore.DatabaseVendor;
import com.newrelic.agent.bridge.datastore.UnknownDatabaseVendor;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import java.text.MessageFormat;

public final class ParsedDatabaseStatement
implements MetricNameFormat {
    private final String operation;
    private final String model;
    private final boolean generateMetric;
    private final String metricName;
    private final String operationRollupMetricName;
    private final DatabaseVendor dbVendor;

    public ParsedDatabaseStatement(String model, String operation, boolean generateMetric) {
        this(UnknownDatabaseVendor.INSTANCE, model, operation, generateMetric);
    }

    public ParsedDatabaseStatement(DatabaseVendor dbVendor, String model, String operation, boolean generateMetric) {
        this.model = model;
        this.operation = operation;
        this.generateMetric = generateMetric;
        this.dbVendor = dbVendor;
        this.operationRollupMetricName = MessageFormat.format("Datastore/operation/{0}/{1}", dbVendor.getDatastoreVendor(), operation);
        this.metricName = null == model || "".equals(model) ? this.operationRollupMetricName : MessageFormat.format("Datastore/statement/{0}/{1}/{2}", dbVendor.getDatastoreVendor(), model, operation);
    }

    public String getOperation() {
        return this.operation;
    }

    public String getModel() {
        return this.model;
    }

    public DatabaseVendor getDbVendor() {
        return this.dbVendor;
    }

    public boolean recordMetric() {
        return this.generateMetric;
    }

    @Override
    public String getMetricName() {
        return this.metricName;
    }

    public String toString() {
        return this.operation + ' ' + this.model;
    }

    @Override
    public String getTransactionSegmentName() {
        return this.getMetricName();
    }

    public String getOperationRollupMetricName() {
        return this.operationRollupMetricName;
    }

    @Override
    public String getTransactionSegmentUri() {
        return null;
    }
}

