/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.browser;

import com.newrelic.agent.Agent;
import com.newrelic.agent.ITransaction;
import com.newrelic.agent.attributes.AttributesUtils;
import com.newrelic.agent.browser.BrowserTransactionState;
import com.newrelic.agent.browser.IBrowserConfig;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.dispatchers.Dispatcher;
import com.newrelic.agent.service.ServiceFactory;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class BrowserTransactionStateImpl
implements BrowserTransactionState {
    private final Object lock = new Object();
    private final ITransaction tx;
    private boolean browserHeaderRendered;
    private boolean browserFooterRendered;

    protected BrowserTransactionStateImpl(ITransaction tx) {
        this.tx = tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBrowserTimingHeaderForJsp() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.canRenderHeaderForJsp()) {
                return "";
            }
            return this.getBrowserTimingHeader2();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBrowserTimingHeader() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.canRenderHeader()) {
                return "";
            }
            return this.getBrowserTimingHeader2();
        }
    }

    private String getBrowserTimingHeader2() {
        IBrowserConfig config = this.getBeaconConfig();
        if (config == null) {
            Agent.LOG.finer("Real user monitoring is disabled");
            return "";
        }
        String header = config.getBrowserTimingHeader();
        this.browserHeaderRendered = true;
        return header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBrowserTimingFooter() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.canRenderFooter()) {
                return "";
            }
            return this.getBrowserTimingFooter2();
        }
    }

    private String getBrowserTimingFooter2() {
        IBrowserConfig config = this.getBeaconConfig();
        if (config == null) {
            Agent.LOG.finer("Real user monitoring is disabled");
            return "";
        }
        this.tx.freezeTransactionName();
        if (this.tx.isIgnore()) {
            Agent.LOG.finer("Unable to get browser timing footer: transaction is ignore");
            return "";
        }
        String footer = config.getBrowserTimingFooter(this);
        if (!footer.isEmpty()) {
            this.browserFooterRendered = true;
        }
        return footer;
    }

    private boolean canRenderHeader() {
        if (!this.tx.isInProgress()) {
            Agent.LOG.finer("Unable to get browser timing header: transaction has no tracers");
            return false;
        }
        if (this.tx.isIgnore()) {
            Agent.LOG.finer("Unable to get browser timing header: transaction is ignore");
            return false;
        }
        if (this.browserHeaderRendered) {
            Agent.LOG.finer("browser timing header already rendered");
            return false;
        }
        return true;
    }

    private boolean canRenderHeaderForJsp() {
        if (!this.canRenderHeader()) {
            return false;
        }
        Dispatcher dispatcher = this.tx.getDispatcher();
        if (dispatcher == null || !dispatcher.isWebTransaction()) {
            Agent.LOG.finer("Unable to get browser timing header: transaction is not a web transaction");
            return false;
        }
        try {
            String contentType = dispatcher.getResponse().getContentType();
            if (!this.isHtml(contentType)) {
                String msg = MessageFormat.format("Unable to inject browser timing header in a JSP: bad content type: {0}", contentType);
                Agent.LOG.finer(msg);
                return false;
            }
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Unable to inject browser timing header in a JSP: exception getting content type: {0}", e);
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, e);
            } else if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.finer(msg);
            }
            return false;
        }
        return true;
    }

    private boolean isHtml(String contentType) {
        return contentType != null && (contentType.startsWith("text/html") || contentType.startsWith("text/xhtml"));
    }

    private boolean canRenderFooter() {
        if (!this.tx.isInProgress()) {
            Agent.LOG.finer("Unable to get browser timing footer: transaction has no tracers");
            return false;
        }
        if (this.tx.isIgnore()) {
            Agent.LOG.finer("Unable to get browser timing footer: transaction is ignore");
            return false;
        }
        if (this.browserFooterRendered && !this.tx.getAgentConfig().getBrowserMonitoringConfig().isAllowMultipleFooters()) {
            Agent.LOG.finer("browser timing footer already rendered");
            return false;
        }
        if (this.browserHeaderRendered) {
            return true;
        }
        IBrowserConfig config = this.getBeaconConfig();
        if (config == null) {
            Agent.LOG.finer("Real user monitoring is disabled");
            return false;
        }
        Agent.LOG.finer("getBrowserTimingFooter() was invoked without a call to getBrowserTimingHeader()");
        return false;
    }

    protected IBrowserConfig getBeaconConfig() {
        String appName = this.tx.getApplicationName();
        return ServiceFactory.getBeaconService().getBrowserConfig(appName);
    }

    @Override
    public long getDurationInMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.tx.getRunningDurationInNanos(), TimeUnit.NANOSECONDS);
    }

    @Override
    public long getExternalTimeInMilliseconds() {
        return this.tx.getExternalTime();
    }

    @Override
    public String getTransactionName() {
        return this.tx.getPriorityTransactionName().getName();
    }

    public static BrowserTransactionState create(ITransaction tx) {
        return tx == null ? null : new BrowserTransactionStateImpl(tx);
    }

    @Override
    public Map<String, Object> getUserAttributes() {
        return this.tx.getUserAttributes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getAgentAttributes() {
        Object object = this.lock;
        synchronized (object) {
            HashMap<String, Object> atts = Maps.newHashMap();
            atts.putAll(this.tx.getAgentAttributes());
            atts.putAll(AttributesUtils.appendAttributePrefixes(this.tx.getPrefixedAgentAttributes()));
            return atts;
        }
    }

    @Override
    public String getAppName() {
        return this.tx.getApplicationName();
    }
}

