/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.attributes.AttributesService;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.dispatchers.Dispatcher;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.sql.SlowQueryListener;
import com.newrelic.agent.stats.ApdexPerfZone;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.transaction.PriorityTransactionName;
import com.newrelic.agent.transaction.TransactionTimer;
import com.newrelic.api.agent.Insights;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class TransactionData {
    private final Transaction tx;
    private final int transactionSize;

    public TransactionData(Transaction transaction, int transactionSize) {
        this.tx = transaction;
        this.transactionSize = transactionSize;
    }

    public Transaction getTransaction() {
        return this.tx;
    }

    public Insights getInsightsData() {
        return this.tx.getInsightsData();
    }

    public Dispatcher getDispatcher() {
        return this.tx.getDispatcher();
    }

    public TransactionTimer getTransactionTime() {
        return this.tx.getTransactionTimer();
    }

    public Tracer getRootTracer() {
        return this.tx.getRootTracer();
    }

    public Collection<Tracer> getTracers() {
        return this.tx.getTracers();
    }

    public Set<TransactionActivity> getTransactionActivities() {
        return this.tx.getFinishedChildren();
    }

    public long getWallClockStartTimeMs() {
        return this.tx.getWallClockStartTimeMs();
    }

    public long getStartTimeInNanos() {
        return this.tx.getTransactionTimer().getStartTimeInNanos();
    }

    public long getEndTimeInNanos() {
        return this.tx.getTransactionTimer().getEndTimeInNanos();
    }

    public String getRequestUri(String destination) {
        AttributesService attributesService = ServiceFactory.getAttributesService();
        return attributesService.filterRequestUri(this.getApplicationName(), destination, this.getDispatcher().getUri());
    }

    public int getResponseStatus() {
        return this.tx.getStatus();
    }

    public String getStatusMessage() {
        return this.tx.getStatusMessage();
    }

    public String getApplicationName() {
        return this.tx.getRPMService().getApplicationName();
    }

    public AgentConfig getAgentConfig() {
        return this.tx.getAgentConfig();
    }

    public TransactionTracerConfig getTransactionTracerConfig() {
        return this.getAgentConfig() == null ? null : this.getAgentConfig().getTransactionTracerConfig();
    }

    public Map<String, Object> getInternalParameters() {
        return this.tx.getInternalParameters();
    }

    public Map<String, Map<String, String>> getPrefixedAttributes() {
        return this.tx.getPrefixedAgentAttributes();
    }

    public Map<String, Object> getUserAttributes() {
        return this.tx.getUserAttributes();
    }

    public Map<String, Object> getAgentAttributes() {
        return this.tx.getAgentAttributes();
    }

    public Map<String, String> getErrorAttributes() {
        return this.tx.getErrorAttributes();
    }

    public Map<String, Object> getIntrinsicAttributes() {
        return this.tx.getIntrinsicAttributes();
    }

    public PriorityTransactionName getPriorityTransactionName() {
        return this.tx.getPriorityTransactionName();
    }

    public String getBlameMetricName() {
        return this.getPriorityTransactionName().getName();
    }

    public String getBlameOrRootMetricName() {
        return this.getBlameMetricName() == null ? this.getRootTracer().getMetricName() : this.getBlameMetricName();
    }

    public Throwable getThrowable() {
        return this.tx.getReportError();
    }

    public boolean hasReportableErrorThatIsNotIgnored() {
        return this.tx.isErrorReportableAndNotIgnored();
    }

    protected final int getTransactionSize() {
        return this.transactionSize;
    }

    public long getDurationInMillis() {
        return this.tx.getTransactionTimer().getResponseTimeInMilliseconds();
    }

    public long getLegacyDuration() {
        return this.tx.getTransactionTimer().getResponseTimeInNanos();
    }

    public long getTransactionDuration() {
        return this.tx.getTransactionTimer().getTransactionDurationInNanos();
    }

    public long getTimeToFirstByteDurationNs() {
        return this.tx.getTransactionTimer().getTimeToFirstByteInNanos();
    }

    public long getTimeToLastByteDurationNs() {
        return this.tx.getTransactionTimer().getTimetoLastByteInNanos();
    }

    public String getGuid() {
        return this.tx.getGuid();
    }

    public String getReferrerGuid() {
        return this.tx.getInboundHeaderState().getReferrerGuid();
    }

    public String getTripId() {
        return this.tx.getCrossProcessTransactionState().getTripId();
    }

    public int generatePathHash() {
        return this.tx.getCrossProcessTransactionState().generatePathHash();
    }

    public Integer getReferringPathHash() {
        return this.tx.getInboundHeaderState().getReferringPathHash();
    }

    public String getAlternatePathHashes() {
        return this.tx.getCrossProcessTransactionState().getAlternatePathHashes();
    }

    public String getSyntheticsResourceId() {
        return this.tx.getInboundHeaderState().getSyntheticsResourceId();
    }

    public String getSyntheticsJobId() {
        return this.tx.getInboundHeaderState().getSyntheticsJobId();
    }

    public String getSyntheticsMonitorId() {
        return this.tx.getInboundHeaderState().getSyntheticsMonitorId();
    }

    public ApdexPerfZone getApdexPerfZone() {
        if (!this.isWebTransaction() && !this.tx.getAgentConfig().isApdexTSet(this.getPriorityTransactionName().getName())) {
            return null;
        }
        long responseTimeInMillis = this.tx.getTransactionTimer().getResponseTimeInMilliseconds() + this.tx.getExternalTime();
        long apdexTInMillis = this.tx.getAgentConfig().getApdexTInMillis(this.getPriorityTransactionName().getName());
        return ApdexPerfZone.getZone(responseTimeInMillis, apdexTInMillis);
    }

    public boolean isWebTransaction() {
        return this.getDispatcher().isWebTransaction();
    }

    public boolean isSyntheticTransaction() {
        return this.tx.isSynthetic();
    }

    public SlowQueryListener getSlowQueryListener() {
        return this.tx.getSlowQueryListener(false);
    }

    public String toString() {
        String name = this.getRequestUri("attributes") == null ? this.getRootTracer().getMetricName() : this.getRequestUri("attributes");
        StringBuilder builder = new StringBuilder(name == null ? "" : name).append(' ').append(this.getDurationInMillis()).append("ms");
        if (this.getThrowable() != null) {
            builder.append(' ').append(this.getThrowable().toString());
        }
        return builder.toString();
    }
}

