/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.CrossProcessTransactionState;
import com.newrelic.agent.CrossProcessTransactionStateImpl;
import com.newrelic.agent.DeobfuscatedInboundHeaders;
import com.newrelic.agent.DummyTransaction;
import com.newrelic.agent.IAgent;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.ITransaction;
import com.newrelic.agent.InboundHeaderState;
import com.newrelic.agent.LazyMapImpl;
import com.newrelic.agent.ThreadService;
import com.newrelic.agent.TimedSet;
import com.newrelic.agent.TimedTokenSet;
import com.newrelic.agent.TokenImpl;
import com.newrelic.agent.TracedActivity;
import com.newrelic.agent.TracerList;
import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.TransactionErrorPriority;
import com.newrelic.agent.TransactionState;
import com.newrelic.agent.TransactionStateImpl;
import com.newrelic.agent.application.AbstractApplicationNamingPolicy;
import com.newrelic.agent.application.HigherPriorityApplicationNamingPolicy;
import com.newrelic.agent.application.PriorityApplicationName;
import com.newrelic.agent.application.SameOrHigherPriorityApplicationNamingPolicy;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.bridge.CrossProcessState;
import com.newrelic.agent.bridge.ExitTracer;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.bridge.WebResponse;
import com.newrelic.agent.browser.BrowserTransactionState;
import com.newrelic.agent.browser.BrowserTransactionStateImpl;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.CrossProcessConfig;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.database.CachingDatabaseStatementParser;
import com.newrelic.agent.database.DatabaseStatementParser;
import com.newrelic.agent.deps.com.google.common.collect.MapMaker;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.dispatchers.Dispatcher;
import com.newrelic.agent.dispatchers.WebRequestDispatcher;
import com.newrelic.agent.errors.ErrorService;
import com.newrelic.agent.messaging.MessagingUtil;
import com.newrelic.agent.normalization.Normalizer;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.ServiceUtils;
import com.newrelic.agent.servlet.ServletUtils;
import com.newrelic.agent.sql.SlowQueryListener;
import com.newrelic.agent.stats.AbstractMetricAggregator;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.trace.TransactionGuidFactory;
import com.newrelic.agent.trace.TransactionTraceService;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.tracers.ClassMethodSignatures;
import com.newrelic.agent.tracers.OtherRootTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.tracers.TransactionActivityInitiator;
import com.newrelic.agent.tracers.metricname.MetricNameFormat;
import com.newrelic.agent.tracers.metricname.SimpleMetricNameFormat;
import com.newrelic.agent.transaction.PriorityTransactionName;
import com.newrelic.agent.transaction.TransactionCache;
import com.newrelic.agent.transaction.TransactionCounts;
import com.newrelic.agent.transaction.TransactionNamingPolicy;
import com.newrelic.agent.transaction.TransactionNamingScheme;
import com.newrelic.agent.transaction.TransactionNamingUtility;
import com.newrelic.agent.transaction.TransactionTimer;
import com.newrelic.agent.util.LazyAtomicReference;
import com.newrelic.agent.util.Strings;
import com.newrelic.api.agent.ApplicationNamePriority;
import com.newrelic.api.agent.HeaderType;
import com.newrelic.api.agent.InboundHeaders;
import com.newrelic.api.agent.Insights;
import com.newrelic.api.agent.MetricAggregator;
import com.newrelic.api.agent.NewRelic;
import com.newrelic.api.agent.Request;
import com.newrelic.api.agent.Response;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

public class Transaction
implements ITransaction {
    static final ClassMethodSignature REQUEST_INITIALIZED_CLASS_SIGNATURE = new ClassMethodSignature("javax.servlet.ServletRequestListener", "requestInitialized", "(Ljavax/servlet/ServletRequestEvent;)V");
    static final int REQUEST_INITIALIZED_CLASS_SIGNATURE_ID = ClassMethodSignatures.get().add(REQUEST_INITIALIZED_CLASS_SIGNATURE);
    private static final String THREAD_ASSERTION_FAILURE = "Thread assertion failed!";
    private static final ThreadLocal<Transaction> transactionHolder = new ThreadLocal<Transaction>(){

        @Override
        public void remove() {
            super.remove();
        }

        @Override
        public void set(Transaction value) {
            super.set(value);
        }
    };
    private static final long TRACED_ACTIVITY_TIMEOUT_MILLIS = (Integer)ServiceFactory.getConfigService().getDefaultAgentConfig().getValue("traced_activity_timeout", 600) * 1000;
    private static final int ASYNC_TIMEOUT_SECONDS = (Integer)ServiceFactory.getConfigService().getDefaultAgentConfig().getValue("async_timeout", 180);
    private static final long ASYNC_TIMEOUT_NANO = TimeUnit.NANOSECONDS.convert(ASYNC_TIMEOUT_SECONDS, TimeUnit.SECONDS);
    private final IAgent agent;
    private final String guid;
    private final boolean ttEnabled;
    private final TransactionCounts counts;
    private final boolean autoAppNamingEnabled;
    private final boolean transactionNamingEnabled;
    private final boolean ignoreErrorPriority;
    private final AtomicReference<TransactionErrorPriority> throwablePriority = new AtomicReference();
    private final Object lock = new Object();
    private final Set<TransactionActivity> finishedChildren = Sets.newConcurrentHashSet();
    private final AtomicInteger nextActivityId = new AtomicInteger(0);
    private final Map<String, Object> internalParameters;
    private final Map<String, Map<String, String>> prefixedAgentAttributes;
    private final Map<String, Object> agentAttributes;
    private final Map<String, Object> intrinsicAttributes;
    private final Map<String, Object> userAttributes;
    private final Map<String, String> errorAttributes;
    private final Insights insights;
    private final Map<Integer, TransactionActivity> runningChildren;
    private volatile long wallClockStartTimeMs;
    private volatile long startGCTimeInMillis;
    private volatile Throwable throwable;
    private volatile boolean ignore;
    private volatile boolean ignoreErrors = false;
    private volatile Dispatcher dispatcher;
    private volatile Tracer rootTracer;
    private volatile TransactionTimer transactionTime;
    private volatile TransactionState transactionState = new TransactionStateImpl();
    private volatile TransactionActivity initialActivity = null;
    private volatile PriorityTransactionName priorityTransactionName = PriorityTransactionName.NONE;
    private volatile TransactionStats txStats = null;
    private Callable<AppNameAndConfig> appNameAndConfigInitializer = new Callable<AppNameAndConfig>(){

        @Override
        public AppNameAndConfig call() throws Exception {
            return AppNameAndConfig.getDefault();
        }
    };
    private LazyAtomicReference<AppNameAndConfig> appNameAndConfig = new LazyAtomicReference<AppNameAndConfig>(this.appNameAndConfigInitializer);
    private CrossProcessTransactionState crossProcessTransactionState;
    private DatabaseStatementParser databaseStatementParser;
    private String normalizedUri;
    private SlowQueryListener slowQueryListener;
    private BrowserTransactionState browserTransactionState;
    private InboundHeaders providedHeaders;
    private InboundHeaderState inboundHeaderState;
    private final TimedSet<TokenImpl> activeTokensCache;
    private final AtomicInteger activeTokensCount;
    private final MetricAggregator metricAggregator = new AbstractMetricAggregator(){

        @Override
        protected void doRecordResponseTimeMetric(String name, long totalTime, long exclusiveTime, TimeUnit timeUnit) {
            Transaction.this.getTransactionActivity().getTransactionStats().getUnscopedStats().getResponseTimeStats(name).recordResponseTime(totalTime, exclusiveTime, timeUnit);
        }

        @Override
        protected void doRecordMetric(String name, float value) {
            Transaction.this.getTransactionActivity().getTransactionStats().getUnscopedStats().getStats(name).recordDataPoint(value);
        }

        @Override
        protected void doIncrementCounter(String name, int count) {
            Transaction.this.getTransactionActivity().getTransactionStats().getUnscopedStats().getStats(name).incrementCallCount(count);
        }
    };
    private static DummyTransaction dummyTransaction;
    protected static final WebResponse DEFAULT_RESPONSE;
    private static final Request DUMMY_REQUEST;
    private static final Response DUMMY_RESPONSE;
    private static final int REQUEST_TRACER_FLAGS = 14;
    private final Object requestStateChangeLock = new Object();
    private static final ClassMethodSignature TRACED_ACTIVITY_CLASS_METHOD_SIG;
    private static final Object TRACED_ACTIVITY_INVOKER;

    protected Transaction() {
        Agent.LOG.log(Level.FINE, "create Transaction {0}", new Object[]{this});
        if (Agent.LOG.isFinestEnabled() && Agent.isDebugEnabled()) {
            Agent.LOG.log(Level.FINEST, "backtrace: {0}", new Object[]{Arrays.toString(Thread.currentThread().getStackTrace())});
        }
        AgentConfig defaultConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.agent = ServiceFactory.getAgent();
        this.guid = TransactionGuidFactory.generateGuid();
        this.autoAppNamingEnabled = defaultConfig.isAutoAppNamingEnabled();
        this.transactionNamingEnabled = this.initializeTransactionNamingEnabled(defaultConfig);
        this.ignoreErrorPriority = (Boolean)defaultConfig.getValue("error_collector.ignoreErrorPriority", Boolean.TRUE);
        TransactionTraceService ttService = ServiceFactory.getTransactionTraceService();
        this.ttEnabled = ttService.isEnabled();
        this.counts = new TransactionCounts(defaultConfig);
        MapMaker factory = new MapMaker().initialCapacity(8).concurrencyLevel(4);
        this.internalParameters = new LazyMapImpl<String, Object>(factory);
        this.prefixedAgentAttributes = new LazyMapImpl<String, Map<String, String>>(factory);
        this.agentAttributes = new LazyMapImpl<String, Object>(factory);
        this.intrinsicAttributes = new LazyMapImpl<String, Object>(factory);
        this.userAttributes = new LazyMapImpl<String, Object>(factory);
        this.errorAttributes = new LazyMapImpl<String, String>(factory);
        this.insights = ServiceFactory.getServiceManager().getInsights().getTransactionInsights(defaultConfig);
        this.runningChildren = new LazyMapImpl<Integer, TransactionActivity>(factory);
        this.activeTokensCache = new TimedTokenSet(ASYNC_TIMEOUT_SECONDS, TimeUnit.SECONDS);
        this.activeTokensCount = new AtomicInteger(0);
    }

    private void postConstruct() {
        TransactionActivity txa;
        this.initialActivity = txa = TransactionActivity.create(this, this.nextActivityId.getAndIncrement());
    }

    private static long getGCTime() {
        long gcTime = 0L;
        for (GarbageCollectorMXBean gcBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            gcTime += gcBean.getCollectionTime();
        }
        return gcTime;
    }

    private boolean initializeTransactionNamingEnabled(AgentConfig config) {
        return config.isAutoTransactionNamingEnabled();
    }

    public MetricAggregator getMetricAggregator() {
        return this.metricAggregator;
    }

    public IAgent getAgent() {
        return this.agent;
    }

    public Object getLock() {
        return this.lock;
    }

    @Override
    public String getGuid() {
        return this.guid;
    }

    @Override
    public AgentConfig getAgentConfig() {
        return this.appNameAndConfig.get().getConfig();
    }

    public long getWallClockStartTimeMs() {
        this.captureWallClockStartTime();
        return this.wallClockStartTimeMs;
    }

    private void captureWallClockStartTime() {
        if (this.wallClockStartTimeMs == 0L) {
            this.wallClockStartTimeMs = System.currentTimeMillis();
        }
    }

    public Map<String, Object> getInternalParameters() {
        return this.internalParameters;
    }

    public boolean markFirstByteOfResponse(long endTimeNs) {
        return this.transactionTime.markTimeToFirstByte(endTimeNs);
    }

    public boolean markLastByteOfResponse(long endTimeNs) {
        return this.transactionTime.markTimeToLastByte(endTimeNs);
    }

    @Override
    public Map<String, Map<String, String>> getPrefixedAgentAttributes() {
        return this.prefixedAgentAttributes;
    }

    @Override
    public Map<String, Object> getUserAttributes() {
        return this.userAttributes;
    }

    @Override
    public Map<String, Object> getAgentAttributes() {
        return this.agentAttributes;
    }

    @Override
    public Map<String, Object> getIntrinsicAttributes() {
        return this.intrinsicAttributes;
    }

    public Map<String, String> getErrorAttributes() {
        return this.errorAttributes;
    }

    public Insights getInsightsData() {
        return this.insights;
    }

    public TransactionTracerConfig getTransactionTracerConfig() {
        if (this.dispatcher == null) {
            return this.getAgentConfig().getTransactionTracerConfig();
        }
        return this.dispatcher.getTransactionTracerConfig();
    }

    @Override
    public CrossProcessConfig getCrossProcessConfig() {
        return this.getAgentConfig().getCrossProcessConfig();
    }

    public boolean setTransactionName(com.newrelic.api.agent.TransactionNamePriority namePriority, boolean override, String category, String ... parts) {
        return this.setTransactionName(TransactionNamePriority.convert((com.newrelic.api.agent.TransactionNamePriority)namePriority), override, category, parts);
    }

    public boolean setTransactionName(TransactionNamePriority namePriority, boolean override, String category, String ... parts) {
        return this.doSetTransactionName(namePriority, override, category, parts);
    }

    @Deprecated
    public boolean isTransactionNameSet() {
        return TransactionNamingUtility.isGreaterThan(this.getPriorityTransactionName().getPriority(), TransactionNamePriority.NONE, this.getNamingScheme());
    }

    private boolean doSetTransactionName(TransactionNamePriority namePriority, boolean override, String category, String ... parts) {
        if (TransactionNamingUtility.isLessThan(namePriority, TransactionNamePriority.CUSTOM_HIGH, this.getNamingScheme()) && !this.isTransactionNamingEnabled()) {
            return false;
        }
        String name = Strings.join('/', parts);
        if (this.dispatcher == null) {
            if (Agent.LOG.isFinestEnabled()) {
                Agent.LOG.finest(MessageFormat.format("Unable to set the transaction name to \"{0}\" - no transaction", name));
            }
            return false;
        }
        TransactionNamingPolicy policy = override ? TransactionNamingPolicy.getSameOrHigherPriorityTransactionNamingPolicy() : TransactionNamingPolicy.getHigherPriorityTransactionNamingPolicy();
        return policy.setTransactionName(this, name, category, namePriority);
    }

    @Override
    public PriorityTransactionName getPriorityTransactionName() {
        return this.priorityTransactionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freezeTransactionName() {
        Object object = this.lock;
        synchronized (object) {
            if (this.priorityTransactionName.isFrozen()) {
                return;
            }
            if (this.dispatcher != null) {
                this.dispatcher.setTransactionName();
            }
            this.renameTransaction();
            this.priorityTransactionName = this.priorityTransactionName.freeze();
        }
    }

    private void renameTransaction() {
        if (Agent.LOG.isFinestEnabled()) {
            this.threadAssertion();
        }
        String appName = this.getApplicationName();
        Normalizer metricDataNormalizer = ServiceFactory.getNormalizationService().getMetricNormalizer(appName);
        String txName = metricDataNormalizer.normalize(this.priorityTransactionName.getName());
        Normalizer txNormalizer = ServiceFactory.getNormalizationService().getTransactionNormalizer(appName);
        txName = txNormalizer.normalize(txName);
        if (txName == null) {
            this.setIgnore(true);
            return;
        }
        if (!txName.equals(this.priorityTransactionName.getName())) {
            this.setPriorityTransactionNameLocked(PriorityTransactionName.create(txName, this.isWebTransaction() ? "Web" : "Other", TransactionNamePriority.REQUEST_URI));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean conditionalSetPriorityTransactionName(TransactionNamingPolicy policy, String name, String category, TransactionNamePriority priority) {
        Object object = this.lock;
        synchronized (object) {
            if (policy.canSetTransactionName(this, priority)) {
                if (Agent.LOG.isFinestEnabled()) {
                    Agent.LOG.log(Level.FINEST, "Setting transaction name to \"{0}\" for transaction {1} using {2} scheme", new Object[]{name, this, this.getNamingScheme()});
                } else {
                    Agent.LOG.log(Level.FINER, "Setting transaction name to \"{0}\" for transaction {1}", new Object[]{name, this});
                }
                return this.setPriorityTransactionNameLocked(policy.getPriorityTransactionName(this, name, category, priority));
            }
            if (Agent.LOG.isFinestEnabled()) {
                Agent.LOG.log(Level.FINEST, "Not setting the transaction name to  \"{0}\" for transaction {1} using {2} scheme: a higher priority name is already in place. Current transaction name is {3}", new Object[]{name, this, this.getNamingScheme(), this.getTransactionName()});
            } else {
                Agent.LOG.log(Level.FINER, "Not setting the transaction name to  \"{0}\" for transaction {1}: a higher priority name is already in place. Current transaction name is {2}", new Object[]{name, this, this.getTransactionName()});
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setPriorityTransactionName(PriorityTransactionName ptn) {
        Object object = this.lock;
        synchronized (object) {
            return this.setPriorityTransactionNameLocked(ptn);
        }
    }

    private boolean setPriorityTransactionNameLocked(PriorityTransactionName ptn) {
        if (Agent.LOG.isFinestEnabled()) {
            this.threadAssertion();
        }
        if (ptn == null) {
            return false;
        }
        this.priorityTransactionName = ptn;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SlowQueryListener getSlowQueryListener(boolean createIfNotExists) {
        Object object = this.lock;
        synchronized (object) {
            if (this.slowQueryListener == null && createIfNotExists) {
                String appName = this.getApplicationName();
                this.slowQueryListener = ServiceFactory.getSqlTraceService().getSlowQueryListener(appName);
            }
            return this.slowQueryListener;
        }
    }

    public TransactionCache getTransactionCache() {
        return this.getTransactionActivity().getTransactionCache();
    }

    @Override
    public boolean isStarted() {
        return this.getDispatcher() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFinished() {
        Object object = this.lock;
        synchronized (object) {
            return this.isStarted() && this.runningChildren.size() == 0 && this.activeTokensCount.get() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInProgress() {
        Object object = this.lock;
        synchronized (object) {
            return this.isStarted() && (this.runningChildren.size() != 0 || this.activeTokensCount.get() != 0);
        }
    }

    @Override
    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public long getExternalTime() {
        if (this.dispatcher instanceof WebRequestDispatcher) {
            return ((WebRequestDispatcher)this.dispatcher).getQueueTime();
        }
        return 0L;
    }

    @Override
    public Tracer getRootTracer() {
        return this.rootTracer;
    }

    public List<Tracer> getTracers() {
        return new TracerList(this.getRootTracer(), this.getFinishedChildren());
    }

    public TransactionStats getOverLimitTxStatsforTesting() {
        return this.txStats;
    }

    @Override
    public TransactionActivity getTransactionActivity() {
        if (this != Transaction.getTransaction(false)) {
            return this.initialActivity;
        }
        TransactionActivity result = TransactionActivity.get();
        if (result == null) {
            throw new IllegalStateException("TransactionActivity is gone");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activityStarted(TransactionActivity activity) {
        Agent.LOG.log(Level.FINER, "activity {0} starting", new Object[]{activity});
        this.startTransactionIfBeginning(activity.getRootTracer());
        Object object = this.lock;
        synchronized (object) {
            this.runningChildren.put(activity.hashCode(), activity);
        }
    }

    public void startTransactionIfBeginning(Tracer tracer) {
        if (tracer instanceof TransactionActivityInitiator && this.rootTracer == null) {
            AgentConfig defaultConfig;
            Agent.LOG.log(Level.FINER, "Starting transaction {0}", new Object[]{this});
            this.captureWallClockStartTime();
            this.startGCTimeInMillis = ServiceFactory.getTransactionTraceService().isEnabled() ? ((defaultConfig = ServiceFactory.getConfigService().getDefaultAgentConfig()).getTransactionTracerConfig().isGCTimeEnabled() ? Transaction.getGCTime() : -1L) : -1L;
            if (this.rootTracer == null) {
                this.rootTracer = tracer;
            }
            if (this.transactionTime == null) {
                this.transactionTime = new TransactionTimer(tracer.getStartTime());
                Agent.LOG.log(Level.FINER, "Set timer for transaction {0}", new Object[]{this});
            }
            if (this.dispatcher == null) {
                this.setDispatcher(((TransactionActivityInitiator)((Object)tracer)).createDispatcher());
            }
            ServiceFactory.getTransactionService().transactionStarted(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDispatcher(Dispatcher dispatcher) {
        Object object = this.lock;
        synchronized (object) {
            if (this.dispatcher instanceof WebRequestDispatcher) {
                Agent.LOG.log(Level.FINER, "Not setting dispatcher for transaction {0}. Dispatcher is already a web dispatcher.", new Object[]{this});
            } else {
                this.dispatcher = dispatcher;
                Agent.LOG.log(Level.FINER, "Set dispatcher for transaction {0} to {1}", new Object[]{this, dispatcher});
            }
        }
    }

    public TransactionTimer getTransactionTimer() {
        return this.transactionTime;
    }

    private void finishTransaction() {
        try {
            String instanceName;
            String displayHost;
            String tripId;
            String referrerGuid;
            int count;
            this.freezeTransactionName();
            if (this.ignore) {
                throw new CancellationException("transaction was ignored");
            }
            if (this.finishedChildren.isEmpty()) {
                throw new CancellationException("transaction had no activities");
            }
            TransactionStats transactionStats = this.transactionFinishedActivityMerging();
            this.transactionTime.markTransactionAsDone();
            this.recordFinalGCTime(transactionStats);
            this.handleTokenTimeout(transactionStats);
            String txName = this.priorityTransactionName.getName();
            this.dispatcher.transactionFinished(txName, transactionStats);
            if (Agent.LOG.isFinerEnabled()) {
                String requestURI = this.dispatcher == null ? "No Dispatcher Defined" : this.dispatcher.getUri();
                Agent.LOG.log(Level.FINER, "Transaction {2} finished {0}ms {1}", new Object[]{this.transactionTime.getResponseTimeInMilliseconds(), requestURI, this});
            }
            if (!ServiceFactory.getServiceManager().isStarted()) {
                return;
            }
            TransactionTracerConfig ttConfig = this.getTransactionTracerConfig();
            TransactionCounts rootCounts = this.getTransactionCounts();
            if (rootCounts.isOverTracerSegmentLimit()) {
                this.getIntrinsicAttributes().put("segment_clamp", rootCounts.getSegmentCount());
            }
            if (rootCounts.isOverTransactionSize()) {
                this.getIntrinsicAttributes().put("size_limit", "The transaction size limit was reached");
            }
            if ((count = rootCounts.getStackTraceCount()) >= ttConfig.getMaxStackTraces()) {
                this.getIntrinsicAttributes().put("stack_trace_clamp", count);
            }
            if ((count = rootCounts.getExplainPlanCount()) >= ttConfig.getMaxExplainPlans()) {
                this.getIntrinsicAttributes().put("explain_plan_clamp", count);
            }
            if (this.getInboundHeaderState().isTrustedCatRequest()) {
                String id = this.getInboundHeaderState().getClientCrossProcessId();
                this.getIntrinsicAttributes().put("client_cross_process_id", id);
            }
            if ((referrerGuid = this.getInboundHeaderState().getReferrerGuid()) != null) {
                this.getIntrinsicAttributes().put("referring_transaction_guid", referrerGuid);
            }
            if ((tripId = this.getCrossProcessTransactionState().getTripId()) != null) {
                this.getIntrinsicAttributes().put("trip_id", tripId);
                int pathHash = this.getCrossProcessTransactionState().generatePathHash();
                this.getIntrinsicAttributes().put("path_hash", ServiceUtils.intToHexString(pathHash));
            }
            if (this.isSynthetic()) {
                Agent.LOG.log(Level.FINEST, "Completing Synthetics transaction for monitor {0}", new Object[]{this.getInboundHeaderState().getSyntheticsMonitorId()});
                this.getIntrinsicAttributes().put("synthetics_resource_id", this.getInboundHeaderState().getSyntheticsResourceId());
                this.getIntrinsicAttributes().put("synthetics_monitor_id", this.getInboundHeaderState().getSyntheticsMonitorId());
                this.getIntrinsicAttributes().put("synthetics_job_id", this.getInboundHeaderState().getSyntheticsJobId());
            }
            if ((displayHost = (String)this.getAgentConfig().getValue("process_host.display_name", null)) != null) {
                this.getAgentAttributes().put("host.displayName", displayHost);
            }
            if ((instanceName = ServiceFactory.getEnvironmentService().getEnvironment().getAgentIdentity().getInstanceName()) != null) {
                this.getAgentAttributes().put("process.instanceName", instanceName);
            }
            if (this.finishedChildren.size() == 1) {
                this.getAgentAttributes().put("jvm.thread_name", Thread.currentThread().getName());
            }
            TransactionData transactionData = new TransactionData(this, rootCounts.getTransactionSize());
            ServiceFactory.getTransactionService().transactionFinished(transactionData, transactionStats);
        }
        catch (CancellationException cex) {
            Agent.LOG.log(Level.FINER, "Transaction {0} was cancelled: {1}. This is not an error condition.", new Object[]{this, cex.getMessage()});
            ServiceFactory.getTransactionService().transactionCancelled(this, cex);
        }
        catch (Throwable th) {
            Agent.LOG.log(Level.WARNING, th, "Transaction {0} was not reported because of an internal error.", new Object[]{this});
            ServiceFactory.getTransactionService().transactionCancelled(this, th);
        }
    }

    private TransactionStats transactionFinishedActivityMerging() {
        TransactionStats transactionStats = this.txStats;
        long totalCpuTime = 0L;
        boolean reportingCpu = true;
        Object val = this.getIntrinsicAttributes().remove("cpuTime");
        if (val != null && val instanceof Long && (totalCpuTime = ((Long)val).longValue()) < 0L) {
            reportingCpu = false;
        }
        for (TransactionActivity kid : this.getFinishedChildren()) {
            if (transactionStats == null) {
                transactionStats = kid.getTransactionStats();
            } else {
                TransactionStats stats = kid.getTransactionStats();
                transactionStats.getScopedStats().mergeStats(stats.getScopedStats());
                transactionStats.getUnscopedStats().mergeStats(stats.getUnscopedStats());
            }
            if (kid.getRootTracer() != null) {
                Map<String, Object> tracerAtts;
                Tracer rootTracer = kid.getRootTracer();
                this.transactionTime.markTransactionActivityAsDone(rootTracer.getEndTime(), rootTracer.getDuration());
                if (Agent.LOG.isFinestEnabled() && (tracerAtts = rootTracer.getAttributes()) != null && !tracerAtts.isEmpty()) {
                    Agent.LOG.log(Level.FINEST, "Tracer Attributes for {0} are {1}", new Object[]{rootTracer, tracerAtts});
                }
            }
            if (!reportingCpu) continue;
            if (kid.getTotalCpuTime() >= 0L) {
                totalCpuTime += kid.getTotalCpuTime();
                continue;
            }
            reportingCpu = false;
        }
        if (reportingCpu && totalCpuTime > 0L) {
            this.getIntrinsicAttributes().put("cpuTime", totalCpuTime);
        }
        return transactionStats;
    }

    public synchronized void addTotalCpuTimeForLegacy(long time) {
        Object val = this.getIntrinsicAttributes().remove("cpuTime");
        long totalCpuTime = val != null && val instanceof Long ? (Long)val : 0L;
        if (totalCpuTime != -1L) {
            totalCpuTime += time;
        }
        this.getIntrinsicAttributes().put("cpuTime", totalCpuTime);
    }

    public void recordFinalGCTime(TransactionStats stats) {
        long gcTime;
        Long totalGCTime;
        if (this.isTransactionTraceEnabled() && this.getRunningDurationInNanos() > this.getTransactionTracerConfig().getTransactionThresholdInNanos() && (totalGCTime = (Long)this.getIntrinsicAttributes().get("gc_time")) == null && this.startGCTimeInMillis > -1L && (gcTime = Transaction.getGCTime()) != this.startGCTimeInMillis) {
            totalGCTime = gcTime - this.startGCTimeInMillis;
            this.getIntrinsicAttributes().put("gc_time", totalGCTime);
            stats.getUnscopedStats().getResponseTimeStats("GC/cumulative").recordResponseTime(totalGCTime, TimeUnit.MILLISECONDS);
        }
    }

    private void handleTokenTimeout(TransactionStats stats) {
        int timedOutTokens = this.activeTokensCache.timedOutCount();
        if (timedOutTokens > 0) {
            stats.getUnscopedStats().getStats("Supportability/Async/Token/Timeout").incrementCallCount(timedOutTokens);
        }
    }

    void cleanUp() {
        this.checkExpireTracedActivities();
        this.activeTokensCache.cleanUp();
    }

    public boolean isTransactionTraceEnabled() {
        return this.ttEnabled;
    }

    public boolean isAutoAppNamingEnabled() {
        return this.autoAppNamingEnabled;
    }

    public boolean isTransactionNamingEnabled() {
        return this.transactionNamingEnabled;
    }

    public TransactionNamingScheme getNamingScheme() {
        String appName = this.getPriorityApplicationName().getName();
        AgentConfig appConfig = ServiceFactory.getConfigService().getAgentConfig(appName);
        return appConfig.getTransactionNamingScheme();
    }

    public boolean isWebTransaction() {
        return this.dispatcher != null && this.dispatcher.isWebTransaction();
    }

    public boolean isSynthetic() {
        return this.getInboundHeaderState().isTrustedSyntheticsRequest();
    }

    public void provideHeaders(InboundHeaders headers) {
        if (headers != null) {
            String encodingKey = this.getCrossProcessConfig().getEncodingKey();
            this.provideRawHeaders(new DeobfuscatedInboundHeaders(headers, encodingKey));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void provideRawHeaders(InboundHeaders headers) {
        if (headers != null) {
            Object object = this.lock;
            synchronized (object) {
                this.providedHeaders = headers;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InboundHeaderState getInboundHeaderState() {
        if (this.inboundHeaderState == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.inboundHeaderState == null) {
                    InboundHeaders requestHeaders = Transaction.getRequestHeaders(this);
                    if (requestHeaders == null) {
                        requestHeaders = this.providedHeaders == null ? null : this.providedHeaders;
                    }
                    try {
                        this.inboundHeaderState = new InboundHeaderState(this, requestHeaders);
                    }
                    catch (RuntimeException rex) {
                        Agent.LOG.log(Level.FINEST, "Unable to parse inbound headers", rex);
                        this.inboundHeaderState = new InboundHeaderState(this, null);
                    }
                }
            }
        }
        return this.inboundHeaderState;
    }

    static InboundHeaders getRequestHeaders(Transaction tx) {
        if (tx.dispatcher != null && tx.dispatcher.getRequest() != null) {
            return new DeobfuscatedInboundHeaders((InboundHeaders)tx.dispatcher.getRequest(), tx.getCrossProcessConfig().getEncodingKey());
        }
        return null;
    }

    public IRPMService getRPMService() {
        return ServiceFactory.getRPMServiceManager().getOrCreateRPMService(this.getPriorityApplicationName());
    }

    public static void clearTransaction() {
        Transaction tx = transactionHolder.get();
        transactionHolder.remove();
        TransactionActivity.clear();
    }

    public static void setTransaction(Transaction tx) {
        TransactionActivity.set(tx.initialActivity);
        transactionHolder.set(tx);
    }

    public static Transaction getTransaction() {
        return Transaction.getTransaction(true);
    }

    public void refreshToken(TokenImpl token) {
        this.activeTokensCache.refresh(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean linkTxOnThread(TokenImpl token) {
        Transaction newTx = token.getTransaction();
        if (newTx != null) {
            newTx.refreshToken(token);
        }
        Transaction oldTx = transactionHolder.get();
        if (newTx == null || newTx == oldTx) {
            Agent.LOG.log(Level.FINER, "Transaction {0}: ignoring link call because transaction already on thread.", new Object[]{newTx});
            return false;
        }
        Object object = newTx.lock;
        synchronized (object) {
            if (!newTx.isInProgress()) {
                Agent.LOG.log(Level.FINER, "Transaction {0}: ignoring link call because transaction not in progress.", new Object[]{newTx});
                return false;
            }
            if (!token.isActive()) {
                Agent.LOG.log(Level.FINER, "Transaction {0}: ignoring link call because token is no longer active {1}.", new Object[]{newTx, token});
                return false;
            }
            TransactionActivity oldTxa = TransactionActivity.get();
            if (oldTxa == null || !oldTxa.isStarted()) {
                Agent.LOG.log(Level.FINER, "Transaction {0}: ignoring link call because there is no started txa to link to: {1}.", new Object[]{newTx, oldTxa});
                return false;
            }
            Tracer tracer = token.getInitiatingTracer();
            if (tracer == null || !token.isActive()) {
                return false;
            }
            int oldTxaId = oldTxa.hashCode();
            oldTxa.startAsyncActivity(newTx, newTx.nextActivityId.getAndIncrement(), tracer);
            if (oldTx != null) {
                PriorityTransactionName ptn;
                PriorityApplicationName pan = oldTx.getPriorityApplicationName();
                if (pan != PriorityApplicationName.NONE) {
                    newTx.setApplicationName(pan.getPriority(), pan.getName(), true);
                }
                if ((ptn = oldTx.getPriorityTransactionName()) != PriorityTransactionName.NONE) {
                    newTx.setTransactionName(ptn.getPriority(), true, ptn.getCategory(), oldTx.getTransactionName());
                }
                newTx.getInternalParameters().putAll(oldTx.getInternalParameters());
                newTx.getPrefixedAgentAttributes().putAll(oldTx.getPrefixedAgentAttributes());
                newTx.getAgentAttributes().putAll(oldTx.getAgentAttributes());
                newTx.getIntrinsicAttributes().putAll(oldTx.getIntrinsicAttributes());
                newTx.getUserAttributes().putAll(oldTx.getUserAttributes());
                newTx.getErrorAttributes().putAll(oldTx.getErrorAttributes());
                oldTx.ignore = true;
                oldTx.checkExpire();
                oldTx.checkFinishTransaction(oldTxa, oldTxaId);
                transactionHolder.set(null);
            }
            transactionHolder.set(newTx);
            return true;
        }
    }

    public static Transaction getTransaction(boolean createIfNotExists) {
        Transaction tx = transactionHolder.get();
        if (tx == null && createIfNotExists && !(Thread.currentThread() instanceof ThreadService.AgentThread)) {
            if (ServiceFactory.getServiceManager().getCircuitBreakerService().isTripped()) {
                return Transaction.getOrCreateDummyTransaction();
            }
            try {
                tx = new Transaction();
                tx.postConstruct();
                transactionHolder.set(tx);
            }
            catch (RuntimeException rex) {
                Agent.LOG.log(Level.FINEST, rex, "while creating Transaction", new Object[0]);
                TransactionActivity.clear();
                throw rex;
            }
        }
        return tx;
    }

    protected static synchronized Transaction getOrCreateDummyTransaction() {
        if (dummyTransaction == null) {
            dummyTransaction = new DummyTransaction();
        }
        return dummyTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setNormalizedUri(String normalizedUri) {
        Object object = this.lock;
        synchronized (object) {
            if (normalizedUri == null || normalizedUri.length() == 0) {
                return;
            }
            TransactionNamingPolicy policy = TransactionNamingPolicy.getSameOrHigherPriorityTransactionNamingPolicy();
            if (Agent.LOG.isLoggable(Level.FINER) && policy.canSetTransactionName(this, TransactionNamePriority.CUSTOM_HIGH)) {
                String msg = MessageFormat.format("Setting transaction name to normalized URI \"{0}\" for transaction {1}", normalizedUri, this);
                Agent.LOG.finer(msg);
            }
            policy.setTransactionName(this, normalizedUri, "NormalizedUri", TransactionNamePriority.CUSTOM_HIGH);
            this.normalizedUri = normalizedUri;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String getNormalizedUri() {
        Object object = this.lock;
        synchronized (object) {
            return this.normalizedUri;
        }
    }

    public Throwable getReportError() {
        return ServletUtils.getReportError(this.throwable);
    }

    public boolean isErrorReportableAndNotIgnored() {
        int responseStatus = this.getStatus();
        boolean isReportable = responseStatus >= 400 || this.throwable != null;
        ErrorService errorService = ServiceFactory.getRPMService(this.getApplicationName()).getErrorService();
        return isReportable && !this.ignoreErrors && !errorService.isIgnoredError(responseStatus, this.throwable);
    }

    public int getStatus() {
        return this.getWebResponse().getStatus();
    }

    public String getStatusMessage() {
        return this.getWebResponse().getStatusMessage();
    }

    public void freezeStatus() {
        this.getWebResponse().freezeStatus();
    }

    public void setThrowable(Throwable throwable, TransactionErrorPriority priority) {
        if (throwable == null) {
            return;
        }
        if (TransactionActivity.get() != this.initialActivity && priority != TransactionErrorPriority.API) {
            if (Agent.LOG.isFinerEnabled()) {
                Agent.LOG.log(Level.FINER, "Non-API call to setThrowable from asynchronous activity ignored: {0} with priority {1}", new Object[]{throwable, priority});
            }
            return;
        }
        if (Agent.LOG.isFinerEnabled() && !this.ignoreErrorPriority) {
            Agent.LOG.log(Level.FINER, "Attempting to set throwable in transaction: {0} having priority {1} with priority {2}", new Object[]{throwable.getClass().getName(), this.throwablePriority, priority});
        }
        if (this.ignoreErrorPriority || priority.updateCurrentPriority(this.throwablePriority)) {
            Agent.LOG.log(Level.FINER, "Set throwable {0} in transaction {1}", new Object[]{throwable.getClass().getName(), this});
            this.throwable = throwable;
        }
    }

    @Override
    public boolean isIgnore() {
        return this.ignore;
    }

    public void ignore() {
        this.setIgnore(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIgnore(boolean ignore) {
        if (this.dispatcher != null) {
            Object object = this.lock;
            synchronized (object) {
                this.ignore = ignore;
                for (TransactionActivity child : this.runningChildren.values()) {
                    child.setOwningTransactionIsIgnored(true);
                }
                for (TransactionActivity finishedChild : this.finishedChildren) {
                    finishedChild.setOwningTransactionIsIgnored(true);
                }
            }
        } else {
            Agent.LOG.log(Level.FINEST, "setIgnore called outside of an open transaction");
        }
    }

    public void ignoreApdex() {
        if (this.isStarted()) {
            this.dispatcher.setIgnoreApdex(true);
        } else {
            Agent.LOG.finer("ignoreApdex invoked with no transaction");
        }
    }

    public void ignoreErrors() {
        if (this.isStarted()) {
            this.ignoreErrors = true;
        } else {
            Agent.LOG.finer("ignoreErrors invoked with no transaction");
        }
    }

    public TransactionCounts getTransactionCounts() {
        return this.counts;
    }

    public boolean shouldGenerateTransactionSegment() {
        return this.ttEnabled && this.getTransactionCounts().shouldGenerateTransactionSegment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseStatementParser getDatabaseStatementParser() {
        Object object = this.lock;
        synchronized (object) {
            if (this.databaseStatementParser == null) {
                this.databaseStatementParser = this.createDatabaseStatementParser();
            }
            return this.databaseStatementParser;
        }
    }

    private DatabaseStatementParser createDatabaseStatementParser() {
        return new CachingDatabaseStatementParser(ServiceFactory.getDatabaseService().getDatabaseStatementParser());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BrowserTransactionState getBrowserTransactionState() {
        Object object = this.lock;
        synchronized (object) {
            if (this.browserTransactionState == null) {
                this.browserTransactionState = BrowserTransactionStateImpl.create(this);
            }
            return this.browserTransactionState;
        }
    }

    public CrossProcessState getCrossProcessState() {
        return this.getCrossProcessTransactionState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CrossProcessTransactionState getCrossProcessTransactionState() {
        if (this.crossProcessTransactionState == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.crossProcessTransactionState == null) {
                    this.crossProcessTransactionState = CrossProcessTransactionStateImpl.create(this);
                }
            }
        }
        return this.crossProcessTransactionState;
    }

    public TransactionState getTransactionState() {
        return this.transactionState;
    }

    public void setTransactionState(TransactionState transactionState) {
        Agent.disableFastPath();
        this.transactionState = transactionState;
    }

    public void addOutboundResponseHeaders() {
        this.getCrossProcessTransactionState().writeResponseHeaders();
    }

    public WebResponse getWebResponse() {
        if (this.dispatcher instanceof WebResponse) {
            return (WebResponse)this.dispatcher;
        }
        return DEFAULT_RESPONSE;
    }

    public void convertToWebTransaction() {
        if (!this.isWebTransaction()) {
            this.setDispatcher(new WebRequestDispatcher(DUMMY_REQUEST, DUMMY_RESPONSE, this));
        }
    }

    public void setRequestAndResponse(Request request, Response response) {
        Request req = request == null ? DUMMY_REQUEST : request;
        Response res = response == null ? DUMMY_RESPONSE : response;
        this.setDispatcher(new WebRequestDispatcher(req, res, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestInitialized(Request request, Response response) {
        Agent.LOG.log(Level.FINEST, "Request initialized: {0}", new Object[]{request.getRequestURI()});
        Object object = this.requestStateChangeLock;
        synchronized (object) {
            if (this.isFinished()) {
                return;
            }
            if (this.dispatcher == null) {
                ExitTracer tracer = AgentBridge.instrumentation.createTracer(null, REQUEST_INITIALIZED_CLASS_SIGNATURE_ID, null, 14);
                if (tracer != null) {
                    if (response == null) {
                        response = DUMMY_RESPONSE;
                    }
                    this.setDispatcher(new WebRequestDispatcher(request, response, this));
                }
            } else {
                Agent.LOG.finer("requestInitialized(): transaction already started.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestDestroyed() {
        Agent.LOG.log(Level.FINEST, "Request destroyed");
        Object object = this.requestStateChangeLock;
        synchronized (object) {
            if (!this.isInProgress()) {
                return;
            }
            Tracer rootTracer = this.getTransactionActivity().getRootTracer();
            Tracer lastTracer = this.getTransactionActivity().getLastTracer();
            if (lastTracer != null && rootTracer == lastTracer) {
                Transaction currentTxn = Transaction.getTransaction(false);
                if (currentTxn != null) {
                    currentTxn.addOutboundResponseHeaders();
                    lastTracer.finish(177, null);
                }
            } else {
                Agent.LOG.log(Level.FINER, "Inconsistent state!  tracer != last tracer for {0} ({1} != {2})", new Object[]{this, rootTracer, lastTracer});
            }
        }
    }

    public boolean isWebRequestSet() {
        if (this.dispatcher instanceof WebRequestDispatcher) {
            return !DUMMY_REQUEST.equals(this.dispatcher.getRequest());
        }
        return false;
    }

    public boolean isWebResponseSet() {
        if (this.dispatcher instanceof WebRequestDispatcher) {
            return !DUMMY_RESPONSE.equals(this.dispatcher.getResponse());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWebRequest(Request req) {
        Request request = req == null ? DUMMY_REQUEST : req;
        Object object = this.lock;
        synchronized (object) {
            if (this.dispatcher instanceof WebRequestDispatcher) {
                if (DUMMY_REQUEST.equals(this.dispatcher.getRequest())) {
                    this.dispatcher.setRequest(request);
                    Agent.LOG.log(Level.FINEST, "Set web request for transaction {0} to {1}", new Object[]{this, request});
                } else {
                    Agent.LOG.log(Level.FINEST, "Not setting web request for transaction {0}. Web request is already set.", new Object[]{this});
                }
            } else {
                Agent.LOG.log(Level.FINEST, "Set web request for transaction {0}", new Object[]{this});
                this.setDispatcher(new WebRequestDispatcher(request, DUMMY_RESPONSE, this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWebResponse(Response resp) {
        Response response = resp == null ? DUMMY_RESPONSE : resp;
        Object object = this.lock;
        synchronized (object) {
            if (this.dispatcher instanceof WebRequestDispatcher) {
                if (DUMMY_RESPONSE.equals(this.dispatcher.getResponse())) {
                    this.dispatcher.setResponse(response);
                    Agent.LOG.log(Level.FINEST, "Set web response for transaction {0} to {1}", new Object[]{this, response});
                } else {
                    Agent.LOG.log(Level.FINEST, "Not setting web response for transaction {0}. Web response is already set.", new Object[]{this});
                }
            } else {
                Agent.LOG.log(Level.FINEST, "Set web response for transaction {0}. Transaction does not have a corresponding request", new Object[]{this});
                this.setDispatcher(new WebRequestDispatcher(DUMMY_REQUEST, response, this));
            }
        }
    }

    public static boolean isDummyRequest(Request request) {
        return request == DUMMY_REQUEST;
    }

    @Override
    public String getApplicationName() {
        return this.getPriorityApplicationName().getName();
    }

    public PriorityApplicationName getPriorityApplicationName() {
        return this.appNameAndConfig.get().getName();
    }

    public void setApplicationName(ApplicationNamePriority priority, String appName) {
        this.setApplicationName(priority, appName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setApplicationName(ApplicationNamePriority priority, String appName, boolean override) {
        if (appName == null || appName.length() == 0) {
            return;
        }
        AbstractApplicationNamingPolicy policy = override ? SameOrHigherPriorityApplicationNamingPolicy.getInstance() : HigherPriorityApplicationNamingPolicy.getInstance();
        Object object = this.lock;
        synchronized (object) {
            if (policy.canSetApplicationName(this, priority)) {
                String name = Transaction.stripLeadingForwardSlash(appName);
                PriorityApplicationName pan = PriorityApplicationName.create(name, priority);
                if (pan == null || pan.equals(this.getPriorityApplicationName())) {
                    return;
                }
                Agent.LOG.log(Level.FINE, "Set application name to {0}", new Object[]{pan.getName()});
                this.appNameAndConfig.set(new AppNameAndConfig(pan));
            }
        }
    }

    private static String stripLeadingForwardSlash(String appName) {
        String FORWARD_SLASH = "/";
        if (appName.length() > 1 && appName.startsWith("/")) {
            return appName.substring(1, appName.length());
        }
        return appName;
    }

    @Override
    public long getRunningDurationInNanos() {
        if (this.dispatcher == null) {
            return 0L;
        }
        return this.transactionTime.getRunningDurationInNanos();
    }

    public void saveMessageParameters(Map<String, String> parameters) {
        MessagingUtil.recordParameters(this, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenImpl getToken() {
        if (ServiceFactory.getServiceManager().getCircuitBreakerService().isTripped() || this.isIgnore() || !this.isStarted()) {
            return null;
        }
        Tracer parent = this.getTransactionActivity().getLastTracer();
        if (parent == null || parent.isLeaf()) {
            Agent.LOG.log(Level.FINER, "Transaction {0}: can not create token, no last tracer on {1}", new Object[]{this, this.getTransactionActivity()});
            return null;
        }
        TokenImpl token = null;
        boolean wasAdded = false;
        Object object = this.lock;
        synchronized (object) {
            if (!this.isFinished()) {
                token = new TokenImpl(parent);
                this.activeTokensCount.incrementAndGet();
                this.activeTokensCache.put(token);
                wasAdded = true;
            }
        }
        if (wasAdded) {
            Agent.LOG.log(Level.FINER, "Transaction {0}: created active token {1}", new Object[]{this, token});
        } else {
            Agent.LOG.log(Level.FINER, "Transaction {0}: already finished. Can not create token", new Object[]{this});
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean expireToken(TokenImpl token) {
        boolean tokenWasActive = false;
        Transaction tx = token.getTransaction();
        if (tx != null) {
            Object object = tx.lock;
            synchronized (object) {
                if (!tx.isFinished()) {
                    tokenWasActive = tx.activeTokensCache.remove(token);
                    Agent.LOG.log(Level.FINER, "Transaction {0}: expired token {1}", new Object[]{tx, token});
                } else {
                    Agent.LOG.log(Level.FINER, "Transaction {0}: token {1} is not active and so can not be expired", new Object[]{tx, token});
                }
            }
        }
        return tokenWasActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireAllTokensForCurrentTransaction() {
        Object object = this.lock;
        synchronized (object) {
            int count = this.activeTokensCount.get();
            if (!this.isFinished() && count > 0) {
                Agent.LOG.log(Level.FINER, "Transaction {0}: forcibly expiring all {1} active tokens", new Object[]{this, count});
                this.activeTokensCache.removeAll();
            }
        }
    }

    public void onRemoval() {
        this.activeTokensCount.decrementAndGet();
        this.checkFinishTransactionWithoutTxa();
    }

    public void checkExpire() {
        this.checkExpireTracedActivities();
        this.checkExpireTokens();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkExpireTokens() {
        Object object = this.lock;
        synchronized (object) {
            int count;
            if (!this.isFinished() && this.runningChildren.size() == 0 && (count = this.activeTokensCount.get()) > 0) {
                long time = this.transactionTime.getTimeLastTxaFinished() + ASYNC_TIMEOUT_NANO;
                if (System.nanoTime() >= time) {
                    Agent.LOG.log(Level.FINE, "Transaction {0}: forcibly expiring {1} token(s) due to time out.", new Object[]{this, count});
                    this.expireAllTokensForCurrentTransaction();
                }
            }
        }
    }

    public TracedActivity createAndStartTracedActivity(int tracerFlags, String tracedActivityName) {
        if (ServiceFactory.getServiceManager().getCircuitBreakerService().isTripped() || this.isIgnore()) {
            return null;
        }
        Tracer parent = this.getTransactionActivity().getLastTracer();
        if (parent == null || parent.isLeaf()) {
            Agent.LOG.log(Level.FINER, "Transaction {0}: can not create event, no last tracer on {1}", new Object[]{this, this.getTransactionActivity()});
            return null;
        }
        TransactionActivity eventTxa = TransactionActivity.createWithoutHolder(this, this.nextActivityId.getAndIncrement(), tracedActivityName);
        SimpleMetricNameFormat tracedActivityMnf = new SimpleMetricNameFormat(tracedActivityName);
        OtherRootTracer eventTracer = new OtherRootTracer(eventTxa, TRACED_ACTIVITY_CLASS_METHOD_SIG, TRACED_ACTIVITY_INVOKER, (MetricNameFormat)tracedActivityMnf);
        TracedActivity tracedActivity = new TracedActivity(parent, eventTracer);
        eventTxa.setTracedActivity(tracedActivity);
        eventTracer.setParentTracer(parent);
        eventTxa.tracerStarted(eventTracer);
        Agent.LOG.log(Level.FINEST, "Transaction {0}: createAndStartEvent(): {1} created and started with tracer {2}", new Object[]{this, tracedActivity, eventTracer});
        return tracedActivity;
    }

    public void ignoreTracedActivityIfUnfinished(TracedActivity event) {
        Tracer activityTracer = event.getTracer();
        if (activityTracer.getTransactionActivity().isFinished()) {
            Agent.LOG.log(Level.FINEST, "Transaction {0}: event {1} already finished. Not ignoring it.");
        } else {
            activityTracer.getTransactionActivity().setToIgnore();
            activityTracer.finish(176, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishTracedActivity(TracedActivity tracedActivity, Throwable throwable) {
        Tracer parent = tracedActivity.getParent();
        Tracer tracer = tracedActivity.getTracer();
        Tracer finishPoint = null;
        if (null != TransactionActivity.get()) {
            finishPoint = TransactionActivity.get().getLastTracer();
        }
        if (parent == finishPoint && tracedActivity.getParentInitialExclusiveDuration() == finishPoint.getExclusiveDuration()) {
            Agent.LOG.log(Level.FINEST, "{0}--finishTracedActivity(): {1} sync finish with tracer {2}", new Object[]{this, tracedActivity, tracer});
            Object object = this.lock;
            synchronized (object) {
                this.runningChildren.remove(tracer.getTransactionActivity().hashCode());
            }
            tracer.removeAttribute("async_context");
            TransactionActivity syncTxa = parent.getTransactionActivity();
            syncTxa.tracerStarted(tracer);
            tracer.setTransactionActivity(syncTxa);
            if (null == throwable) {
                tracer.finish(176, null);
            } else {
                tracer.finish(throwable);
            }
        } else {
            this.finishedChildren.add(tracer.getTransactionActivity());
            if (null == throwable) {
                tracer.finish(176, null);
            } else {
                tracer.finish(throwable);
            }
            tracer.getTransactionActivity().setTotalCpuTime(0L);
            Agent.LOG.log(Level.FINEST, "{0}--finishTracedActivity(): {1} async finish with tracer {2}", new Object[]{this, tracedActivity, tracer});
        }
    }

    public int getRunningTransactionActivityCount() {
        return this.runningChildren.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activityFailedOrIgnored(TransactionActivity activity, int opcode) {
        String occurred = activity.isIgnored() ? "IGNORED" : "FAILED";
        Agent.LOG.log(Level.FINER, "Transaction {0}: activity {1} {2} with opcode {3}", new Object[]{this, activity, occurred, opcode});
        Object object = this.lock;
        synchronized (object) {
            try {
                if (!this.isFinished()) {
                    this.finishedChildren.remove(activity);
                    this.checkFinishTransaction(activity);
                }
            }
            finally {
                if (!activity.isNotInThreadLocal()) {
                    transactionHolder.remove();
                }
            }
        }
    }

    private void checkFinishTransactionWithoutTxa() {
        this.checkFinishTransaction(null, null);
    }

    private void checkFinishTransaction(TransactionActivity txa) {
        this.checkFinishTransaction(txa, txa.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFinishTransaction(TransactionActivity txa, Integer runningChildrenKey) {
        if (this.isStarted()) {
            Object object = this.lock;
            synchronized (object) {
                if (Agent.LOG.isFinestEnabled()) {
                    this.threadAssertion();
                }
                if (txa != null) {
                    if (runningChildrenKey != null) {
                        this.runningChildren.remove(runningChildrenKey);
                    }
                    this.transactionTime.markTxaFinishTime(txa.getRootTracer());
                }
                if (this.runningChildren.size() == 0 && this.activeTokensCount.get() == 0) {
                    this.finishTransaction();
                }
            }
        }
    }

    private final void threadAssertion() {
        if (Agent.LOG.isFinestEnabled() && !Thread.holdsLock(this.lock)) {
            Agent.LOG.log(Level.FINEST, THREAD_ASSERTION_FAILURE, new Exception(THREAD_ASSERTION_FAILURE).fillInStackTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkExpireTracedActivities() {
        Object object = this.lock;
        synchronized (object) {
            long currentMillis = TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
            for (TransactionActivity txa : this.runningChildren.values()) {
                long duration;
                TracedActivity tracedActivity = txa.getTracedActivity();
                if (tracedActivity == null || (duration = currentMillis - tracedActivity.getTracer().getStartTimeInMilliseconds()) <= TRACED_ACTIVITY_TIMEOUT_MILLIS) continue;
                this.reportTracedActivityTimeout(txa);
                this.ignoreTracedActivityIfUnfinished(tracedActivity);
            }
        }
    }

    private void reportTracedActivityTimeout(TransactionActivity txa) {
        String message = "Traced activity timed out after %d seconds. The \"traced_activity_timeout\" configuration parameter can be used to adjust this timeout. The affected transaction name is %s.%n";
        String name = "unknown";
        if (txa.getTransaction() != null && txa.getTransaction().getTransactionName() != null) {
            name = "\"" + txa.getTransaction().getTransactionName() + "\"";
        }
        Agent.LOG.log(Level.INFO, String.format("Traced activity timed out after %d seconds. The \"traced_activity_timeout\" configuration parameter can be used to adjust this timeout. The affected transaction name is %s.%n", TRACED_ACTIVITY_TIMEOUT_MILLIS / 1000L, name));
        Agent.LOG.log(Level.FINE, "TracedActivity {0}-{1} timed out on tx {2}", new Object[]{txa.getTracedActivity(), txa, txa.getTransaction()});
        NewRelic.incrementCounter((String)"Supportability/Timeout/finishTracedActivityNotCalled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activityFinished(TransactionActivity activity, Tracer tracer, int opcode) {
        Agent.LOG.log(Level.FINER, "Transaction {0}: Activity {1} finished with opcode {2}", new Object[]{this, activity, opcode});
        Object object = this.lock;
        synchronized (object) {
            try {
                if (!this.isFinished()) {
                    if (!tracer.isTransactionSegment()) {
                        if (this.txStats == null) {
                            this.txStats = activity.getTransactionStats();
                        } else {
                            TransactionStats toMergeStats = activity.getTransactionStats();
                            this.txStats.getScopedStats().mergeStats(toMergeStats.getScopedStats());
                            this.txStats.getUnscopedStats().mergeStats(toMergeStats.getUnscopedStats());
                        }
                    } else {
                        this.finishedChildren.add(activity);
                    }
                    this.checkFinishTransaction(activity);
                }
            }
            finally {
                if (!activity.isNotInThreadLocal()) {
                    transactionHolder.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TransactionActivity> getFinishedChildren() {
        Object object = this.lock;
        synchronized (object) {
            return new HashSet<TransactionActivity>(this.finishedChildren);
        }
    }

    private String getTransactionName() {
        String fullName = this.getPriorityTransactionName().getName();
        String category = this.getPriorityTransactionName().getCategory();
        String prefix = this.getPriorityTransactionName().getPrefix();
        String txnNamePrefix = prefix + '/' + category + '/';
        if (fullName != null && fullName.startsWith(txnNamePrefix)) {
            return fullName.substring(txnNamePrefix.length(), fullName.length());
        }
        return fullName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCountOfRunningAndFinishedTransactionActivities() {
        Object object = this.lock;
        synchronized (object) {
            return this.runningChildren.size() + this.finishedChildren.size();
        }
    }

    static {
        DEFAULT_RESPONSE = new WebResponse(){

            public void setStatusMessage(String message) {
            }

            public void setStatus(int statusCode) {
            }

            public int getStatus() {
                return 0;
            }

            public String getStatusMessage() {
                return null;
            }

            public void freezeStatus() {
            }
        };
        DUMMY_REQUEST = new Request(){

            public String[] getParameterValues(String name) {
                return null;
            }

            public Enumeration<?> getParameterNames() {
                return null;
            }

            public Object getAttribute(String name) {
                return null;
            }

            public String getRequestURI() {
                return "/";
            }

            public String getRemoteUser() {
                return null;
            }

            public String getHeader(String name) {
                return null;
            }

            public String getCookieValue(String name) {
                return null;
            }

            public HeaderType getHeaderType() {
                return HeaderType.HTTP;
            }
        };
        DUMMY_RESPONSE = new Response(){

            public int getStatus() throws Exception {
                Agent.LOG.log(Level.FINEST, "Web response is not set. Using default status code 0.");
                return 0;
            }

            public String getStatusMessage() throws Exception {
                Agent.LOG.log(Level.FINEST, "Web response is not set. No status message.");
                return null;
            }

            public void setHeader(String name, String value) {
                Agent.LOG.log(Level.FINEST, "Web response is not set. Not setting header {0} : {1}.", new Object[]{name, value});
            }

            public String getContentType() {
                Agent.LOG.log(Level.FINEST, "Web response is not set. No content type.");
                return null;
            }

            public HeaderType getHeaderType() {
                Agent.LOG.log(Level.FINEST, "Web response is not set. Header type is HTTP.");
                return HeaderType.HTTP;
            }
        };
        TRACED_ACTIVITY_CLASS_METHOD_SIG = new ClassMethodSignature("TracedActivity", "unnamed", "()V");
        TRACED_ACTIVITY_INVOKER = null;
    }

    public static class CancellationException
    extends RuntimeException {
        public CancellationException() {
        }

        public CancellationException(String message) {
            super(message);
        }
    }

    private static class AppNameAndConfig {
        private final PriorityApplicationName appName;
        private volatile AgentConfig appConfig;

        AppNameAndConfig(PriorityApplicationName name) {
            this(name, null);
        }

        AppNameAndConfig(PriorityApplicationName name, AgentConfig config) {
            this.appName = name;
            this.appConfig = config;
        }

        PriorityApplicationName getName() {
            return this.appName;
        }

        AgentConfig getConfig() {
            if (this.appConfig == null) {
                this.appConfig = ServiceFactory.getConfigService().getAgentConfig(this.appName.getName());
            }
            return this.appConfig;
        }

        public static AppNameAndConfig getDefault() {
            AgentConfig defaultConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
            String appName = defaultConfig.getApplicationName();
            PriorityApplicationName pan = PriorityApplicationName.create(appName, ApplicationNamePriority.NONE);
            return new AppNameAndConfig(pan, defaultConfig);
        }
    }
}

