/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.bridge.TracedMethod;
import com.newrelic.agent.tracers.Tracer;
import java.util.concurrent.atomic.AtomicBoolean;

public class TracedActivity
implements com.newrelic.agent.bridge.TracedActivity {
    private final Tracer underlyingTracer;
    private final Tracer parent;
    private final long parentInitialExclusiveDuration;
    private final AtomicBoolean isFinished = new AtomicBoolean(false);

    public TracedActivity(Tracer parent, Tracer tracer) {
        this.parent = parent;
        this.parentInitialExclusiveDuration = parent.getExclusiveDuration();
        this.underlyingTracer = tracer;
    }

    public TracedMethod getTracedMethod() {
        return this.underlyingTracer;
    }

    public void setAsyncThreadName(String threadName) {
        this.underlyingTracer.getTransactionActivity().setThreadName(threadName);
    }

    public Tracer getParent() {
        return this.parent;
    }

    public Tracer getTracer() {
        return this.underlyingTracer;
    }

    public long getParentInitialExclusiveDuration() {
        return this.parentInitialExclusiveDuration;
    }

    public void ignoreIfUnfinished() {
        if (!this.isFinished.getAndSet(true)) {
            this.parent.getTransactionActivity().getTransaction().ignoreTracedActivityIfUnfinished(this);
        }
    }

    public void finish() {
        this.finish(null);
    }

    public void finish(Throwable t) {
        if (!this.isFinished.getAndSet(true)) {
            this.parent.getTransactionActivity().getTransaction().finishTracedActivity(this, t);
        }
    }
}

